/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.AbstractFileSystemAccess2;
import org.eclipse.xtext.generator.IFilePostProcessor;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.util.StringInputStream;

public class InMemoryFileSystemAccess
extends AbstractFileSystemAccess2 {
    private Map<String, Object> files = Maps.newTreeMap();
    private String textFileEnconding;

    @Override
    public void generateFile(String fileName, String outputConfigName, CharSequence contents) {
        String encoding = this.getTextFileEncoding();
        contents = encoding != null ? this.postProcess(fileName, outputConfigName, contents, encoding) : this.postProcess(fileName, outputConfigName, contents);
        this.files.put(this.getFileName(fileName, outputConfigName), contents);
    }

    public String getTextFileEncoding() {
        return this.textFileEnconding;
    }

    public void setTextFileEnconding(String textFileEnconding) {
        this.textFileEnconding = textFileEnconding;
    }

    @Override
    public void setPostProcessor(IFilePostProcessor postProcessor) {
        super.setPostProcessor(postProcessor);
    }

    protected String getFileName(String fileName, String outputConfigName) {
        return outputConfigName + fileName;
    }

    @Override
    public void deleteFile(String fileName, String outputConfigName) {
        this.files.remove(this.getFileName(fileName, outputConfigName));
    }

    public Map<String, CharSequence> getTextFiles() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<String, Object> e : this.files.entrySet()) {
            if (!(e.getValue() instanceof CharSequence)) continue;
            result.put(e.getKey(), (CharSequence)e.getValue());
        }
        return result;
    }

    public Map<String, byte[]> getBinaryFiles() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<String, Object> e : this.files.entrySet()) {
            if (!(e.getValue() instanceof byte[])) continue;
            result.put(e.getKey(), (byte[])e.getValue());
        }
        return result;
    }

    public Map<String, Object> getAllFiles() {
        return this.files;
    }

    @Deprecated
    public Map<String, CharSequence> getFiles() {
        return this.getTextFiles();
    }

    @Override
    public URI getURI(String fileName, String outputConfiguration) {
        return URI.createURI((String)("memory:/" + outputConfiguration + "/" + fileName));
    }

    @Override
    public void generateFile(String fileName, String outputCfgName, InputStream content) {
        try {
            try {
                byte[] byteArray = ByteStreams.toByteArray((InputStream)content);
                this.files.put(this.getFileName(fileName, outputCfgName), byteArray);
            }
            finally {
                content.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    @Override
    public InputStream readBinaryFile(String fileName, String outputCfgName) throws RuntimeIOException {
        String name = this.getFileName(fileName, outputCfgName);
        Object contents = this.files.get(name);
        if (contents == null) {
            throw new RuntimeIOException("File not found: " + name);
        }
        if (contents instanceof byte[]) {
            return new ByteArrayInputStream((byte[])contents);
        }
        if (contents instanceof CharSequence) {
            return new StringInputStream(contents.toString());
        }
        throw new RuntimeIOException("Unknown File Data Type: " + String.valueOf(contents.getClass()) + " File: " + name);
    }

    @Override
    public CharSequence readTextFile(String fileName, String outputCfgName) throws RuntimeIOException {
        String name = this.getFileName(fileName, outputCfgName);
        Object contents = this.files.get(name);
        if (contents == null) {
            throw new RuntimeIOException("File not found: " + name);
        }
        if (contents instanceof CharSequence) {
            return (CharSequence)contents;
        }
        if (contents instanceof byte[]) {
            throw new RuntimeIOException("Can not read a binary file using readTextFile(). File: " + name);
        }
        throw new RuntimeIOException("Unknown File Data Type: " + String.valueOf(contents.getClass()) + " File: " + name);
    }
}

