/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.trace.AbstractURIWrapper;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;

public class AbsoluteURI
extends AbstractURIWrapper {
    public AbsoluteURI(URI absoluteURI) {
        super(absoluteURI);
        if (absoluteURI.isRelative() || !absoluteURI.isHierarchical()) {
            throw new IllegalArgumentException(absoluteURI.toString());
        }
    }

    public AbsoluteURI(String absoluteURI) {
        this(URI.createURI((String)absoluteURI));
    }

    public SourceRelativeURI deresolve(URI sourceFolderURI) {
        try {
            return new SourceRelativeURI(this.getURI().deresolve(sourceFolderURI));
        }
        catch (IllegalArgumentException t) {
            throw new IllegalArgumentException("Base URI was " + this.getURI(), t);
        }
    }

    public SourceRelativeURI deresolve(ISourceFolder sourceFolder) {
        return this.deresolve(sourceFolder.getPath());
    }

    public SourceRelativeURI deresolve(IProjectConfig projectConfig) {
        ISourceFolder sourceFolder = projectConfig.findSourceFolderContaining(this.getURI());
        return sourceFolder != null ? this.deresolve(sourceFolder) : null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && !Objects.equal(obj.getClass(), AbsoluteURI.class)) {
            throw new IllegalArgumentException(String.valueOf(obj.toString()) + " instanceof " + obj.getClass().getName());
        }
        return super.equals(obj);
    }
}

