/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.impl.DefaultResourceDescription;
import org.eclipse.xtext.resource.impl.EObjectDescriptionLookUp;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xtype.XImportDeclaration;

public class XbaseResourceDescription
extends DefaultResourceDescription {
    private IBatchTypeResolver typeResolver;
    private IQualifiedNameConverter nameConverter;
    private Set<QualifiedName> importedNames;

    public XbaseResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy, IResourceScopeCache cache, IBatchTypeResolver typeResolver, IQualifiedNameConverter nameConverter) {
        super(resource, strategy, cache);
        this.typeResolver = typeResolver;
        this.nameConverter = nameConverter;
    }

    protected EObjectDescriptionLookUp getLookUp() {
        if (this.lookup == null) {
            this.lookup = new EObjectDescriptionLookUp(this.computeExportedObjects());
        }
        return this.lookup;
    }

    public Iterable<QualifiedName> getImportedNames() {
        if (this.importedNames != null) {
            return this.importedNames;
        }
        Set<QualifiedName> result = this.createEmptyImportedNamesSet();
        Resource resource = this.getResource();
        EList contents = resource.getContents();
        if (!contents.isEmpty()) {
            IResolvedTypes types = this.typeResolver.resolveTypes(resource);
            TreeIterator iter = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
            while (iter.hasNext()) {
                JvmIdentifiableElement casted;
                LightweightTypeReference typeRef;
                Object content = iter.next();
                if (content instanceof XExpression) {
                    JvmIdentifiableElement feature;
                    XAbstractFeatureCall casted2;
                    LightweightTypeReference typeReference = types.getActualType((XExpression)content);
                    if (typeReference != null) {
                        this.registerAllTypes(typeReference.getType(), result);
                    }
                    if (content instanceof XMemberFeatureCall && (casted2 = (XMemberFeatureCall)content).getFeature() != null && casted2.getFeature().eIsProxy() && !casted2.isExplicitOperationCallOrBuilderSyntax()) {
                        XExpression receiver = casted2.getActualReceiver();
                        if (!(receiver instanceof XAbstractFeatureCall) || !((XAbstractFeatureCall)receiver).isTypeLiteral()) continue;
                        JvmIdentifiableElement type = ((XAbstractFeatureCall)receiver).getFeature();
                        QualifiedName maybeType = this.nameConverter.toQualifiedName(type.getIdentifier() + "$" + casted2.getConcreteSyntaxFeatureName()).toLowerCase();
                        result.add(maybeType);
                        continue;
                    }
                    if (content instanceof XAbstractFeatureCall && (casted2 = (XAbstractFeatureCall)content).isTypeLiteral() && (feature = casted2.getFeature()) instanceof JvmDeclaredType) {
                        this.registerAllTypes((JvmType)feature, result);
                    }
                }
                if (content instanceof XImportDeclaration) {
                    this.registerAllTypes((JvmType)((XImportDeclaration)content).getImportedType(), result);
                }
                if (!(content instanceof JvmIdentifiableElement) || content instanceof JvmType && !(content instanceof JvmDeclaredType) || (typeRef = types.getActualType(casted = (JvmIdentifiableElement)content)) == null) continue;
                this.registerAllTypes(typeRef.getType(), result);
            }
        }
        Iterables.addAll(result, (Iterable)super.getImportedNames());
        this.importedNames = Collections.unmodifiableSet(result);
        return this.importedNames;
    }

    protected Set<QualifiedName> createEmptyImportedNamesSet() {
        return new PrimitiveNamesFilteringSet();
    }

    protected void registerAllTypes(JvmType type, Set<QualifiedName> result) {
        if (type == null || type.eIsProxy()) {
            return;
        }
        if (!this.isLocal(type) && type instanceof JvmDeclaredType && result.add(this.nameConverter.toQualifiedName(type.getIdentifier()).toLowerCase()) && type instanceof JvmGenericType) {
            JvmGenericType genericType = (JvmGenericType)type;
            this.registerAllTypes((JvmType)genericType.getDeclaringType(), result);
            JvmTypeReference extendedClass = genericType.getExtendedClass();
            if (extendedClass != null) {
                this.registerAllTypes(extendedClass.getType(), result);
            }
            for (JvmTypeReference intf : genericType.getExtendedInterfaces()) {
                this.registerAllTypes(intf.getType(), result);
            }
        }
    }

    protected boolean isLocal(JvmType type) {
        return type instanceof JvmGenericType && ((JvmGenericType)type).isLocal();
    }

    protected static class PrimitiveNamesFilteringSet
    extends HashSet<QualifiedName> {
        private static final long serialVersionUID = 1L;

        protected PrimitiveNamesFilteringSet() {
        }

        @Override
        public boolean add(QualifiedName e) {
            if (e != null) {
                switch (e.getLastSegment()) {
                    case "boolean": 
                    case "int": 
                    case "char": 
                    case "byte": 
                    case "short": 
                    case "long": 
                    case "double": 
                    case "float": 
                    case "void": {
                        return false;
                    }
                }
                return super.add(e);
            }
            return false;
        }
    }
}

