/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.wizard.ecore2xtext;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtext.wizard.Ecore2XtextConfiguration;
import org.eclipse.xtext.xtext.wizard.ecore2xtext.UniqueNameUtil;

public class Ecore2XtextExtensions {
    public static Iterable<EClassifier> allConcreteRuleClassifiers(Ecore2XtextConfiguration it) {
        boolean _tripleEquals;
        Iterable _xifexpression = null;
        EClass _rootElementClass = it.getRootElementClass();
        boolean bl = _tripleEquals = _rootElementClass == null;
        if (_tripleEquals) {
            Functions.Function1 _function = it_1 -> Ecore2XtextExtensions.allReferencedClassifiers(it_1.getEPackage(), false);
            Functions.Function1 _function_1 = it_1 -> Ecore2XtextExtensions.needsConcreteRule(it_1);
            _xifexpression = IterableExtensions.filter((Iterable)IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map(it.getEPackageInfos(), (Functions.Function1)_function))), (Functions.Function1)_function_1);
        } else {
            Set _xblockexpression = null;
            ArrayList c = CollectionLiterals.newArrayList((Object[])new EClassifier[]{(EClassifier)EClassifier.class.cast(it.getRootElementClass())});
            Ecore2XtextExtensions.allAssignedClassifiers(it.getRootElementClass(), c);
            Functions.Function1 _function_2 = cl -> Ecore2XtextExtensions.needsConcreteRule(cl);
            _xblockexpression = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)c, (Functions.Function1)_function_2));
            _xifexpression = _xblockexpression;
        }
        return _xifexpression;
    }

    public static Collection<EClass> allDispatcherRuleClasses(Ecore2XtextConfiguration it) {
        boolean _tripleEquals;
        Set _xifexpression = null;
        EClass _rootElementClass = it.getRootElementClass();
        boolean bl = _tripleEquals = _rootElementClass == null;
        if (_tripleEquals) {
            Functions.Function1 _function = it_1 -> Ecore2XtextExtensions.allReferencedClassifiers(it_1.getEPackage(), false);
            Functions.Function1 _function_1 = c -> Ecore2XtextExtensions.needsDispatcherRule(c);
            _xifexpression = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map(it.getEPackageInfos(), (Functions.Function1)_function))), (Functions.Function1)_function_1), EClass.class));
        } else {
            Functions.Function1 _function_2 = c -> {
                Functions.Function1 _function_3 = r -> Ecore2XtextExtensions.needsAssignment((EStructuralFeature)r);
                Functions.Function1 _function_4 = it_1 -> it_1.getEType();
                return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)c.getEAllReferences(), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
            };
            _xifexpression = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(Ecore2XtextExtensions.allConcreteRuleClassifiers(it), EClass.class), (Functions.Function1)_function_2)), EClass.class));
        }
        return _xifexpression;
    }

    public static Collection<EPackage> allReferencedEPackages(Ecore2XtextConfiguration prjInfo) {
        Functions.Function1 _function = it -> Ecore2XtextExtensions.allReferencedEPackages(it.getEPackage(), true);
        return IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map(prjInfo.getEPackageInfos(), (Functions.Function1)_function)));
    }

    public static Set<EPackage> allReferencedEPackages(EPackage ePack, boolean includeCrossRefs) {
        Functions.Function1 _function = it -> it.getEPackage();
        return IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map(Ecore2XtextExtensions.allReferencedClassifiers(ePack, includeCrossRefs), (Functions.Function1)_function)));
    }

    public static Set<EClassifier> allReferencedClassifiers(EPackage ePack, boolean includeCrossRefs) {
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = f -> Ecore2XtextExtensions.needsAssignment(f) && (includeCrossRefs || Ecore2XtextExtensions.isContainment(f));
            return IterableExtensions.filter((Iterable)it.getEAllStructuralFeatures(), (Functions.Function1)_function_1);
        };
        Iterable strFeatures = IterableExtensions.map((Iterable)Iterables.filter((Iterable)ePack.getEClassifiers(), EClass.class), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> it.getEType();
        Set refTypes = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)strFeatures), (Functions.Function1)_function_1));
        EList _eClassifiers = ePack.getEClassifiers();
        Set retVal = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)_eClassifiers, (Iterable)refTypes));
        retVal.add(UniqueNameUtil.eString());
        return retVal;
    }

    private static void allAssignedClassifiers(EClass eClazz, Collection<EClassifier> acceptor) {
        Functions.Function1 _function = f -> Ecore2XtextExtensions.needsAssignment(f);
        Functions.Function1 _function_1 = it -> it.getEType();
        List classifiers = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)eClazz.getEAllStructuralFeatures(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        Iterable<EClass> _subClasses = Ecore2XtextExtensions.subClasses(eClazz);
        Iterables.addAll((Collection)classifiers, _subClasses);
        classifiers.removeAll(acceptor);
        boolean _isEmpty = classifiers.isEmpty();
        if (_isEmpty) {
            return;
        }
        Iterables.addAll(acceptor, (Iterable)classifiers);
        Consumer<EClass> _function_2 = c -> Ecore2XtextExtensions.allAssignedClassifiers(c, acceptor);
        Iterables.filter((Iterable)classifiers, EClass.class).forEach(_function_2);
    }

    public static String fqn(EClassifier it) {
        boolean _tripleEquals;
        String _xifexpression = null;
        EPackage _ePackage = it.getEPackage();
        String _uniqueName = null;
        if (_ePackage != null) {
            _uniqueName = UniqueNameUtil.uniqueName((ENamedElement)_ePackage);
        }
        boolean bl = _tripleEquals = _uniqueName == null;
        if (_tripleEquals) {
            _xifexpression = Ecore2XtextExtensions.quoteIfNeccesary(it.getName());
        } else {
            String _uniqueName_1 = UniqueNameUtil.uniqueName((ENamedElement)it.getEPackage());
            String _plus = _uniqueName_1 + "::";
            String _quoteIfNeccesary = Ecore2XtextExtensions.quoteIfNeccesary(it.getName());
            _xifexpression = _plus + _quoteIfNeccesary;
        }
        return _xifexpression;
    }

    public static Iterable<EStructuralFeature> prefixFeatures(EClass it) {
        Functions.Function1 _function = f -> Ecore2XtextExtensions.needsAssignment(f) && Ecore2XtextExtensions.isPrefixBooleanFeature(f);
        return IterableExtensions.filter((Iterable)it.getEAllStructuralFeatures(), (Functions.Function1)_function);
    }

    public static Iterable<EStructuralFeature> inlinedFeatures(EClass it) {
        Functions.Function1 _function = f -> Ecore2XtextExtensions.needsAssignment(f);
        List features = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)it.getEAllStructuralFeatures(), (Functions.Function1)_function));
        features.remove(Ecore2XtextExtensions.idAttribute(it));
        features.removeAll(IterableExtensions.toList(Ecore2XtextExtensions.prefixFeatures(it)));
        return features;
    }

    public static boolean onlyOptionalFeatures(EClass it) {
        boolean _xblockexpression = false;
        Iterable<EStructuralFeature> _prefixFeatures = Ecore2XtextExtensions.prefixFeatures(it);
        Iterable<EStructuralFeature> _inlinedFeatures = Ecore2XtextExtensions.inlinedFeatures(it);
        Iterable features = Iterables.concat(_prefixFeatures, _inlinedFeatures);
        Functions.Function1 _function = f -> f.isRequired();
        _xblockexpression = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)features, (Functions.Function1)_function));
        return _xblockexpression;
    }

    public static String assignedRuleCall(EAttribute it) {
        String _xifexpression = null;
        boolean _isPrefixBooleanFeature = Ecore2XtextExtensions.isPrefixBooleanFeature((EStructuralFeature)it);
        if (_isPrefixBooleanFeature) {
            String _name = it.getName();
            String _plus = "'" + _name;
            _xifexpression = _plus + "'";
        } else {
            _xifexpression = UniqueNameUtil.uniqueName((ENamedElement)it.getEType());
        }
        return _xifexpression;
    }

    public static String concreteRuleName(EClass it) {
        String _xifexpression = null;
        boolean _needsDispatcherRule = Ecore2XtextExtensions.needsDispatcherRule((EClassifier)it);
        _xifexpression = _needsDispatcherRule ? UniqueNameUtil.uniqueImplName((ENamedElement)it) : UniqueNameUtil.uniqueName((ENamedElement)it);
        return _xifexpression;
    }

    public static String dataTypeRuleBody(EDataType it) {
        String _switchResult = null;
        String _name = it.getName();
        if (_name != null) {
            switch (_name) {
                case "EBigDecimal": {
                    _switchResult = "INT? '.' INT";
                    break;
                }
                case "EBigInteger": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EBoolean": {
                    _switchResult = Ecore2XtextExtensions.booleanRuleBody();
                    break;
                }
                case "EBooleanObject": {
                    _switchResult = Ecore2XtextExtensions.booleanRuleBody();
                    break;
                }
                case "EByte": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EByteObject": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EChar": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "ECharObject": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EDouble": {
                    _switchResult = Ecore2XtextExtensions.decimalRuleBody();
                    break;
                }
                case "EDoubleObject": {
                    _switchResult = Ecore2XtextExtensions.decimalRuleBody();
                    break;
                }
                case "EFloat": {
                    _switchResult = Ecore2XtextExtensions.decimalRuleBody();
                    break;
                }
                case "EFloatObject": {
                    _switchResult = Ecore2XtextExtensions.decimalRuleBody();
                    break;
                }
                case "EInt": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EIntegerObject": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "ELong": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "ELongObject": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EShort": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EShortObject": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EString": {
                    _switchResult = "STRING | ID";
                    break;
                }
                default: {
                    String _name_1 = it.getName();
                    String _plus = "'" + _name_1;
                    _switchResult = _plus + "' /* TODO: implement this rule and an appropriate IValueConverter */";
                    break;
                }
            }
        } else {
            String _name_1 = it.getName();
            String _plus = "'" + _name_1;
            _switchResult = _plus + "' /* TODO: implement this rule and an appropriate IValueConverter */";
        }
        return _switchResult;
    }

    public static String intRuleBody() {
        return "'-'? INT";
    }

    public static String decimalRuleBody() {
        return "'-'? INT? '.' INT (('E'|'e') '-'? INT)?";
    }

    public static String booleanRuleBody() {
        return "'true' | 'false'";
    }

    public static String assignmentKeyword(EStructuralFeature it) {
        String _xifexpression = null;
        boolean _isPrefixBooleanFeature = Ecore2XtextExtensions.isPrefixBooleanFeature(it);
        if (_isPrefixBooleanFeature) {
            _xifexpression = "";
        } else {
            String _name = it.getName();
            String _plus = "'" + _name;
            _xifexpression = _plus + "' ";
        }
        return _xifexpression;
    }

    public static String quoteIfNeccesary(String str) {
        String _xifexpression = null;
        boolean _isXtextKeyword = Ecore2XtextExtensions.isXtextKeyword(str);
        _xifexpression = _isXtextKeyword ? "^" + str : str;
        return _xifexpression;
    }

    public static boolean isXtextKeyword(String str) {
        return CollectionLiterals.newArrayList((Object[])new String[]{"returns", "generate", "terminal", "with", "hidden", "enum", "grammar", "import", "as", "current", "fragment", "EOF"}).contains(str);
    }

    public static EAttribute idAttribute(EClass it) {
        EAttribute _xblockexpression = null;
        EAttribute idAttr = Ecore2XtextExtensions.idAttributeInternal(it);
        EAttribute _xifexpression = null;
        if (idAttr != null) {
            _xifexpression = idAttr;
        } else {
            Functions.Function1 _function = a -> Ecore2XtextExtensions.needsAssignment((EStructuralFeature)a) && Objects.equal((Object)a.getName(), (Object)"name") && Objects.equal((Object)a.getEType().getName(), (Object)"EString") && !a.isMany();
            _xifexpression = (EAttribute)IterableExtensions.findFirst((Iterable)it.getEAllAttributes(), (Functions.Function1)_function);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private static EAttribute idAttributeInternal(EClass it) {
        Functions.Function1 _function = a -> Ecore2XtextExtensions.needsAssignment((EStructuralFeature)a) && a.isID();
        return (EAttribute)IterableExtensions.findFirst((Iterable)it.getEAllAttributes(), (Functions.Function1)_function);
    }

    public static boolean isBoolean(EClassifier it) {
        return it instanceof EDataType && CollectionLiterals.newArrayList((Object[])new String[]{"EBoolean", "EBooleanObject"}).contains(it.getName()) && Ecore2XtextExtensions.isEcoreType(it);
    }

    public static boolean isPrefixBooleanFeature(EStructuralFeature it) {
        return Ecore2XtextExtensions.isBoolean(it.getEType()) && !it.isMany() && !Objects.equal((Object)it.getDefaultValueLiteral(), (Object)"true");
    }

    public static boolean isString(EClassifier it) {
        return it instanceof EDataType && Objects.equal((Object)it.getName(), (Object)"EString") && Ecore2XtextExtensions.isEcoreType(it);
    }

    public static boolean isEcoreType(EClassifier it) {
        EPackage _ePackage = it.getEPackage();
        String _nsURI = null;
        if (_ePackage != null) {
            _nsURI = _ePackage.getNsURI();
        }
        return Objects.equal((Object)_nsURI, (Object)"http://www.eclipse.org/emf/2002/Ecore");
    }

    public static boolean isID(EStructuralFeature it) {
        return it instanceof EAttribute && ((EAttribute)EAttribute.class.cast(it)).isID();
    }

    public static boolean needsAssignment(EStructuralFeature it) {
        return !(!it.isChangeable() || it.isDerived() || it.isTransient() || it instanceof EReference && ((EReference)EReference.class.cast(it)).isContainer() || it.getEType() instanceof EDataType && !((EDataType)EDataType.class.cast(it.getEType())).isSerializable());
    }

    public static boolean needsConcreteRule(EClassifier eClassifier) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (eClassifier instanceof EClass) {
            _matched = true;
            boolean bl = _switchResult = !((EClass)eClassifier).isAbstract() && !((EClass)eClassifier).isInterface();
        }
        if (!_matched) {
            _switchResult = true;
        }
        return _switchResult;
    }

    public static boolean needsDispatcherRule(EClassifier eClassifier) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (eClassifier instanceof EClass) {
            _matched = true;
            Functions.Function1 _function = c -> Ecore2XtextExtensions.needsConcreteRule((EClassifier)c);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter(Ecore2XtextExtensions.subClasses((EClass)eClassifier), (Functions.Function1)_function));
            boolean bl = _switchResult = !_isEmpty;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static boolean isContainment(EStructuralFeature eStrFeat) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (eStrFeat instanceof EAttribute) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && eStrFeat instanceof EReference) {
            _matched = true;
            _switchResult = ((EReference)eStrFeat).isContainment();
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static Iterable<EClass> subClasses(EClass it) {
        boolean _tripleEquals;
        Iterable _xifexpression = null;
        EPackage _ePackage = it.getEPackage();
        boolean bl = _tripleEquals = _ePackage == null;
        if (_tripleEquals) {
            _xifexpression = CollectionLiterals.emptyList();
        } else {
            Functions.Function1 _function = c -> c.getEAllSuperTypes().contains((Object)it);
            _xifexpression = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)it.getEPackage().getEClassifiers(), EClass.class), (Functions.Function1)_function);
        }
        return _xifexpression;
    }

    public static Iterable<EAttribute> allAttributes(EClass it) {
        return Iterables.filter(Ecore2XtextExtensions.inlinedFeatures(it), EAttribute.class);
    }

    public static Iterable<EReference> allCrossReferences(EClass it) {
        Functions.Function1 _function = f -> {
            boolean _isContainment = f.isContainment();
            return !_isContainment;
        };
        return IterableExtensions.filter((Iterable)Iterables.filter(Ecore2XtextExtensions.inlinedFeatures(it), EReference.class), (Functions.Function1)_function);
    }

    public static Iterable<EReference> allContainmentReferences(EClass it) {
        Functions.Function1 _function = f -> f.isContainment();
        return IterableExtensions.filter((Iterable)Iterables.filter(Ecore2XtextExtensions.inlinedFeatures(it), EReference.class), (Functions.Function1)_function);
    }
}

