/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.xtext.formatting2.IMerger;
import org.eclipse.xtext.formatting2.ITextSegment;
import org.eclipse.xtext.formatting2.internal.ConflictingRegionsException;
import org.eclipse.xtext.formatting2.internal.RegionComparator;
import org.eclipse.xtext.formatting2.internal.RegionTrace;
import org.eclipse.xtext.formatting2.internal.TextSegmentSet;

public class ArrayListTextSegmentSet<T>
extends TextSegmentSet<T> {
    private final List<T> contents = Lists.newArrayList();

    public ArrayListTextSegmentSet(Function<? super T, ? extends ITextSegment> region, Function<? super T, String> title) {
        super(region, title);
    }

    @Override
    public void add(T segment, IMerger<T> merger) throws ConflictingRegionsException {
        Preconditions.checkNotNull(segment);
        this.getTraces().put(segment, new RegionTrace(this.getTitle(segment), this.getRegion(segment)));
        if (this.contents.isEmpty()) {
            this.contents.add(segment);
        } else {
            int searchResult = Collections.binarySearch(this.contents, segment, new RegionComparator(this.getRegionAccess()));
            if (searchResult >= 0) {
                this.replaceExistingEntry(segment, searchResult, merger);
            } else {
                this.insertAtIndex(segment, -searchResult - 1, merger);
            }
        }
    }

    @Override
    public T get(T segment) {
        int searchResult = Collections.binarySearch(this.contents, segment, new RegionComparator(this.getRegionAccess()));
        return searchResult >= 0 ? (T)this.contents.get(searchResult) : null;
    }

    protected void insertAtIndex(T segment, int newIndex, IMerger<T> merger) throws ConflictingRegionsException {
        ArrayList conflicting = null;
        int low = newIndex;
        while (--low >= 0) {
            T item = this.contents.get(low);
            if (!this.isConflict(item, segment)) break;
            if (conflicting == null) {
                conflicting = Lists.newArrayList();
            }
            conflicting.add(item);
        }
        int high = newIndex - 1;
        while (++high < this.contents.size()) {
            T item = this.contents.get(high);
            if (!this.isConflict(item, segment)) break;
            if (conflicting == null) {
                conflicting = Lists.newArrayList();
            }
            conflicting.add(item);
        }
        if (conflicting == null) {
            this.getTraces().put(segment, new RegionTrace(this.getTitle(segment), this.getRegion(segment)));
            this.contents.add(newIndex, segment);
        } else {
            conflicting.add(0, segment);
            try {
                Object merged;
                Object e = merged = merger != null ? (Object)merger.merge(conflicting) : null;
                if (merged != null) {
                    int i = high - 1;
                    while (i > low) {
                        this.contents.remove(i);
                        --i;
                    }
                    this.getTraces().put(merged, new RegionTrace(this.getTitle(merged), this.getRegion(merged)));
                    this.contents.add(low + 1, merged);
                } else {
                    int segmentLengh = this.getRegion(segment).getLength();
                    int totalLength = 0;
                    int i = 1;
                    while (i < conflicting.size()) {
                        totalLength += this.getRegion(conflicting.get(i)).getLength();
                        ++i;
                    }
                    if (segmentLengh >= totalLength) {
                        i = high - 1;
                        while (i > low) {
                            this.contents.remove(i);
                            --i;
                        }
                    }
                    if (segmentLengh > totalLength) {
                        this.getTraces().put(segment, new RegionTrace(this.getTitle(segment), this.getRegion(segment)));
                        this.contents.add(low + 1, segment);
                    }
                    this.handleConflict(conflicting, null);
                }
            }
            catch (ConflictingRegionsException e) {
                throw e;
            }
            catch (Exception e) {
                this.handleConflict(conflicting, e);
            }
        }
    }

    @Override
    public Iterator<T> iterator() {
        return Iterables.unmodifiableIterable(this.contents).iterator();
    }

    protected void replaceExistingEntry(T segment, int index, IMerger<T> merger) throws ConflictingRegionsException {
        T existing = this.contents.get(index);
        ImmutableList conflicting = ImmutableList.of(segment, existing);
        try {
            Object merged;
            Object e = merged = merger != null ? (Object)merger.merge((List<T>)conflicting) : null;
            if (merged != null) {
                this.getTraces().put(merged, new RegionTrace(this.getTitle(merged), this.getRegion(merged)));
                this.contents.set(index, merged);
            } else {
                this.contents.remove(index);
                this.handleConflict(conflicting, (Exception)null);
            }
        }
        catch (ConflictingRegionsException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleConflict(conflicting, e);
        }
    }
}

