/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.contentassist;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.editor.contentassist.ISmartContextInformation;
import org.eclipse.xtext.xbase.ui.contentassist.ParameterData;

public class ParameterContextInformation
implements ISmartContextInformation {
    private final ParameterData data;
    private final String contextDisplayString;
    private int parameterListOffset;
    private int currentParameter = -1;
    private int initialCaretOffset;

    public ParameterContextInformation(ParameterData data, String contextDisplayString, int parameterListOffset, int initialCarretOffset) {
        this.data = data;
        this.contextDisplayString = contextDisplayString;
        this.parameterListOffset = parameterListOffset;
        this.initialCaretOffset = initialCarretOffset;
    }

    public boolean equals(Object object) {
        if (object instanceof IContextInformation) {
            IContextInformation contextInformation = (IContextInformation)object;
            boolean equals = this.getInformationDisplayString().equalsIgnoreCase(contextInformation.getInformationDisplayString());
            if (this.getContextDisplayString() != null) {
                equals = equals && this.getContextDisplayString().equalsIgnoreCase(contextInformation.getContextDisplayString());
            }
            return equals;
        }
        return false;
    }

    public int hashCode() {
        int low = this.getContextDisplayString() != null ? this.getContextDisplayString().hashCode() : 0;
        return this.getInformationDisplayString().hashCode() << 16 | low;
    }

    public String getInformationDisplayString() {
        return this.data.getDisplayString();
    }

    public List<String> internalGetInformationDisplayString() {
        return this.data.getRawDisplayString();
    }

    public Image getImage() {
        return null;
    }

    public String getContextDisplayString() {
        return this.contextDisplayString;
    }

    public int getContextInformationPosition() {
        return this.initialCaretOffset;
    }

    public void setContextInformationPosition(int pos) {
        this.initialCaretOffset = pos;
    }

    public boolean isContextInformationValid(ITextViewer viewer, int position) {
        IDocument document;
        block5: {
            block4: {
                try {
                    if (position >= this.parameterListOffset) break block4;
                    return false;
                }
                catch (BadLocationException x) {
                    return false;
                }
            }
            document = viewer.getDocument();
            IRegion line = document.getLineInformationOfOffset(this.parameterListOffset);
            if (position >= line.getOffset() && position < document.getLength()) break block5;
            return false;
        }
        return this.getCharCount(document, this.parameterListOffset, position, "(<", ")>", false) >= 0;
    }

    public boolean updatePresentation(ITextViewer viewer, int position, TextPresentation presentation) {
        int currentParameter = -1;
        try {
            currentParameter = this.getCharCount(viewer.getDocument(), this.parameterListOffset, position, ",", "", true);
        }
        catch (BadLocationException x) {
            return false;
        }
        if (currentParameter != -1 && currentParameter == this.currentParameter) {
            return false;
        }
        presentation.clear();
        this.currentParameter = currentParameter;
        List<String> rawStrings = this.internalGetInformationDisplayString();
        ArrayList commaArrays = Lists.newArrayList();
        for (String s : rawStrings) {
            commaArrays.add(this.computeCommaPositions(s));
        }
        int offset = 0;
        int i = 0;
        while (i < rawStrings.size()) {
            String raw = rawStrings.get(i);
            int[] commas = (int[])commaArrays.get(i);
            if (commas.length - 2 < this.currentParameter && !this.data.isVarArgs(i)) {
                presentation.addStyleRange(new StyleRange(offset, raw.length(), JFaceResources.getColorRegistry().get("QUALIFIER_COLOR"), null, 0));
            } else {
                int actualParameter = this.currentParameter;
                if (actualParameter + 1 >= commas.length) {
                    actualParameter = commas.length - 2;
                }
                int start = commas[actualParameter] + 1;
                int end = commas[actualParameter + 1];
                if (start > 0) {
                    presentation.addStyleRange(new StyleRange(offset, start, null, null, 0));
                }
                if (end > start) {
                    presentation.addStyleRange(new StyleRange(offset + start, end - start, null, null, 1));
                }
                if (end < raw.length()) {
                    presentation.addStyleRange(new StyleRange(offset + end, raw.length() - end, null, null, 0));
                }
            }
            offset += raw.length() + 1;
            ++i;
        }
        return true;
    }

    protected int[] computeCommaPositions(String code) {
        int length = code.length();
        int pos = 0;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        positions.add(-1);
        while (pos < length && pos != -1) {
            char ch = code.charAt(pos);
            switch (ch) {
                case ',': {
                    positions.add(pos);
                    break;
                }
                case '<': {
                    pos = this.advance(code, length, pos, '<', '>');
                    break;
                }
                case '[': {
                    pos = this.advance(code, length, pos, '[', ']');
                    break;
                }
                case '(': {
                    pos = this.advance(code, length, pos, '(', ')');
                    break;
                }
            }
            if (pos == -1) continue;
            ++pos;
        }
        positions.add(length);
        int[] fields = new int[positions.size()];
        int i = 0;
        while (i < fields.length) {
            fields[i] = (Integer)positions.get(i);
            ++i;
        }
        return fields;
    }

    protected int advance(String code, int length, int pos, char left, char right) {
        int remaining = 1;
        ++pos;
        while (pos < length && pos != -1 && remaining > 0) {
            char ch2 = code.charAt(pos);
            if (ch2 == left) {
                ++remaining;
            } else if (ch2 == right) {
                --remaining;
            }
            ++pos;
        }
        return pos;
    }

    protected int getCharCount(IDocument document, int start, int end, String increments, String decrements, boolean considerNesting) throws BadLocationException {
        Assert.isTrue(((increments.length() != 0 || decrements.length() != 0) && !increments.equals(decrements) ? 1 : 0) != 0);
        boolean NONE = false;
        boolean BRACKET = true;
        int BRACE = 2;
        int PAREN = 3;
        int ANGLE = 4;
        int nestingMode = 0;
        int nestingLevel = 0;
        int charCount = 0;
        int offset = start;
        block13: while (offset < end) {
            char curr = document.getChar(offset++);
            switch (curr) {
                case '/': {
                    if (offset >= end) continue block13;
                    char next = document.getChar(offset);
                    if (next == '*') {
                        offset = this.getCommentEnd(document, offset + 1, end);
                        break;
                    }
                    if (next != '/') continue block13;
                    int nextLine = document.getLineOfOffset(offset) + 1;
                    if (nextLine == document.getNumberOfLines()) {
                        offset = end;
                        break;
                    }
                    offset = document.getLineOffset(nextLine);
                    break;
                }
                case '*': {
                    char next;
                    if (offset >= end || (next = document.getChar(offset)) != '/') continue block13;
                    charCount = 0;
                    ++offset;
                    break;
                }
                case '\"': 
                case '\'': {
                    offset = this.getStringEnd(document, offset, end, curr);
                    break;
                }
                case '[': {
                    if (considerNesting) {
                        if (nestingMode != 1 && nestingMode != 0) continue block13;
                        nestingMode = 1;
                        ++nestingLevel;
                        break;
                    }
                }
                case ']': {
                    if (considerNesting) {
                        if (nestingMode != true || --nestingLevel != 0) continue block13;
                        nestingMode = 0;
                        break;
                    }
                }
                case '(': {
                    if (considerNesting) {
                        if (nestingMode == 4) {
                            nestingMode = 3;
                            nestingLevel = 1;
                        }
                        if (nestingMode != 3 && nestingMode != 0) continue block13;
                        nestingMode = 3;
                        ++nestingLevel;
                        break;
                    }
                }
                case ')': {
                    if (considerNesting) {
                        if (nestingMode != 3 || --nestingLevel != 0) continue block13;
                        nestingMode = 0;
                        break;
                    }
                }
                case '{': {
                    if (considerNesting) {
                        if (nestingMode == 4) {
                            nestingMode = 2;
                            nestingLevel = 1;
                        }
                        if (nestingMode != 2 && nestingMode != 0) continue block13;
                        nestingMode = 2;
                        ++nestingLevel;
                        break;
                    }
                }
                case '}': {
                    if (considerNesting) {
                        if (nestingMode != 2 || --nestingLevel != 0) continue block13;
                        nestingMode = 0;
                        break;
                    }
                }
                case '<': {
                    if (considerNesting) {
                        if (nestingMode != 4 && (nestingMode != 0 || !this.checkGenericsHeuristic(document, offset - 1, start - 1))) continue block13;
                        nestingMode = 4;
                        ++nestingLevel;
                        break;
                    }
                }
                case '>': {
                    if (considerNesting) {
                        if (nestingMode != 4 || --nestingLevel != 0) continue block13;
                        nestingMode = 0;
                        break;
                    }
                }
                default: {
                    if (nestingLevel != 0) continue block13;
                    if (increments.indexOf(curr) >= 0) {
                        ++charCount;
                    }
                    if (decrements.indexOf(curr) < 0) continue block13;
                    --charCount;
                }
            }
        }
        return charCount;
    }

    protected int getCommentEnd(IDocument d, int pos, int end) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            if (curr != '*' || ++pos >= end || d.getChar(pos) != '/') continue;
            return pos + 1;
        }
        return end;
    }

    protected int getStringEnd(IDocument d, int pos, int end, char ch) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            ++pos;
            if (curr == '\\') {
                ++pos;
                continue;
            }
            if (curr != ch) continue;
            return pos;
        }
        return end;
    }

    protected boolean checkGenericsHeuristic(IDocument document, int end, int bound) {
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
        return scanner.looksLikeClassInstanceCreationBackward(end, bound);
    }
}

