/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ide.hover;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.ide.labels.INameLabelProvider;
import org.eclipse.xtext.ide.server.hover.HoverService;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.override.InvokedResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;
import org.eclipse.xtext.xbase.validation.UIStrings;

public class XbaseHoverService
extends HoverService {
    @Inject
    private IEObjectDocumentationProvider eObjectDocumentationProvider;
    @Inject
    private INameLabelProvider nameLabelProvider;
    @Inject
    protected UIStrings uiStrings;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private InvokedResolvedOperation.Provider invokedOperationProvider;

    public String getContents(EObject element) {
        String documentation = this.eObjectDocumentationProvider.getDocumentation(element);
        if (documentation == null) {
            return this.getSignature(element);
        }
        return this.getSignature(element) + "  \n" + documentation;
    }

    public String getSignature(EObject object) {
        return this.internalGetSignature(object, true);
    }

    protected String _signature(XConstructorCall constructorCall, boolean typeAtEnd) {
        int i;
        if (typeAtEnd) {
            throw new UnsupportedOperationException();
        }
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes((EObject)constructorCall);
        LightweightTypeReference createdType = resolvedTypes.getActualType((XExpression)constructorCall);
        final List typeArguments = resolvedTypes.getActualTypeArguments((XExpression)constructorCall);
        final int typeArgumentCount = createdType.getTypeArguments().size();
        final int constructorTypeArgumentCount = typeArguments.size();
        JvmConstructor constructor = constructorCall.getConstructor();
        ResolvedConstructor resolvedConstructor = new ResolvedConstructor(constructor, createdType){

            protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> computeContextTypeParameterMapping() {
                Map result = super.computeContextTypeParameterMapping();
                if (typeArgumentCount == constructorTypeArgumentCount) {
                    return result;
                }
                EList constructorTypeParameters = ((JvmConstructor)this.getDeclaration()).getTypeParameters();
                int i = 0;
                while (i < constructorTypeParameters.size()) {
                    result.put((JvmTypeParameter)constructorTypeParameters.get(i), new LightweightMergedBoundTypeArgument((LightweightTypeReference)typeArguments.get(i), VarianceInfo.INVARIANT));
                    ++i;
                }
                return result;
            }
        };
        StringBuilder result = new StringBuilder(250);
        if (typeArgumentCount != constructorTypeArgumentCount) {
            result.append("<");
            i = 0;
            while (i < constructorTypeArgumentCount - typeArgumentCount) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(((LightweightTypeReference)typeArguments.get(i)).getHumanReadableName());
                ++i;
            }
            result.append("> ");
        }
        result.append(constructor.getDeclaringType().getSimpleName());
        if (typeArgumentCount != 0) {
            result.append("<");
            i = constructorTypeArgumentCount - typeArgumentCount;
            while (i < constructorTypeArgumentCount) {
                if (i != constructorTypeArgumentCount - typeArgumentCount) {
                    result.append(", ");
                }
                result.append(((LightweightTypeReference)typeArguments.get(i)).getHumanReadableName());
                ++i;
            }
            result.append(">");
        }
        result.append('(');
        List parameterTypes = resolvedConstructor.getResolvedParameterTypes();
        int i2 = 0;
        while (i2 < parameterTypes.size()) {
            if (i2 != 0) {
                result.append(", ");
            }
            result.append(((LightweightTypeReference)parameterTypes.get(i2)).getHumanReadableName());
            result.append(' ').append(((JvmFormalParameter)constructor.getParameters().get(i2)).getSimpleName());
            ++i2;
        }
        result.append(')');
        List exceptions = resolvedConstructor.getResolvedExceptions();
        if (!exceptions.isEmpty()) {
            result.append(" throws ");
            int i3 = 0;
            while (i3 < exceptions.size()) {
                if (i3 != 0) {
                    result.append(", ");
                }
                result.append(((LightweightTypeReference)exceptions.get(i3)).getHumanReadableName());
                ++i3;
            }
        }
        return result.toString();
    }

    protected String _signature(XAbstractFeatureCall featureCall, boolean typeAtEnd) {
        if (typeAtEnd) {
            throw new UnsupportedOperationException();
        }
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature instanceof JvmOperation) {
            InvokedResolvedOperation resolvedOperation = this.invokedOperationProvider.resolve(featureCall);
            StringBuilder result = new StringBuilder(250);
            List typeArguments = resolvedOperation.getResolvedTypeArguments();
            if (!typeArguments.isEmpty()) {
                result.append("<");
                int i = 0;
                while (i < typeArguments.size()) {
                    if (i != 0) {
                        result.append(", ");
                    }
                    result.append(((LightweightTypeReference)typeArguments.get(i)).getHumanReadableName());
                    ++i;
                }
                result.append("> ");
            }
            result.append(resolvedOperation.getResolvedReturnType().getHumanReadableName()).append(' ');
            JvmOperation operation = (JvmOperation)resolvedOperation.getDeclaration();
            result.append(this.getDeclaratorName((JvmMember)operation)).append('.');
            result.append(operation.getSimpleName()).append('(');
            List parameterTypes = resolvedOperation.getResolvedParameterTypes();
            int i = 0;
            while (i < parameterTypes.size()) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(((LightweightTypeReference)parameterTypes.get(i)).getHumanReadableName());
                result.append(' ').append(((JvmFormalParameter)operation.getParameters().get(i)).getSimpleName());
                ++i;
            }
            result.append(')');
            List exceptions = resolvedOperation.getResolvedExceptions();
            if (!exceptions.isEmpty()) {
                result.append(" throws ");
                int i2 = 0;
                while (i2 < exceptions.size()) {
                    if (i2 != 0) {
                        result.append(", ");
                    }
                    result.append(((LightweightTypeReference)exceptions.get(i2)).getHumanReadableName());
                    ++i2;
                }
            }
            return result.toString();
        }
        if (!(feature instanceof JvmConstructor)) {
            if (feature instanceof JvmField) {
                LightweightTypeReference referenceType = this.typeResolver.resolveTypes((EObject)featureCall).getActualType((XExpression)featureCall);
                StringBuilder result = new StringBuilder(250);
                result.append(referenceType.getHumanReadableName()).append(' ');
                JvmField field = (JvmField)feature;
                result.append(this.getDeclaratorName((JvmMember)field)).append('.');
                result.append(field.getSimpleName());
                return result.toString();
            }
            String simpleName = feature.getSimpleName();
            String type = this.typeResolver.resolveTypes((EObject)featureCall).getActualType((XExpression)featureCall).getHumanReadableName();
            if (simpleName != null) {
                return type + " " + simpleName;
            }
            return type;
        }
        return this.getSignature((EObject)feature);
    }

    protected String getDeclaratorName(JvmMember member) {
        return member.getDeclaringType().getSimpleName();
    }

    public String getDerivedOrSourceSignature(EObject object) {
        return this.internalGetSignature(object, true);
    }

    protected String internalGetSignature(EObject object, boolean typeAtEnd) {
        PolymorphicDispatcher polymorphicDispatcher = new PolymorphicDispatcher("_signature", 2, 2, Collections.singletonList(this), (PolymorphicDispatcher.ErrorHandler)new PolymorphicDispatcher.ErrorHandler<String>(){

            public String handle(Object[] params, Throwable throwable) {
                return null;
            }
        });
        String result = (String)polymorphicDispatcher.invoke(new Object[]{object, typeAtEnd});
        if (result != null) {
            return result;
        }
        if (object instanceof JvmIdentifiableElement) {
            return this.getLabel(object);
        }
        return this.getLabel(object);
    }

    protected String _signature(JvmGenericType clazz, boolean typeAtEnd) {
        return clazz.getSimpleName() + this.uiStrings.typeParameters((Iterable)clazz.getTypeParameters());
    }

    protected String _signature(JvmOperation jvmOperation, boolean typeAtEnd) {
        String returnTypeString = "void";
        JvmTypeReference returnType = jvmOperation.getReturnType();
        if (returnType != null) {
            if (returnType instanceof JvmAnyTypeReference) {
                throw new IllegalStateException();
            }
            returnTypeString = returnType.getSimpleName();
        }
        String signature = jvmOperation.getSimpleName() + this.uiStrings.parameters((JvmIdentifiableElement)jvmOperation) + this.getThrowsDeclaration((JvmExecutable)jvmOperation);
        String typeParameter = this.uiStrings.typeParameters((Iterable)jvmOperation.getTypeParameters());
        if (typeParameter != null && typeParameter.length() > 0) {
            if (typeAtEnd) {
                return signature + " " + typeParameter + " : " + returnTypeString;
            }
            return typeParameter + " " + returnTypeString + " " + signature;
        }
        if (typeAtEnd) {
            return signature + " : " + returnTypeString;
        }
        return returnTypeString + " " + this.enrichWithDeclarator(signature, (EObject)jvmOperation);
    }

    protected String _signature(JvmField jvmField, boolean typeAtEnd) {
        JvmTypeReference type = jvmField.getType();
        if (type != null) {
            String signature = jvmField.getSimpleName();
            if (typeAtEnd) {
                return signature + " : " + type.getSimpleName();
            }
            return type.getSimpleName() + " " + this.enrichWithDeclarator(signature, (EObject)jvmField);
        }
        return "";
    }

    protected String enrichWithDeclarator(String signature, EObject o) {
        if (o instanceof JvmMember && ((JvmMember)o).getDeclaringType() != null) {
            String parentsName = this.getDeclaratorName((JvmMember)o);
            return parentsName + "." + signature;
        }
        return signature;
    }

    protected String _signature(JvmConstructor constructor, boolean typeAtEnd) {
        return constructor.getSimpleName() + this.uiStrings.typeParameters((JvmIdentifiableElement)constructor.getDeclaringType()) + this.uiStrings.parameters((JvmIdentifiableElement)constructor) + this.getThrowsDeclaration((JvmExecutable)constructor);
    }

    protected String _signature(JvmFormalParameter parameter, boolean typeAtEnd) {
        EObject container = parameter.eContainer();
        LightweightTypeReference parameterType = this.typeResolver.resolveTypes((EObject)parameter).getActualType((JvmIdentifiableElement)parameter);
        if (parameterType != null) {
            Object signature = parameter.getName();
            String signatureOfFather = this.getSimpleSignature(container);
            if (signatureOfFather != null) {
                signature = (String)signature + " - " + signatureOfFather;
            }
            if (typeAtEnd) {
                return (String)signature + " : " + parameterType.getHumanReadableName();
            }
            return parameterType.getHumanReadableName() + " " + (String)signature;
        }
        return parameter.getName();
    }

    protected String _signature(JvmTypeParameter parameter, boolean typeAtEnd) {
        EObject container = parameter.eContainer();
        Object signature = parameter.getName();
        String signatureOfFather = this.getSimpleSignature(container);
        if (signatureOfFather != null) {
            signature = (String)signature + " - " + signatureOfFather;
        }
        return signature;
    }

    protected String _signature(JvmEnumerationType jvmEnumerationType, boolean typeAtEnd) {
        return jvmEnumerationType.getSimpleName();
    }

    protected String _signature(JvmAnnotationType jvmAnnotationType, boolean typeAtEnd) {
        return jvmAnnotationType.getSimpleName();
    }

    protected String getThrowsDeclaration(JvmExecutable executable) {
        Object result = "";
        EList exceptions = executable.getExceptions();
        if (exceptions.size() > 0) {
            result = (String)result + " throws ";
            Iterator iterator = exceptions.iterator();
            while (iterator.hasNext()) {
                JvmTypeReference next = (JvmTypeReference)iterator.next();
                result = (String)result + next.getSimpleName();
                if (!iterator.hasNext()) continue;
                result = (String)result + ", ";
            }
        }
        return result;
    }

    protected String getSimpleSignature(EObject container) {
        if (container instanceof JvmOperation) {
            return this.getSimpleSignature((JvmOperation)container);
        }
        if (container instanceof JvmConstructor) {
            return this.getSimpleSignature((JvmConstructor)container);
        }
        return this.getLabel(container);
    }

    protected String getSimpleSignature(JvmConstructor contructor) {
        return contructor.getSimpleName() + " " + this.uiStrings.parameters((JvmIdentifiableElement)contructor);
    }

    protected String getSimpleSignature(JvmOperation jvmOperation) {
        return jvmOperation.getSimpleName() + this.uiStrings.parameters((JvmIdentifiableElement)jvmOperation);
    }

    protected String getLabel(EObject object) {
        String label = this.nameLabelProvider.getNameLabel((Object)object);
        return object.eClass().getName() + (String)(label != null ? " **" + label + "**" : "");
    }
}

