/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.jvmmodel;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.linking.lazy.LazyURIEncoder;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XbasePackage;

public class AnonymousClassUtil {
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private LazyURIEncoder uriEncoder;
    @Inject
    private LinkingHelper linkingHelper;

    public JvmDeclaredType getSuperTypeNonResolving(AnonymousClass anonymousClass, IScope typeScope) {
        XConstructorCall constructorCall = anonymousClass.getConstructorCall();
        EObject constructorProxy = (EObject)constructorCall.eGet((EStructuralFeature)XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, false);
        IEObjectDescription description = null;
        if (constructorProxy != null) {
            if (!constructorProxy.eIsProxy()) {
                return this.getSuperType(anonymousClass);
            }
            String fragment = EcoreUtil.getURI((EObject)constructorProxy).fragment();
            INode node = this.uriEncoder.getNode((EObject)constructorCall, fragment);
            String name = this.linkingHelper.getCrossRefNodeAsString(node, true);
            QualifiedName superTypeName = this.qualifiedNameConverter.toQualifiedName(name);
            description = typeScope.getSingleElement(superTypeName);
        }
        if (description == null || !EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_DECLARED_TYPE, (EClass)description.getEClass())) {
            description = typeScope.getSingleElement(QualifiedName.create((String[])new String[]{"java", "lang", "Object"}));
        }
        if (description != null && EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_DECLARED_TYPE, (EClass)description.getEClass())) {
            JvmDeclaredType type = (JvmDeclaredType)description.getEObjectOrProxy();
            if (!type.eIsProxy()) {
                return type;
            }
            return (JvmDeclaredType)EcoreUtil.resolve((EObject)type, (EObject)anonymousClass);
        }
        return null;
    }

    public JvmGenericType getSuperType(AnonymousClass anonymousClass) {
        JvmDeclaredType declaringType;
        JvmType superType;
        JvmConstructor constructor = anonymousClass.getConstructorCall().getConstructor();
        if (constructor != null && !constructor.eIsProxy() && (superType = ((JvmTypeReference)Iterables.getLast((Iterable)(declaringType = constructor.getDeclaringType()).getSuperTypes())).getType()) instanceof JvmGenericType) {
            return (JvmGenericType)superType;
        }
        return null;
    }

    public JvmConstructor getSuperTypeConstructor(AnonymousClass anonymousClass) {
        JvmGenericType superType = this.getSuperType(anonymousClass);
        if (superType != null) {
            JvmConstructor constructor = anonymousClass.getConstructorCall().getConstructor();
            for (JvmMember superMember : superType.getMembers()) {
                if (!(superMember instanceof JvmConstructor) || !this.isSameSignature(constructor, (JvmConstructor)superMember)) continue;
                return (JvmConstructor)superMember;
            }
        }
        return null;
    }

    protected boolean isSameSignature(JvmConstructor constructor, JvmConstructor superConstructor) {
        if (constructor.getParameters().size() != superConstructor.getParameters().size()) {
            return false;
        }
        int i = 0;
        while (i < constructor.getParameters().size()) {
            JvmTypeReference paramType = ((JvmFormalParameter)constructor.getParameters().get(i)).getParameterType();
            JvmTypeReference superParamType = ((JvmFormalParameter)superConstructor.getParameters().get(i)).getParameterType();
            if (!paramType.getIdentifier().equals(superParamType.getIdentifier())) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

