/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.testing;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.xtext.generator.InMemoryFileSystemAccess;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class RegisteringFileSystemAccess
extends InMemoryFileSystemAccess {
    private Set<GeneratedFile> generatedFiles = new HashSet<GeneratedFile>();
    private String projectName;

    public void generateFile(String fileName, String outputConfigurationName, CharSequence contents) {
        super.generateFile(fileName, outputConfigurationName, contents);
        String path = this.getPath(fileName, outputConfigurationName);
        String javaName = null;
        if (fileName.endsWith(".java")) {
            javaName = fileName.substring(0, fileName.length() - ".java".length()).replace('/', '.');
        }
        this.generatedFiles.add(new GeneratedFile(path, javaName, contents));
    }

    protected String getPath(String fileName, String outputConfigurationName) {
        String path = (String)this.getPathes().get(outputConfigurationName);
        return "/" + this.projectName + "/" + path + "/" + fileName;
    }

    public Set<GeneratedFile> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public static class GeneratedFile {
        private String path;
        private String javaClassName;
        private CharSequence contents;

        public GeneratedFile(String path, String javaClassName, CharSequence contents) {
            this.path = path;
            this.javaClassName = javaClassName;
            this.contents = contents;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.contents == null ? 0 : this.contents.hashCode());
            result = 31 * result + (this.javaClassName == null ? 0 : this.javaClassName.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GeneratedFile other = (GeneratedFile)obj;
            if (this.contents == null ? other.contents != null : !this.contents.equals(other.contents)) {
                return false;
            }
            if (this.javaClassName == null ? other.javaClassName != null : !this.javaClassName.equals(other.javaClassName)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("path", (Object)this.path);
            b.add("javaClassName", (Object)this.javaClassName);
            b.add("contents", (Object)this.contents);
            return b.toString();
        }

        public String getPath() {
            return this.path;
        }

        public String getJavaClassName() {
            return this.javaClassName;
        }

        public CharSequence getContents() {
            return this.contents;
        }
    }
}

