/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.java.resource;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xbase.lib.Pure;

public class JavaConfig {
    private JavaVersion javaSourceLevel;
    private JavaVersion javaTargetLevel;

    public static JavaConfig findInEmfObject(Notifier emfObject) {
        JavaConfigAdapter adapter = (JavaConfigAdapter)EcoreUtil.getExistingAdapter((Notifier)emfObject, JavaConfig.class);
        if (adapter != null) {
            return adapter.get();
        }
        return null;
    }

    public static JavaConfig removeFromEmfObject(Notifier emfObject) {
        EList adapters = emfObject.eAdapters();
        int i = 0;
        int max = adapters.size();
        while (i < max) {
            Adapter adapter = (Adapter)adapters.get(i);
            if (adapter instanceof JavaConfigAdapter) {
                emfObject.eAdapters().remove(i);
                return ((JavaConfigAdapter)adapter).get();
            }
            ++i;
        }
        return null;
    }

    public void attachToEmfObject(Notifier emfObject) {
        JavaConfig result = JavaConfig.findInEmfObject(emfObject);
        if (result != null) {
            throw new IllegalStateException("The given EMF object already contains an adapter for JavaConfig");
        }
        JavaConfigAdapter adapter = new JavaConfigAdapter(this);
        emfObject.eAdapters().add((Object)adapter);
    }

    @Pure
    public JavaVersion getJavaSourceLevel() {
        return this.javaSourceLevel;
    }

    public void setJavaSourceLevel(JavaVersion javaSourceLevel) {
        this.javaSourceLevel = javaSourceLevel;
    }

    @Pure
    public JavaVersion getJavaTargetLevel() {
        return this.javaTargetLevel;
    }

    public void setJavaTargetLevel(JavaVersion javaTargetLevel) {
        this.javaTargetLevel = javaTargetLevel;
    }

    public static class JavaConfigAdapter
    extends AdapterImpl {
        private JavaConfig element;

        public JavaConfigAdapter(JavaConfig element) {
            this.element = element;
        }

        public JavaConfig get() {
            return this.element;
        }

        public boolean isAdapterForType(Object object) {
            return object == JavaConfig.class;
        }
    }
}

