/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.findrefs;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.xtext.xbase.ui.jvmmodel.findrefs.CompositeSearchQuery;

public class JdtReferenceFinder {
    @Inject(optional=true)
    private IWorkbench workbench;

    public void run(String label, Iterable<? extends IJavaElement> elements) {
        for (IJavaElement iJavaElement : elements) {
            if (ActionUtil.isProcessable((Shell)this.getShell(), (IJavaElement)iJavaElement)) continue;
            return;
        }
        try {
            this.performNewSearch(label, elements);
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)javaModelException, (Shell)this.getShell(), (String)SearchMessages.Search_Error_search_notsuccessful_title, (String)SearchMessages.Search_Error_search_notsuccessful_message);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Shell getShell() {
        return this.workbench.getActiveWorkbenchWindow().getShell();
    }

    protected QuerySpecification createQuery(IJavaElement element) throws JavaModelException, InterruptedException {
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        boolean isInsideJRE = factory.isInsideJRE(element);
        IJavaSearchScope scope = factory.createWorkspaceScope(isInsideJRE);
        String description = factory.getWorkspaceScopeDescription(isInsideJRE);
        return new ElementQuerySpecification(element, 2, scope, description);
    }

    protected void performNewSearch(String label, Iterable<? extends IJavaElement> elements) throws JavaModelException, InterruptedException {
        CompositeSearchQuery compositeSearchQuery = this.createCompositeQuery(label, elements);
        if (compositeSearchQuery.canRunInBackground()) {
            SearchUtil.runQueryInBackground((Object)((Object)compositeSearchQuery));
        } else {
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            IStatus status = SearchUtil.runQueryInForeground((IRunnableContext)progressService, (Object)((Object)compositeSearchQuery));
            if (status.matches(7)) {
                ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.Search_Error_search_title, (String)SearchMessages.Search_Error_search_message, (IStatus)status);
            }
        }
    }

    public CompositeSearchQuery createCompositeQuery(String label, Iterable<? extends IJavaElement> elements) throws JavaModelException, InterruptedException {
        CompositeSearchQuery compositeSearchQuery = new CompositeSearchQuery(this.createQuery((IJavaElement)Iterables.getFirst(elements, null)));
        compositeSearchQuery.setLabel(label);
        for (IJavaElement iJavaElement : elements) {
            JavaSearchQuery query = new JavaSearchQuery(this.createQuery(iJavaElement));
            compositeSearchQuery.addChild((ISearchQuery)query);
        }
        return compositeSearchQuery;
    }
}

