/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.common.types.ui.trace.ITraceForTypeRootProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.xbase.ui.editor.DocumentProviderStub;
import org.eclipse.xtext.xbase.ui.editor.FoldingPreferences;
import org.eclipse.xtext.xbase.ui.editor.StacktraceBasedEditorDecider;
import org.eclipse.xtext.xbase.ui.editor.XbaseEditorInputRedirector;
import org.eclipse.xtext.xbase.ui.editor.XbaseEditorMessages;
import org.eclipse.xtext.xbase.ui.editor.actions.IClipboardActionFactory;

public class XbaseEditor
extends XtextEditor {
    private static final Logger log = Logger.getLogger(XbaseEditor.class);
    protected static final String HANDLER_IDENTIFIER = "HANDLER_IDENTIFIER";
    @Inject
    private ITraceForTypeRootProvider traceInformation;
    @Inject
    private StacktraceBasedEditorDecider calleeAnalyzer;
    @Inject
    private EclipseOutputConfigurationProvider outputConfigurationProvider;
    @Inject
    private XbaseEditorInputRedirector editorInputRedirector;
    @Inject(optional=true)
    private IClipboardActionFactory clipboardActionFactory;
    private ITypeRoot typeRoot = null;
    private int expectJavaSelection = 0;
    private boolean expectLineSelection = false;
    private boolean isIgnoreCall = false;
    @Inject
    private FoldingPreferences foldingPreferences;
    private Exception lastCall = null;
    int reentrantCallFromSelf = 0;

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.typeRoot != null) {
            memento.putString(HANDLER_IDENTIFIER, this.typeRoot.getHandleIdentifier());
        }
    }

    protected void doRestoreState(IMemento memento) {
        IJavaElement handle;
        super.doRestoreState(memento);
        String handleIdentifier = memento.getString(HANDLER_IDENTIFIER);
        if (handleIdentifier != null && (handle = JavaCore.create((String)handleIdentifier)) instanceof ITypeRoot && handle.exists()) {
            this.typeRoot = (ITypeRoot)handle;
        }
    }

    protected boolean containsSavedState(IMemento memento) {
        boolean result = super.containsSavedState(memento);
        if (!result) {
            return memento.getString(HANDLER_IDENTIFIER) != null;
        }
        return result;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        try {
            IEditorInput inputToUse = this.editorInputRedirector.findOriginalSource(input);
            super.doSetInput(inputToUse);
            ITypeRoot typeRoot = this.editorInputRedirector.getTypeRoot(input);
            if (typeRoot != null) {
                this.markNextSelectionAsJavaOffset(typeRoot);
            }
            return;
        }
        catch (CoreException coreException) {
            super.doSetInput(input);
            return;
        }
    }

    public void markNextSelectionAsJavaOffset(ITypeRoot typeRoot) {
        if (this.expectJavaSelection > 0) {
            if (!this.isIgnoreCall) {
                if (this.lastCall != null) {
                    log.warn((Object)"The editor is already awaiting a select and reveal call from : ", (Throwable)this.lastCall);
                    log.warn((Object)"Now called from : ", (Throwable)new Exception());
                }
                this.expectJavaSelection = 0;
            } else {
                this.expectJavaSelection = 0;
            }
        }
        this.lastCall = new Exception();
        ++this.expectJavaSelection;
        this.isIgnoreCall = this.calleeAnalyzer.isEditorUtilityIsOpenInEditor() || this.calleeAnalyzer.isOpenEditorAction();
        if (this.calleeAnalyzer.isCalledFromFindReferences()) {
            ++this.expectJavaSelection;
        }
        this.typeRoot = typeRoot;
    }

    protected void safelySanityCheckState(IEditorInput input) {
        try {
            ++this.reentrantCallFromSelf;
            super.safelySanityCheckState(input);
        }
        finally {
            --this.reentrantCallFromSelf;
        }
    }

    public boolean isDirty() {
        try {
            ++this.reentrantCallFromSelf;
            boolean bl = super.isDirty();
            return bl;
        }
        finally {
            --this.reentrantCallFromSelf;
        }
    }

    public IDocumentProvider getDocumentProvider() {
        if (this.expectJavaSelection > 0 && this.reentrantCallFromSelf == 0 && this.calleeAnalyzer.isLineBasedOpenEditorAction()) {
            this.expectLineSelection = true;
            if (this.isCompiledWithJSR45()) {
                return new DocumentProviderStub(){

                    @Override
                    public IDocument getDocument(Object element) {
                        if (XbaseEditor.this.typeRoot == null) {
                            return XbaseEditor.super.getDocumentProvider().getDocument(element);
                        }
                        IResource javaResource = XbaseEditor.this.typeRoot.getResource();
                        if (!(javaResource instanceof IStorage)) {
                            return XbaseEditor.super.getDocumentProvider().getDocument(element);
                        }
                        try {
                            Throwable throwable = null;
                            Object var4_6 = null;
                            try (InputStream contents = ((IStorage)javaResource).getContents();){
                                String string = Files.readStreamIntoString((InputStream)contents);
                                return new Document(string);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException | CoreException e) {
                            return XbaseEditor.super.getDocumentProvider().getDocument(element);
                        }
                    }

                    @Override
                    public void connect(Object element) throws CoreException {
                    }

                    @Override
                    public void disconnect(Object element) {
                    }
                };
            }
        }
        return super.getDocumentProvider();
    }

    /*
     * Exception decompiling
     */
    protected void selectAndReveal(int selectionStart, int selectionLength, int revealStart, int revealLength) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ITrace getTraceStorage() {
        if (this.typeRoot == null) {
            return null;
        }
        return this.traceInformation.getTraceToSource(this.typeRoot);
    }

    protected ILocationInResource getLocationInResource(ITrace traceToSource) {
        if (traceToSource == null) {
            return null;
        }
        Iterator iterator = traceToSource.getAllAssociatedLocations().iterator();
        if (iterator.hasNext()) {
            ILocationInResource locationInResource = (ILocationInResource)iterator.next();
            return locationInResource;
        }
        return null;
    }

    protected boolean isCompiledWithJSR45() {
        if (this.getResource() == null) {
            return true;
        }
        Set configurations = this.outputConfigurationProvider.getOutputConfigurations(this.getResource().getProject());
        for (OutputConfiguration config : configurations) {
            if (!config.isInstallDslAsPrimarySource()) continue;
            return false;
        }
        return true;
    }

    protected int getLineInJavaDocument(Document document, int selectionStart, int selectionLength) throws BadLocationException {
        int line = document.getLineOfOffset(selectionStart);
        int length = document.getLineLength(line);
        int lineOffset = document.getLineOffset(line);
        if (lineOffset == selectionStart && length == selectionLength) {
            return line;
        }
        IRegion region = document.getLineInformation(line);
        if (region.getOffset() == selectionStart || region.getLength() == selectionLength) {
            return line;
        }
        return -1;
    }

    protected int getStartOffsetOfContentsInJava(Document document, int line) throws BadLocationException {
        IRegion lineInformation = document.getLineInformation(line);
        String lineText = document.get(lineInformation.getOffset(), lineInformation.getLength());
        String contents = lineText.trim();
        if (contents.length() == 0) {
            log.warn((Object)"selection points to an empty line!", (Throwable)new IllegalStateException());
            return -1;
        }
        int contentsStarts = lineText.indexOf(contents);
        return lineInformation.getOffset() + contentsStarts;
    }

    public void reveal(int offset, int length) {
        super.reveal(offset, length);
    }

    protected void createActions() {
        super.createActions();
        this.createClipboardActions();
    }

    protected void createClipboardActions() {
        IClipboardActionFactory actionsFactory = this.getClipboardActionFactory();
        if (actionsFactory != null) {
            ResourceBundle bundle = XbaseEditorMessages.getBundleForConstructedKeys();
            TextEditorAction action = actionsFactory.create(bundle, "Editor.Cut.", (ITextEditor)this, 3);
            this.setAction(ITextEditorActionConstants.CUT, (IAction)action);
            action = actionsFactory.create(bundle, "Editor.Copy.", (ITextEditor)this, 4);
            this.setAction(ITextEditorActionConstants.COPY, (IAction)action);
            action = actionsFactory.create(bundle, "Editor.Paste.", (ITextEditor)this, 5);
            this.setAction(ITextEditorActionConstants.PASTE, (IAction)action);
        }
    }

    protected IClipboardActionFactory getClipboardActionFactory() {
        return this.clipboardActionFactory;
    }

    protected void installFoldingSupport(ProjectionViewer projectionViewer) {
        if (this.foldingPreferences.isEnabled()) {
            super.installFoldingSupport(projectionViewer);
        }
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        String property = event.getProperty();
        if (property.equals("editor_folding_enabled")) {
            ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
            if (event.getNewValue() != null && Boolean.valueOf(event.getNewValue().toString()).booleanValue()) {
                if (!projectionViewer.isProjectionMode()) {
                    this.installFoldingSupport(projectionViewer);
                }
            } else if (projectionViewer.isProjectionMode()) {
                this.uninstallFoldingSupport();
                projectionViewer.disableProjection();
            }
        }
    }
}

