/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.concurrent;

import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.util.concurrent.WrappingCancelableUnitOfWork;

public interface IWriteAccess<State> {
    public <Result> Result modify(IUnitOfWork<Result, State> var1);

    default public <Result> Result tryModify(IUnitOfWork<Result, State> work, Supplier<? extends Result> defaultResult) {
        if (work instanceof CancelableUnitOfWork) {
            return this.modify(new WrappingCancelableUnitOfWork<Result, State>(defaultResult, work));
        }
        return (Result)this.modify(state -> {
            if (state == null) {
                return defaultResult.get();
            }
            return work.exec(state);
        });
    }

    default public <Result> Result tryModify(IUnitOfWork<Result, State> work) {
        return (Result)this.tryModify(work, () -> null);
    }

    default public <Result> Result tryModify(IUnitOfWork<Result, State> work, Supplier<? extends Result> defaultResult, Function<? super Exception, ? extends Result> exceptionHandler) {
        try {
            return this.tryModify(work, defaultResult);
        }
        catch (Exception e) {
            return exceptionHandler.apply(e);
        }
    }
}

