/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractTypeReferencePairWalker;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterAwareTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

public class TypeArgumentFromComputedTypeCollector
extends UnboundTypeParameterAwareTypeArgumentCollector {
    public static void resolveAgainstActualType(LightweightTypeReference declaredType, LightweightTypeReference actualType, Collection<JvmTypeParameter> typeParameters, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping, BoundTypeArgumentSource source, ITypeReferenceOwner owner) {
        if (declaredType.isRawType() || actualType.isRawType()) {
            return;
        }
        TypeArgumentFromComputedTypeCollector implementation = new TypeArgumentFromComputedTypeCollector(typeParameters, source, owner);
        implementation.populateTypeParameterMapping(declaredType, actualType);
        Map<JvmTypeParameter, List<LightweightBoundTypeArgument>> parameterMapping = implementation.rawGetTypeParameterMapping();
        for (Map.Entry<JvmTypeParameter, List<LightweightBoundTypeArgument>> entry : parameterMapping.entrySet()) {
            LightweightMergedBoundTypeArgument boundTypeArgument = typeParameterMapping.get(entry.getKey());
            if (boundTypeArgument == null) continue;
            List<LightweightBoundTypeArgument> computedBoundTypeArguments = entry.getValue();
            for (LightweightBoundTypeArgument computedBoundTypeArgument : computedBoundTypeArguments) {
                UnboundTypeReference typeReference;
                if (computedBoundTypeArgument.getSource() == BoundTypeArgumentSource.RESOLVED) {
                    VarianceInfo varianceInfo = computedBoundTypeArgument.getDeclaredVariance().mergeDeclaredWithActual(computedBoundTypeArgument.getActualVariance());
                    typeParameterMapping.put(entry.getKey(), new LightweightMergedBoundTypeArgument(computedBoundTypeArgument.getTypeReference(), varianceInfo));
                    continue;
                }
                if (!(boundTypeArgument.getTypeReference() instanceof UnboundTypeReference) || (typeReference = (UnboundTypeReference)boundTypeArgument.getTypeReference()).internalIsResolved() || computedBoundTypeArgument.getTypeReference() instanceof UnboundTypeReference && ((UnboundTypeReference)computedBoundTypeArgument.getTypeReference()).getHandle() == typeReference.getHandle()) continue;
                typeReference.acceptHint(computedBoundTypeArgument);
            }
        }
    }

    public TypeArgumentFromComputedTypeCollector(Collection<JvmTypeParameter> parametersToBeMapped, BoundTypeArgumentSource defaultSource, ITypeReferenceOwner owner) {
        super(parametersToBeMapped, defaultSource, owner);
    }

    @Override
    protected void acceptHint(UnboundTypeReference reference, LightweightTypeReference param) {
        if (!this.shouldProcess(reference.getTypeParameter())) {
            reference.tryResolve();
            if (reference.internalIsResolved()) {
                this.outerVisit(reference, param);
            } else {
                super.acceptHint(reference, param);
            }
        } else {
            reference.acceptHint(this.boundByInference(param));
        }
    }

    @Override
    protected AbstractTypeReferencePairWalker.ArrayTypeReferenceTraverser createArrayTypeReferenceTraverser() {
        return new AbstractTypeReferencePairWalker.ArrayTypeReferenceTraverser(this){

            @Override
            protected void doVisitParameterizedTypeReference(ParameterizedTypeReference reference, ArrayTypeReference declaration) {
                ArrayTypeReference array;
                JvmType type = reference.getType();
                if (type instanceof JvmTypeParameter) {
                    if (TypeArgumentFromComputedTypeCollector.this.shouldProcess((JvmTypeParameter)type)) {
                        JvmTypeParameter typeParameter = (JvmTypeParameter)type;
                        TypeArgumentFromComputedTypeCollector.this.processTypeParameter(typeParameter, declaration);
                    }
                } else if (reference.isSubtypeOf(Iterable.class) && (array = reference.tryConvertToArray()) != null) {
                    TypeArgumentFromComputedTypeCollector.this.outerVisit(declaration, array);
                }
            }

            @Override
            protected void doVisitWildcardTypeReference(WildcardTypeReference reference, ArrayTypeReference declaration) {
                LightweightTypeReference lowerBound = reference.getLowerBound();
                if (lowerBound != null) {
                    TypeArgumentFromComputedTypeCollector.this.outerVisit(declaration, lowerBound);
                } else {
                    for (LightweightTypeReference upperBound : reference.getUpperBounds()) {
                        TypeArgumentFromComputedTypeCollector.this.outerVisit(declaration, upperBound);
                    }
                }
            }
        };
    }

    @Override
    protected AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser createParameterizedTypeReferenceTraverser() {
        return new UnboundTypeParameterAwareTypeArgumentCollector.UnboundTypeParameterAwareParameterizedTypeReferenceTraverser(this){

            @Override
            protected void doVisitArrayTypeReference(ArrayTypeReference reference, ParameterizedTypeReference declaration) {
                ArrayTypeReference array;
                JvmType type = declaration.getType();
                if (type instanceof JvmTypeParameter) {
                    if (TypeArgumentFromComputedTypeCollector.this.shouldProcess((JvmTypeParameter)type)) {
                        JvmTypeParameter typeParameter = (JvmTypeParameter)type;
                        TypeArgumentFromComputedTypeCollector.this.processTypeParameter(typeParameter, reference);
                    }
                } else if (declaration.isSubtypeOf(Iterable.class) && (array = declaration.tryConvertToArray()) != null) {
                    TypeArgumentFromComputedTypeCollector.this.outerVisit(array, reference);
                }
            }

            @Override
            protected void doVisitMatchingTypeParameters(ParameterizedTypeReference actual, ParameterizedTypeReference declaration) {
                FunctionTypeReference declarationFunctionType;
                FunctionTypeReference actualFunctionType;
                if (actual.isFunctionType() ^ declaration.isFunctionType() && (actualFunctionType = actual.tryConvertToFunctionTypeReference(false)) != null && (declarationFunctionType = declaration.tryConvertToFunctionTypeReference(false)) != null) {
                    List<LightweightTypeReference> actualParameterTypes = actualFunctionType.getParameterTypes();
                    List<LightweightTypeReference> declarationParameterTypes = declarationFunctionType.getParameterTypes();
                    int max = Math.min(actualParameterTypes.size(), declarationParameterTypes.size());
                    int i = 0;
                    while (i < max) {
                        LightweightTypeReference actualParameterType = actualParameterTypes.get(i);
                        LightweightTypeReference declarationParameterType = declarationParameterTypes.get(i);
                        TypeArgumentFromComputedTypeCollector.this.outerVisit(declarationParameterType, actualParameterType, declaration, VarianceInfo.IN, VarianceInfo.IN);
                        ++i;
                    }
                    LightweightTypeReference actualReturnType = actualFunctionType.getReturnType();
                    LightweightTypeReference declarationReturnType = declarationFunctionType.getReturnType();
                    if (actualReturnType != null && declarationReturnType != null) {
                        TypeArgumentFromComputedTypeCollector.this.outerVisit(declarationReturnType, actualReturnType, declaration, VarianceInfo.OUT, VarianceInfo.OUT);
                    }
                    return;
                }
                super.doVisitMatchingTypeParameters(actual, declaration);
            }
        };
    }

    @Override
    protected AbstractTypeReferencePairWalker.UnboundTypeReferenceTraverser createUnboundTypeReferenceTraverser() {
        return new UnboundTypeParameterAwareTypeArgumentCollector.UnboundTypeParameterAwareUnboundTypeReferenceTraverser(this){

            @Override
            protected void doVisitWildcardTypeReference(WildcardTypeReference reference, UnboundTypeReference declaration) {
                if (TypeArgumentFromComputedTypeCollector.this.shouldProcess(declaration.getTypeParameter())) {
                    declaration.acceptHint(TypeArgumentFromComputedTypeCollector.this.boundByInference(reference));
                } else {
                    super.doVisitWildcardTypeReference(reference, declaration);
                }
            }
        };
    }

    private LightweightBoundTypeArgument boundByInference(LightweightTypeReference reference) {
        return new LightweightBoundTypeArgument(reference.getWrapperTypeIfPrimitive(), BoundTypeArgumentSource.INFERRED, this.getOrigin(), this.getExpectedVariance(), this.getActualVariance());
    }
}

