/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.naming;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnumLiteral;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.scoping.XbaseQualifiedNameProvider;

public class XtendQualifiedNameProvider
extends XbaseQualifiedNameProvider {
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public QualifiedName getFullyQualifiedName(EObject obj) {
        if (obj instanceof XtendTypeDeclaration) {
            XtendTypeDeclaration typeDecl = (XtendTypeDeclaration)obj;
            String typeName = typeDecl.getName();
            if (typeName == null) {
                return null;
            }
            XtendFile file = (XtendFile)typeDecl.eContainer();
            String packageName = file.getPackage();
            if (packageName != null) {
                return this.qualifiedNameConverter.toQualifiedName(packageName).append(typeName);
            }
            return QualifiedName.create((String)typeName);
        }
        if (obj instanceof XtendConstructor) {
            return this.getFullyQualifiedName(obj.eContainer());
        }
        if (obj instanceof JvmIdentifiableElement && !(obj instanceof JvmTypeParameter)) {
            return this.getFullyQualifiedName((JvmIdentifiableElement)obj);
        }
        if (obj instanceof XtendField) {
            return this.concatNames(obj, ((XtendField)obj).getName());
        }
        if (obj instanceof XtendFunction) {
            return this.concatNames(obj, ((XtendFunction)obj).getName());
        }
        if (obj instanceof XtendEnumLiteral) {
            return this.concatNames(obj, ((XtendEnumLiteral)obj).getName());
        }
        return null;
    }

    protected QualifiedName concatNames(EObject obj, String name) {
        if (name == null) {
            return null;
        }
        QualifiedName parentName = this.getFullyQualifiedName(obj.eContainer());
        if (parentName == null) {
            return null;
        }
        return parentName.append(name);
    }
}

