/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.notification;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.common.types.ui.notification.LayeredTypeResourceDescription;
import org.eclipse.xtext.common.types.ui.notification.NameBasedEObjectDescription;
import org.eclipse.xtext.common.types.ui.notification.NameBasedEObjectDescriptionBuilder;
import org.eclipse.xtext.common.types.ui.notification.TypeResourceDescription;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ChangedResourceDescriptionDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaConverter {
    private static final Logger logger = Logger.getLogger(DeltaConverter.class);
    private final TypeURIHelper uriHelper;
    private final IQualifiedNameConverter nameConverter;
    @Inject
    private IResourceDescriptions resourceDescriptions;

    @Inject
    public DeltaConverter(IQualifiedNameConverter nameConverter, TypeURIHelper uriHelper) {
        this.nameConverter = nameConverter;
        this.uriHelper = uriHelper;
    }

    public List<IResourceDescription.Delta> convert(IJavaElementDelta delta) {
        if (delta.getFlags() == 524288 || delta.getFlags() == 540673) {
            return Collections.emptyList();
        }
        try {
            ArrayList result = Lists.newArrayListWithExpectedSize((int)2);
            this.convertCompilationUnits(delta, result);
            return result;
        }
        catch (Throwable throwable) {
            return Collections.singletonList(new ThrowableWrapper(delta.getElement().getPath().toString(), delta.toString(), throwable));
        }
    }

    protected void convertCompilationUnit(IJavaElementDelta delta, List<IResourceDescription.Delta> result) {
        if ((delta.getFlags() & 8) != 0) {
            IJavaElementDelta[] children;
            IJavaElementDelta[] iJavaElementDeltaArray = children = delta.getAffectedChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IType type;
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                IJavaElement childElement = child.getElement();
                if (childElement instanceof IType && !this.isDerived(type = (IType)childElement)) {
                    URI uri = this.getURIFor(type);
                    List<IEObjectDescription> exported = this.getExportedEObjects(type);
                    Object oldDescription = null;
                    TypeResourceDescription newDescription = null;
                    if (child.getKind() == 2) {
                        oldDescription = new TypeResourceDescription(uri, exported);
                    } else if (child.getKind() == 1) {
                        newDescription = new TypeResourceDescription(uri, exported);
                    } else {
                        newDescription = new TypeResourceDescription(uri, exported);
                        List<IEObjectDescription> additionallyExportedEObjects = this.getAdditionallyExportedEObjects(type, child);
                        oldDescription = new LayeredTypeResourceDescription(newDescription, additionallyExportedEObjects);
                    }
                    ChangedResourceDescriptionDelta resourceDelta = new ChangedResourceDescriptionDelta((IResourceDescription)oldDescription, (IResourceDescription)newDescription);
                    result.add((IResourceDescription.Delta)resourceDelta);
                }
                ++n2;
            }
        } else if ((delta.getFlags() & 0x14000) == 0) {
            URI uri;
            ICompilationUnit cu = (ICompilationUnit)delta.getElement();
            String expectedPrimaryTypeName = this.getExpectedPrimaryTypeNameFor(cu);
            IType primaryType = this.getPrimaryTypeFrom(cu);
            if (primaryType != null && !this.isDerived(primaryType)) {
                uri = this.getURIFor(primaryType);
                List<IEObjectDescription> exported = this.getExportedEObjects(primaryType);
                TypeResourceDescription newDescription = new TypeResourceDescription(uri, exported);
                TypeResourceDescription oldDescription = null;
                if (primaryType.getFullyQualifiedName().equals(expectedPrimaryTypeName)) {
                    oldDescription = new TypeResourceDescription(uri, Collections.singletonList(new NameBasedEObjectDescription(this.nameConverter.toQualifiedName(expectedPrimaryTypeName))));
                }
                ChangedResourceDescriptionDelta resourceDelta = new ChangedResourceDescriptionDelta(oldDescription, (IResourceDescription)newDescription);
                result.add((IResourceDescription.Delta)resourceDelta);
            }
            if (primaryType == null || !primaryType.getFullyQualifiedName().equals(expectedPrimaryTypeName)) {
                uri = this.uriHelper.createResourceURIForFQN(expectedPrimaryTypeName);
                TypeResourceDescription oldDescription = new TypeResourceDescription(uri, Collections.singletonList(new NameBasedEObjectDescription(this.nameConverter.toQualifiedName(expectedPrimaryTypeName))));
                ChangedResourceDescriptionDelta resourceDelta = new ChangedResourceDescriptionDelta((IResourceDescription)oldDescription, null);
                result.add((IResourceDescription.Delta)resourceDelta);
            }
        }
    }

    protected boolean isDerived(IType type) {
        QualifiedName qualifiedName = this.nameConverter.toQualifiedName(type.getFullyQualifiedName());
        Iterable iterable = this.resourceDescriptions.getExportedObjects(TypesPackage.Literals.JVM_TYPE, qualifiedName, false);
        return iterable.iterator().hasNext();
    }

    protected List<IEObjectDescription> getAdditionallyExportedEObjects(IType type, IJavaElementDelta delta) {
        QualifiedName typeName = this.nameConverter.toQualifiedName(type.getFullyQualifiedName());
        NameBasedEObjectDescriptionBuilder descriptionBuilder = new NameBasedEObjectDescriptionBuilder(typeName);
        this.traverseDelta(delta, descriptionBuilder);
        return descriptionBuilder.getExported();
    }

    protected void traverseDelta(IJavaElementDelta delta, NameBasedEObjectDescriptionBuilder acceptor) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
            if (childDelta.getKind() == 2) {
                String childName = childDelta.getElement().getElementName();
                acceptor.accept(childName);
            } else {
                IJavaElement childElement = childDelta.getElement();
                if (childElement.getElementType() == 7) {
                    NameBasedEObjectDescriptionBuilder childAcceptor = acceptor.nestType(childElement.getElementName());
                    this.traverseDelta(childDelta, childAcceptor);
                }
            }
            ++n2;
        }
    }

    protected List<IEObjectDescription> getExportedEObjects(IType type) {
        QualifiedName typeName = this.nameConverter.toQualifiedName(type.getFullyQualifiedName());
        NameBasedEObjectDescriptionBuilder descriptionBuilder = new NameBasedEObjectDescriptionBuilder(typeName);
        this.traverseType(type, descriptionBuilder);
        List<IEObjectDescription> exported = descriptionBuilder.getExported();
        return exported;
    }

    protected void traverseType(IType type, NameBasedEObjectDescriptionBuilder acceptor) {
        block8: {
            try {
                if (type.exists()) {
                    IField[] iFieldArray = type.getFields();
                    int n = iFieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IField field = iFieldArray[n2];
                        if (!Flags.isSynthetic((int)field.getFlags())) {
                            String fieldName = field.getElementName();
                            acceptor.accept(fieldName);
                        }
                        ++n2;
                    }
                    iFieldArray = type.getMethods();
                    n = iFieldArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        IField method = iFieldArray[n2];
                        if (!Flags.isSynthetic((int)method.getFlags())) {
                            String methodName = method.getElementName();
                            acceptor.accept(methodName);
                        }
                        ++n2;
                    }
                    iFieldArray = type.getTypes();
                    n = iFieldArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        IField nestedType = iFieldArray[n2];
                        this.traverseType((IType)nestedType, acceptor.nestType(nestedType.getElementName()));
                        ++n2;
                    }
                }
            }
            catch (JavaModelException e) {
                if (!logger.isDebugEnabled()) break block8;
                logger.debug((Object)e, (Throwable)e);
            }
        }
    }

    protected void convertCompilationUnits(IJavaElementDelta delta, List<IResourceDescription.Delta> result) {
        block9: {
            IJavaElement element = delta.getElement();
            if (element.getElementType() == 5) {
                this.convertCompilationUnit(delta, result);
            }
            if (element.getElementType() < 5) {
                IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
                int n = iJavaElementDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta child = iJavaElementDeltaArray[n2];
                    this.convertCompilationUnits(child, result);
                    ++n2;
                }
                if (delta.getKind() == 1 && delta.getAffectedChildren().length == 0 && element.getElementType() == 4) {
                    IPackageFragment fragment = (IPackageFragment)element;
                    try {
                        ICompilationUnit[] iCompilationUnitArray = fragment.getCompilationUnits();
                        int n3 = iCompilationUnitArray.length;
                        n = 0;
                        while (n < n3) {
                            ICompilationUnit cu = iCompilationUnitArray[n];
                            IType[] iTypeArray = cu.getTypes();
                            int n4 = iTypeArray.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                IType type = iTypeArray[n5];
                                if (!this.isDerived(type)) {
                                    URI uri = this.getURIFor(type);
                                    List<IEObjectDescription> exported = this.getExportedEObjects(type);
                                    TypeResourceDescription newDescription = new TypeResourceDescription(uri, exported);
                                    ChangedResourceDescriptionDelta resourceDelta = new ChangedResourceDescriptionDelta(null, (IResourceDescription)newDescription);
                                    result.add((IResourceDescription.Delta)resourceDelta);
                                }
                                ++n5;
                            }
                            ++n;
                        }
                    }
                    catch (JavaModelException e) {
                        if (!logger.isDebugEnabled()) break block9;
                        logger.debug((Object)e, (Throwable)e);
                    }
                }
            }
        }
    }

    protected URI getURIFor(IType type) {
        URI result = this.uriHelper.createResourceURIForFQN(type.getFullyQualifiedName());
        return result;
    }

    protected IType getPrimaryTypeFrom(ICompilationUnit cu) {
        block6: {
            try {
                if (cu.exists()) {
                    IType primaryType = cu.findPrimaryType();
                    if (primaryType != null) {
                        return primaryType;
                    }
                    IType[] iTypeArray = cu.getTypes();
                    int n = iTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType type = iTypeArray[n2];
                        if (Flags.isPublic((int)type.getFlags())) {
                            return type;
                        }
                        ++n2;
                    }
                }
            }
            catch (JavaModelException e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    protected String getExpectedPrimaryTypeNameFor(ICompilationUnit cu) {
        String fileName = cu.getElementName();
        String typeName = fileName.substring(0, fileName.lastIndexOf(46));
        IPackageFragment pkg = (IPackageFragment)cu.getParent();
        if (!pkg.isDefaultPackage()) {
            typeName = String.valueOf(pkg.getElementName()) + '.' + typeName;
        }
        return typeName;
    }

    public static class ThrowableWrapper
    implements IResourceDescription.Delta {
        private String location;
        private String eventAsString;
        private Throwable cause;

        public ThrowableWrapper(String location, String eventAsString, Throwable cause) {
            this.location = location;
            this.eventAsString = eventAsString;
            this.cause = cause;
        }

        public URI getUri() {
            return URI.createURI((String)this.location);
        }

        public IResourceDescription getOld() {
            return null;
        }

        public IResourceDescription getNew() {
            return null;
        }

        public boolean haveEObjectDescriptionsChanged() {
            return true;
        }

        public String getLocation() {
            return this.location;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            return "Exception while processing " + this.eventAsString + ": " + this.cause.getMessage();
        }
    }
}

