/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IPrefixMatcher;
import org.eclipse.xtext.ide.editor.contentassist.IProposalConflictHelper;
import org.eclipse.xtext.xbase.lib.Procedures;

public class IdeContentProposalCreator {
    @Inject
    private IPrefixMatcher prefixMatcher;
    @Inject
    private IProposalConflictHelper conflictHelper;

    public ContentAssistEntry createProposal(String proposal, ContentAssistContext context) {
        return this.createProposal(proposal, context.getPrefix(), context, "UNKNOWN", null);
    }

    public ContentAssistEntry createSnippet(String proposal, String label, ContentAssistContext context) {
        return this.createProposal(proposal, context.getPrefix(), context, "SNIPPET", (Procedures.Procedure1<? super ContentAssistEntry>)((Procedures.Procedure1)it -> it.setLabel(label)));
    }

    public ContentAssistEntry createProposal(String proposal, ContentAssistContext context, Procedures.Procedure1<? super ContentAssistEntry> init) {
        return this.createProposal(proposal, context.getPrefix(), context, "UNKNOWN", init);
    }

    public ContentAssistEntry createProposal(String proposal, ContentAssistContext context, String kind, Procedures.Procedure1<? super ContentAssistEntry> init) {
        return this.createProposal(proposal, context.getPrefix(), context, kind, init);
    }

    public ContentAssistEntry createProposal(String proposal, String prefix, ContentAssistContext context, String kind, Procedures.Procedure1<? super ContentAssistEntry> init) {
        if (this.isValidProposal(proposal, prefix, context)) {
            ContentAssistEntry result = new ContentAssistEntry();
            result.setProposal(proposal);
            result.setPrefix(prefix);
            if (kind != null) {
                result.setKind(kind);
            }
            if (init != null) {
                init.apply((Object)result);
            }
            return result;
        }
        return null;
    }

    public boolean isValidProposal(String proposal, String prefix, ContentAssistContext context) {
        return !Strings.isNullOrEmpty((String)proposal) && this.prefixMatcher.isCandidateMatchingPrefix(proposal, prefix) && !this.conflictHelper.existsConflict(proposal, context);
    }
}

