/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.trace;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.xtext.common.types.ui.trace.AbstractTraceWithoutStorage;
import org.eclipse.xtext.generator.trace.AbsoluteURI;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;

public class ZipFileAwareTrace
extends AbstractTraceWithoutStorage {
    private static final Logger log = Logger.getLogger(ZipFileAwareTrace.class);
    private IPath zipFilePath;

    protected void setZipFilePath(IPath zipFilePath) {
        this.zipFilePath = zipFilePath;
    }

    protected AbsoluteURI resolvePath(SourceRelativeURI path) {
        IResource member = this.getWorkspace().getRoot().findMember(this.zipFilePath);
        if (member != null) {
            String uri = "archive:platform:/resource" + member.getFullPath().toString() + "!/" + String.valueOf(path);
            return new AbsoluteURI(URI.createURI((String)uri));
        }
        return new AbsoluteURI(URI.createURI((String)("archive:file:" + this.zipFilePath.toString() + "!/" + String.valueOf(path))));
    }

    @Override
    public InputStream getContents(SourceRelativeURI uri, IProject project) {
        JavaModelManager modelManager = JavaModelManager.getJavaModelManager();
        ZipFile zipFile = null;
        try {
            zipFile = modelManager.getZipFile(this.zipFilePath);
            ZipEntry zipEntry = zipFile.getEntry(uri.getURI().toString());
            if (zipEntry != null) {
                byte[] contents = Util.getZipEntryByteContent((ZipEntry)zipEntry, (ZipFile)zipFile);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(contents);
                return byteArrayInputStream;
            }
        }
        catch (IOException e) {
            log.debug((Object)("Could not read zip file " + String.valueOf(uri)), (Throwable)e);
        }
        catch (CoreException e) {
            log.debug((Object)("Could not read zip file " + String.valueOf(uri)), (Throwable)e);
        }
        finally {
            if (zipFile != null) {
                modelManager.closeZipFile(zipFile);
            }
        }
        return null;
    }

    protected Reader getContentsAsText(SourceRelativeURI uri, IProject project) {
        InputStream contents = this.getContents(uri, project);
        if (contents != null) {
            return new InputStreamReader(contents, this.getEncoding());
        }
        return null;
    }
}

