/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.trace;

import com.google.common.base.Charsets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.xtext.common.types.ui.trace.AbstractTraceWithoutStorage;
import org.eclipse.xtext.common.types.ui.trace.FolderAwareTrace;
import org.eclipse.xtext.common.types.ui.trace.ITraceForTypeRootProvider;
import org.eclipse.xtext.common.types.ui.trace.ZipFileAwareTrace;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceNotFoundException;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.ui.generator.trace.IEclipseTrace;
import org.eclipse.xtext.ui.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class TraceForTypeRootProvider
implements ITraceForTypeRootProvider {
    private static final Logger log = Logger.getLogger(TraceForTypeRootProvider.class);
    private static final String SOURCE_ATTACHMENT_ENCODING = "source_encoding";
    @Inject
    private TraceRegionSerializer traceRegionSerializer;
    @Inject
    private Provider<ZipFileAwareTrace> zipFileAwareTraceProvider;
    @Inject
    private Provider<FolderAwareTrace> folderAwareTraceProvider;
    @Inject
    private TraceFileNameProvider traceFileNameProvider;
    @Inject
    private ITraceForStorageProvider traceForStorageProvider;
    @Inject
    private IWorkspace workspace;
    private Pair<ITypeRoot, IEclipseTrace> lruCache = null;

    protected SourceRelativeURI getPathInFragmentRoot(ITypeRoot derivedResource, String simpleFileName) {
        if (simpleFileName == null) {
            return null;
        }
        return new SourceRelativeURI(URI.createURI((String)(derivedResource.getParent().getElementName().replace('.', '/') + "/" + simpleFileName)));
    }

    protected String getJavaSimpleFileName(ITypeRoot derivedResource) {
        IType type = derivedResource.findPrimaryType();
        if (type == null) {
            return null;
        }
        String sourceName = ((BinaryType)type).getSourceFileName(null);
        if (sourceName == null) {
            return null;
        }
        if (sourceName.endsWith(".java")) {
            return sourceName;
        }
        if (sourceName.endsWith(".xtend")) {
            String name = type.getElementName();
            int index = name.indexOf("$");
            if (index > 0) {
                name = name.substring(0, index);
            }
            return name + ".java";
        }
        return null;
    }

    protected IPath getSourcePath(ITypeRoot derivedJavaType) {
        IJavaElement current = derivedJavaType.getParent();
        while (current != null) {
            if (current instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot fragmentRoot = (IPackageFragmentRoot)current;
                try {
                    IPath attachmentPath = fragmentRoot.getSourceAttachmentPath();
                    if (attachmentPath != null) {
                        return attachmentPath;
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                if (current instanceof JarPackageFragmentRoot) {
                    return fragmentRoot.getPath();
                }
            }
            current = current.getParent();
        }
        return null;
    }

    protected Charset getSourceEncoding(ITypeRoot derivedJavaType) {
        try {
            IJavaElement current = derivedJavaType.getParent();
            while (current != null) {
                if (current instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)current;
                    try {
                        IClasspathAttribute[] attributes = root.getResolvedClasspathEntry().getExtraAttributes();
                        int i = 0;
                        int length = attributes.length;
                        while (i < length) {
                            IClasspathAttribute attribute = attributes[i];
                            if (SOURCE_ATTACHMENT_ENCODING.equals(attribute.getName())) {
                                return Charset.forName(attribute.getValue());
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                    return Charset.forName(ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset());
                }
                current = current.getParent();
            }
            return Charset.forName(ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset());
        }
        catch (CoreException e) {
            log.error((Object)("Error determining encoding for source file for " + derivedJavaType.getElementName()), (Throwable)e);
            return Charsets.UTF_8;
        }
    }

    protected boolean isZipFile(IPath path) {
        if (path.getFileExtension() == null) {
            return false;
        }
        String ext = path.getFileExtension();
        return "jar".equalsIgnoreCase(ext) || "zip".equalsIgnoreCase(ext);
    }

    @Override
    public IEclipseTrace getTraceToSource(ITypeRoot derivedJavaType) {
        if (this.lruCache != null && ((ITypeRoot)this.lruCache.getFirst()).equals(derivedJavaType)) {
            return (IEclipseTrace)this.lruCache.getSecond();
        }
        IEclipseTrace trace = this.createTraceToSource(derivedJavaType);
        if (derivedJavaType.isReadOnly()) {
            this.lruCache = Tuples.create((Object)derivedJavaType, (Object)trace);
        }
        return trace;
    }

    private IEclipseTrace createTraceToSource(ITypeRoot derivedJavaType) {
        if (derivedJavaType instanceof IClassFile) {
            return this.getTraceToSource((IClassFile)derivedJavaType);
        }
        if (derivedJavaType instanceof ICompilationUnit) {
            return this.getTraceToSource((ICompilationUnit)derivedJavaType);
        }
        throw new IllegalStateException("Unknown type " + String.valueOf(derivedJavaType));
    }

    public IEclipseTrace getTraceToSource(ICompilationUnit javaFile) {
        IResource resource;
        block3: {
            resource = null;
            try {
                resource = javaFile.getUnderlyingResource();
            }
            catch (JavaModelException e) {
                resource = this.getResourceFromNonSrcFolder(javaFile);
                if (resource != null) break block3;
                log.error((Object)"Error finding trace to source", (Throwable)e);
            }
        }
        if (resource instanceof IStorage) {
            return (IEclipseTrace)this.traceForStorageProvider.getTraceToSource((Object)((IStorage)resource));
        }
        return null;
    }

    private IResource getResourceFromNonSrcFolder(ICompilationUnit javaFile) {
        IWorkspaceRoot workspaceRoot = this.workspace.getRoot();
        return workspaceRoot.findMember(javaFile.getPath());
    }

    public IEclipseTrace getTraceToSource(IClassFile classFile) {
        class TraceRegionProvider
        implements ITraceRegionProvider {
            private AbstractTraceWithoutStorage trace;
            private final /* synthetic */ String val$javaSimpleFileName;
            private final /* synthetic */ IClassFile val$classFile;

            TraceRegionProvider(AbstractTraceWithoutStorage trace, String string, IClassFile iClassFile) {
                this.val$javaSimpleFileName = string;
                this.val$classFile = iClassFile;
                this.trace = trace;
            }

            public AbstractTraceRegion getTraceRegion() {
                block6: {
                    AbstractTraceRegion abstractTraceRegion;
                    if (this.val$javaSimpleFileName == null) {
                        throw new TraceNotFoundException();
                    }
                    String traceSimpleFileName = TraceForTypeRootProvider.this.traceFileNameProvider.getTraceFromJava(this.val$javaSimpleFileName);
                    SourceRelativeURI traceURI = TraceForTypeRootProvider.this.getPathInFragmentRoot((ITypeRoot)this.val$classFile, traceSimpleFileName);
                    InputStream contents = this.trace.getContents(traceURI, this.trace.getLocalProject());
                    if (contents == null) break block6;
                    try {
                        abstractTraceRegion = TraceForTypeRootProvider.this.traceRegionSerializer.readTraceRegionFrom(contents);
                    }
                    catch (Throwable throwable) {
                        try {
                            contents.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            log.error((Object)"Error finding trace region", (Throwable)e);
                        }
                    }
                    contents.close();
                    return abstractTraceRegion;
                }
                throw new TraceNotFoundException();
            }
        }
        IPath sourcePath = this.getSourcePath((ITypeRoot)classFile);
        if (sourcePath == null) {
            return null;
        }
        IProject project = classFile.getJavaProject().getProject();
        String javaSimpleFileName = this.getJavaSimpleFileName((ITypeRoot)classFile);
        SourceRelativeURI localURI = this.getPathInFragmentRoot((ITypeRoot)classFile, javaSimpleFileName);
        if (this.isZipFile(sourcePath)) {
            ZipFileAwareTrace zipFileAwareTrace = (ZipFileAwareTrace)((Object)this.zipFileAwareTraceProvider.get());
            zipFileAwareTrace.setProject(project);
            zipFileAwareTrace.setZipFilePath(sourcePath);
            zipFileAwareTrace.setLocalURI(localURI);
            zipFileAwareTrace.setEncoding(this.getSourceEncoding((ITypeRoot)classFile));
            zipFileAwareTrace.setTraceRegionProvider(new TraceRegionProvider(zipFileAwareTrace, javaSimpleFileName, classFile));
            return zipFileAwareTrace;
        }
        FolderAwareTrace folderAwareTrace = (FolderAwareTrace)((Object)this.folderAwareTraceProvider.get());
        folderAwareTrace.setProject(project);
        folderAwareTrace.setRootFolder(sourcePath.toString());
        folderAwareTrace.setLocalURI(localURI);
        folderAwareTrace.setEncoding(this.getSourceEncoding((ITypeRoot)classFile));
        folderAwareTrace.setTraceRegionProvider(new TraceRegionProvider(folderAwareTrace, javaSimpleFileName, classFile));
        return folderAwareTrace;
    }
}

