/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.quickfix;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.services.XtendGrammarAccess;
import org.eclipse.xtend.core.typing.XtendExpressionHelper;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.buildpath.Junit4LibClasspathAdder;
import org.eclipse.xtend.ide.buildpath.Junit5LibClasspathAdder;
import org.eclipse.xtend.ide.buildpath.XtendLibClasspathAdder;
import org.eclipse.xtend.ide.codebuilder.InsertionOffsets;
import org.eclipse.xtend.ide.codebuilder.MemberFromSuperImplementor;
import org.eclipse.xtend.ide.quickfix.CreateMemberQuickfixes;
import org.eclipse.xtend.ide.quickfix.CreateXtendTypeQuickfixes;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.model.edit.ITextualMultiModification;
import org.eclipse.xtext.ui.editor.model.edit.IssueModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.refactoring.IRenameRefactoringProvider;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.impl.RenameElementProcessor;
import org.eclipse.xtext.ui.refactoring.ui.IRenameContextFactory;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.util.DisplayRunHelper;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.StopWatch;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.ui.contentassist.ReplacingAppendable;
import org.eclipse.xtext.xbase.ui.document.DocumentSourceAppender;
import org.eclipse.xtext.xbase.ui.imports.OrganizeImportsHandler;
import org.eclipse.xtext.xbase.ui.quickfix.XbaseQuickfixProvider;

@Singleton
public class XtendQuickfixProvider
extends XbaseQuickfixProvider {
    private static final Logger logger = Logger.getLogger(XtendQuickfixProvider.class);
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private ReplacingAppendable.Factory appendableFactory;
    @Inject
    private XtendGrammarAccess grammarAccess;
    @Inject
    private InsertionOffsets insertionOffsets;
    @Inject
    private MemberFromSuperImplementor superMemberImplementor;
    @Inject
    private XtendLibClasspathAdder xtendLibAdder;
    @Inject
    private Junit4LibClasspathAdder junit4LibAdder;
    @Inject
    private Junit5LibClasspathAdder junit5LibAdder;
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private CreateXtendTypeQuickfixes createTypeQuickfixes;
    @Inject
    private CreateMemberQuickfixes createMemberQuickfixes;
    @Inject
    private OverrideHelper overrideHelper;
    @Inject
    private IBatchTypeResolver batchTypeResolver;
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private OrganizeImportsHandler organizeImportsHandler;
    @Inject
    private XtendExpressionHelper expressionHelper;
    @Inject
    private IRenameRefactoringProvider renameRefactoringProvider;
    @Inject
    private IRenameContextFactory renameContextFactory;
    private static final Set<String> LINKING_ISSUE_CODES = Sets.newHashSet((Object[])new String[]{"org.eclipse.xtext.diagnostics.Diagnostic.Linking", "org.eclipse.xtend.core.validation.IssueCodes.java_doc_linking", "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types", "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments"});

    public boolean hasResolutionFor(String issueCode) {
        return LINKING_ISSUE_CODES.contains(issueCode) || super.hasResolutionFor(issueCode);
    }

    public List<IssueResolution> getResolutions(Issue issue) {
        StopWatch stopWatch = new StopWatch(logger);
        try {
            if (LINKING_ISSUE_CODES.contains(issue.getCode())) {
                ArrayList<IssueResolution> result = new ArrayList<IssueResolution>();
                result.addAll(this.getResolutionsForLinkingIssue(issue));
                if (!result.isEmpty()) {
                    ArrayList<IssueResolution> arrayList = result;
                    return arrayList;
                }
            }
            List list = super.getResolutions(issue);
            return list;
        }
        finally {
            stopWatch.resetAndLog("#getResolutions");
        }
    }

    protected EReference getUnresolvedEReference(Issue issue, EObject target) {
        EReference reference = super.getUnresolvedEReference(issue, target);
        if (reference == null && issue.getCode().equals("org.eclipse.xtend.core.validation.IssueCodes.java_doc_linking")) {
            return TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE;
        }
        return reference;
    }

    protected void createLinkingIssueQuickfixes(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, IXtextDocument xtextDocument, XtextResource resource, EObject referenceOwner, EReference unresolvedReference) throws Exception {
        this.javaTypeQuickfixes.addQuickfixes(issue, issueResolutionAcceptor, xtextDocument, resource, referenceOwner, unresolvedReference);
        this.createTypeQuickfixes.addQuickfixes(issue, issueResolutionAcceptor, xtextDocument, resource, referenceOwner, unresolvedReference);
        this.createMemberQuickfixes.addQuickfixes(issue, issueResolutionAcceptor, xtextDocument, resource, referenceOwner, unresolvedReference);
    }

    @Fix(value="org.eclipse.xtext.diagnostics.Diagnostic.Linking")
    public void fixJunitNotOnClasspath(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData().length != 0 && issue.getData()[0] != null) {
            String type = issue.getData()[0];
            if (type.startsWith("org.junit.jupiter.")) {
                acceptor.accept(issue, "Add JUnit 5 lib to classpath", "Add JUnit 5 lib to classpath", "julaunch.gif", new ISemanticModification(){

                    public void apply(EObject element, IModificationContext context) throws Exception {
                        ResourceSet resourceSet = element.eResource().getResourceSet();
                        IJavaProject javaProject = XtendQuickfixProvider.this.projectProvider.getJavaProject(resourceSet);
                        XtendQuickfixProvider.this.junit5LibAdder.addLibsToClasspath(javaProject, (IProgressMonitor)new NullProgressMonitor());
                    }
                });
            } else if (type.startsWith("org.junit.")) {
                acceptor.accept(issue, "Add JUnit 4 lib to classpath", "Add JUnit 4 lib to classpath", "julaunch.gif", new ISemanticModification(){

                    public void apply(EObject element, IModificationContext context) throws Exception {
                        ResourceSet resourceSet = element.eResource().getResourceSet();
                        IJavaProject javaProject = XtendQuickfixProvider.this.projectProvider.getJavaProject(resourceSet);
                        XtendQuickfixProvider.this.junit4LibAdder.addLibsToClasspath(javaProject, (IProgressMonitor)new NullProgressMonitor());
                    }
                });
            }
        }
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.wrong_file")
    public void fixWrongFileRenameClass(Issue issue, IssueResolutionAcceptor acceptor) {
        URI uri = issue.getUriToProblem();
        String className = uri.trimFileExtension().lastSegment();
        String label = String.format("Rename class to '%s'", className);
        acceptor.accept(issue, label, label, null, (element, context) -> context.getXtextDocument().modify(resource -> {
            IRenameElementContext renameContext = this.renameContextFactory.createRenameElementContext(element, null, (ITextSelection)new TextSelection((IDocument)context.getXtextDocument(), issue.getOffset().intValue(), issue.getLength().intValue()), resource);
            ProcessorBasedRefactoring refactoring = this.renameRefactoringProvider.getRenameRefactoring(renameContext);
            ((RenameElementProcessor)refactoring.getProcessor()).setNewName(className);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, monitor -> {
                try {
                    if (!refactoring.checkFinalConditions(monitor).isOK()) {
                        return;
                    }
                    Change change = refactoring.createChange(monitor);
                    change.initializeValidationData(monitor);
                    PerformChangeOperation performChangeOperation = new PerformChangeOperation(change);
                    performChangeOperation.setUndoManager(RefactoringCore.getUndoManager(), refactoring.getName());
                    performChangeOperation.setSchedulingRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                    performChangeOperation.run(monitor);
                }
                catch (CoreException e) {
                    logger.error((Object)e);
                }
            });
            return null;
        }));
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.inconsistent_indentation")
    public void fixIndentation(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Correct indentation", "Correctly indents this line in this rich string", "fix_indent.gif", new IModification(){

            public void apply(IModificationContext context) throws Exception {
                context.getXtextDocument().replace(issue.getOffset().intValue(), issue.getLength().intValue(), issue.getData()[0]);
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.missing_override")
    public void fixMissingOverride(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Change 'def' to 'override'", "Marks this function as 'override'", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XtendQuickfixProvider.this.replaceKeyword((Keyword)XtendQuickfixProvider.this.grammarAccess.getMethodModifierAccess().findKeywords(new String[]{"def"}).get(0), "override", element, context.getXtextDocument());
                if (element instanceof XtendFunction) {
                    XtendFunction function = (XtendFunction)element;
                    for (XAnnotation anno : Lists.reverse((List)function.getAnnotations())) {
                        if (anno == null || anno.getAnnotationType() == null || !Override.class.getName().equals(anno.getAnnotationType().getIdentifier())) continue;
                        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)anno);
                        context.getXtextDocument().replace(node.getOffset(), node.getLength(), "");
                    }
                }
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.obsolete_override")
    public void fixObsoleteOverride(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Change 'override' to 'def'", "Removes 'override' from this function", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XtendQuickfixProvider.this.replaceKeyword((Keyword)XtendQuickfixProvider.this.grammarAccess.getMethodModifierAccess().findKeywords(new String[]{"override"}).get(0), "def", element, context.getXtextDocument());
                if (element instanceof XtendFunction) {
                    XtendFunction function = (XtendFunction)element;
                    for (XAnnotation anno : Lists.reverse((List)function.getAnnotations())) {
                        if (anno == null || anno.getAnnotationType() == null || !Override.class.getName().equals(anno.getAnnotationType().getIdentifier())) continue;
                        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)anno);
                        context.getXtextDocument().replace(node.getOffset(), node.getLength(), "");
                    }
                }
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.obsolete_annotation_override")
    public void fixObsoleteOverrideAnnotation(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove superfluous @Override", "Removes superfluous @Override annotation from this function", "fix_indent.gif", new IModification(){

            public void apply(IModificationContext context) throws Exception {
                context.getXtextDocument().replace(issue.getOffset().intValue(), issue.getLength().intValue(), "");
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.missing_synchronized")
    public void fixMissingSynchronizedKeyword(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Mark operation as synchronized", "Marks this operation as synchronized", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                if (element instanceof XtendFunction) {
                    ((XtendFunction)element).getModifiers().add((Object)"synchronized");
                }
            }
        });
    }

    protected void replaceKeyword(Keyword keyword, String replacement, EObject container, IXtextDocument document) throws BadLocationException {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)container);
        if (node != null) {
            for (ILeafNode leafNode : node.getLeafNodes()) {
                if (leafNode.getGrammarElement() != keyword) continue;
                ITextRegion leafRegion = leafNode.getTextRegion();
                String actualReplacement = replacement;
                if (!Character.isWhitespace(document.getChar(leafRegion.getOffset() - 1))) {
                    actualReplacement = " " + replacement;
                }
                document.replace(leafRegion.getOffset(), leafRegion.getLength(), actualReplacement);
            }
        }
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.missing_constructor")
    public void addConstuctorFromSuper(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null) {
            int i = 0;
            while (i < issue.getData().length) {
                final URI constructorURI = URI.createURI((String)issue.getData()[i]);
                String javaSignature = issue.getData()[i + 1];
                String xtendSignature = "new" + javaSignature.substring(javaSignature.indexOf(40));
                acceptor.accept(issue, "Add constructor " + xtendSignature, "Add constructor " + xtendSignature, "fix_indent.gif", new ISemanticModification(){

                    public void apply(EObject element, IModificationContext context) throws Exception {
                        XtendClass clazz = (XtendClass)element;
                        JvmGenericType inferredType = XtendQuickfixProvider.this.associations.getInferredType(clazz);
                        ResolvedFeatures features = XtendQuickfixProvider.this.overrideHelper.getResolvedFeatures((JvmDeclaredType)inferredType);
                        ReplacingAppendable appendable = (ReplacingAppendable)XtendQuickfixProvider.this.appendableFactory.create(context.getXtextDocument(), (XtextResource)clazz.eResource(), XtendQuickfixProvider.this.insertionOffsets.getNewConstructorInsertOffset(null, (XtendTypeDeclaration)clazz), 0, new DocumentSourceAppender.Factory.OptionalParameters(){
                            {
                                this.ensureEmptyLinesAround = true;
                                this.baseIndentationLevel = 1;
                            }
                        });
                        EObject constructor = clazz.eResource().getResourceSet().getEObject(constructorURI, true);
                        if (constructor instanceof JvmConstructor) {
                            XtendQuickfixProvider.this.superMemberImplementor.appendConstructorFromSuper(clazz, (IResolvedConstructor)new ResolvedConstructor((JvmConstructor)constructor, features.getType()), (ISourceAppender)appendable);
                        }
                        appendable.commitChanges();
                    }
                });
                i += 2;
            }
        }
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.class_must_be_defined_abstract")
    public void implementAbstractMethods(Issue issue, IssueResolutionAcceptor acceptor) {
        this.doOverrideMethods(issue, acceptor, "Add unimplemented methods");
        acceptor.accept(issue, "Make class abstract", "Make class abstract", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XtendQuickfixProvider.this.internalDoAddAbstractKeyword(element, context);
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.anonymous_class_missing_members")
    public void implementAbstractMethodsInAnonymousClass(Issue issue, IssueResolutionAcceptor acceptor) {
        this.doOverrideMethods(issue, acceptor, "Add unimplemented methods");
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.conflicting_default_methods")
    public void overrideDefaultMethod(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null) {
            String[] stringArray = issue.getData();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String data = stringArray[n2];
                int separatorIndex = data.indexOf(124);
                if (separatorIndex > 0) {
                    String interfaceName = data.substring(0, separatorIndex);
                    String uri = data.substring(separatorIndex + 1);
                    this.doOverrideMethods(issue, acceptor, "Override conflicting method of type " + interfaceName, new String[]{uri});
                }
                ++n2;
            }
        }
    }

    protected void doOverrideMethods(Issue issue, IssueResolutionAcceptor acceptor, String label) {
        if (issue.getData() != null && issue.getData().length > 0) {
            this.doOverrideMethods(issue, acceptor, label, issue.getData());
        }
    }

    protected void doOverrideMethods(Issue issue, IssueResolutionAcceptor acceptor, String label, final String[] operationUris) {
        acceptor.accept(issue, label, label, "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XtendTypeDeclaration clazz = (XtendTypeDeclaration)element;
                JvmGenericType inferredType = (JvmGenericType)XtendQuickfixProvider.this.associations.getInferredType(clazz);
                ResolvedFeatures resolvedOperations = XtendQuickfixProvider.this.overrideHelper.getResolvedFeatures((JvmDeclaredType)inferredType);
                IXtextDocument document = context.getXtextDocument();
                int offset = XtendQuickfixProvider.this.insertionOffsets.getNewMethodInsertOffset(null, clazz);
                int currentIndentation = XtendQuickfixProvider.this.appendableFactory.getIndentationLevelAtOffset(offset, (IDocument)document, (XtextResource)clazz.eResource());
                int indentationToUse = clazz.getMembers().isEmpty() ? currentIndentation + 1 : currentIndentation;
                ReplacingAppendable appendable = (ReplacingAppendable)XtendQuickfixProvider.this.appendableFactory.create(document, (XtextResource)clazz.eResource(), offset, 0, new DocumentSourceAppender.Factory.OptionalParameters(indentationToUse){
                    {
                        this.ensureEmptyLinesAround = true;
                        this.baseIndentationLevel = n;
                    }
                });
                boolean isFirst = true;
                String[] stringArray = operationUris;
                int n = operationUris.length;
                int n2 = 0;
                while (n2 < n) {
                    String operationUriAsString = stringArray[n2];
                    URI operationURI = URI.createURI((String)operationUriAsString);
                    EObject overridden = clazz.eResource().getResourceSet().getEObject(operationURI, true);
                    if (overridden instanceof JvmOperation) {
                        if (!isFirst) {
                            appendable.newLine().newLine();
                        }
                        isFirst = false;
                        XtendQuickfixProvider.this.superMemberImplementor.appendOverrideFunction(clazz, resolvedOperations.getResolvedOperation((JvmOperation)overridden), (ISourceAppender)appendable);
                    }
                    ++n2;
                }
                appendable.commitChanges();
            }
        });
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception")
    public void addThrowsDeclaration(final Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null && issue.getData().length > 0) {
            acceptor.accept(issue, "Add throws declaration", "Add throws declaration", "fix_indent.gif", new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    XtendExecutable xtendExecutable;
                    XtextResource xtextResource;
                    String[] issueData = issue.getData();
                    List<JvmType> exceptions = XtendQuickfixProvider.this.getExceptions(issueData, xtextResource = (XtextResource)(xtendExecutable = (XtendExecutable)EcoreUtil2.getContainerOfType((EObject)element, XtendExecutable.class)).eResource());
                    if (exceptions.size() > 0) {
                        EList thrownExceptions;
                        int insertPosition;
                        if (xtendExecutable.getExpression() == null) {
                            ICompositeNode functionNode = NodeModelUtils.findActualNodeFor((EObject)xtendExecutable);
                            if (functionNode == null) {
                                throw new IllegalStateException("functionNode may not be null");
                            }
                            insertPosition = functionNode.getEndOffset();
                        } else {
                            ICompositeNode expressionNode = NodeModelUtils.findActualNodeFor((EObject)xtendExecutable.getExpression());
                            if (expressionNode == null) {
                                throw new IllegalStateException("expressionNode may not be null");
                            }
                            insertPosition = expressionNode.getOffset();
                        }
                        ReplacingAppendable appendable = (ReplacingAppendable)XtendQuickfixProvider.this.appendableFactory.create(context.getXtextDocument(), (XtextResource)xtendExecutable.eResource(), insertPosition, 0);
                        if (xtendExecutable.getExpression() == null) {
                            appendable.append((CharSequence)" ");
                        }
                        if ((thrownExceptions = xtendExecutable.getExceptions()).isEmpty()) {
                            appendable.append((CharSequence)"throws ");
                        } else {
                            appendable.append((CharSequence)", ");
                        }
                        int i = 0;
                        while (i < exceptions.size()) {
                            appendable.append(exceptions.get(i));
                            if (i != exceptions.size() - 1) {
                                appendable.append((CharSequence)", ");
                            }
                            ++i;
                        }
                        if (xtendExecutable.getExpression() != null) {
                            appendable.append((CharSequence)" ");
                        }
                        appendable.commitChanges();
                    }
                }
            });
        }
    }

    protected List<JvmType> getExceptions(String[] issueData, XtextResource resource) {
        ArrayList exceptions = Lists.newArrayList();
        int i = 0;
        while (i < issueData.length - 1) {
            URI exceptionURI = URI.createURI((String)issueData[i]);
            EObject exception = resource.getResourceSet().getEObject(exceptionURI, true);
            if (exception instanceof JvmType) {
                exceptions.add((JvmType)exception);
            }
            ++i;
        }
        return exceptions;
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception")
    public void surroundWithTryCatch(final Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() == null || issue.getData().length <= 1) {
            return;
        }
        IModificationContext modificationContext = this.getModificationContextFactory().createModificationContext(issue);
        IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        if (xtextDocument == null) {
            return;
        }
        if (this.isJvmConstructorCall(xtextDocument, issue).booleanValue()) {
            return;
        }
        acceptor.accept(issue, "Surround with try/catch block", "Surround with try/catch block", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                String[] issueData = issue.getData();
                URI childURI = URI.createURI((String)issueData[issueData.length - 1]);
                XtextResource xtextResource = (XtextResource)element.eResource();
                List<JvmType> exceptions = XtendQuickfixProvider.this.getExceptions(issueData, xtextResource);
                if (exceptions.size() > 0) {
                    EObject childThrowingException = xtextResource.getResourceSet().getEObject(childURI, true);
                    XExpression toBeSurrounded = XtendQuickfixProvider.this.findContainerExpressionInBlockExpression(childThrowingException);
                    IXtextDocument xtextDocument = context.getXtextDocument();
                    if (toBeSurrounded != null) {
                        ICompositeNode toBeSurroundedNode = NodeModelUtils.findActualNodeFor((EObject)toBeSurrounded);
                        if (toBeSurroundedNode == null) {
                            throw new IllegalStateException("toBeSurroundedNode may not be null");
                        }
                        ITextRegion toBeSurroundedRegion = toBeSurroundedNode.getTextRegion();
                        ReplacingAppendable appendable = (ReplacingAppendable)XtendQuickfixProvider.this.appendableFactory.create(context.getXtextDocument(), (XtextResource)childThrowingException.eResource(), toBeSurroundedRegion.getOffset(), toBeSurroundedRegion.getLength());
                        appendable.append((CharSequence)"try {").increaseIndentation().newLine().append((CharSequence)xtextDocument.get(toBeSurroundedRegion.getOffset(), toBeSurroundedRegion.getLength())).decreaseIndentation().newLine();
                        for (JvmType exceptionType : exceptions) {
                            appendable.append((CharSequence)"} catch (").append(exceptionType).append((CharSequence)" exc) {").increaseIndentation().newLine().append((CharSequence)"throw new RuntimeException(\"auto-generated try/catch\", exc)").decreaseIndentation().newLine();
                        }
                        appendable.append((CharSequence)"}");
                        appendable.commitChanges();
                    }
                }
            }
        });
    }

    private Boolean isJvmConstructorCall(IXtextDocument xtextDocument, final Issue issue) {
        return (Boolean)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

            public Boolean exec(XtextResource xtextResource) throws Exception {
                String[] issueData = issue.getData();
                URI childURI = URI.createURI((String)issueData[issueData.length - 1]);
                EObject childThrowingException = xtextResource.getResourceSet().getEObject(childURI, true);
                if (!(childThrowingException instanceof XFeatureCall)) {
                    return false;
                }
                XFeatureCall featureCall = (XFeatureCall)childThrowingException;
                return featureCall.getFeature() instanceof JvmConstructor;
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.wrong_package")
    public void fixPackageName(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null && issue.getData().length == 1) {
            final String expectedPackage = issue.getData()[0];
            acceptor.accept(issue, "Change package declaration to '" + expectedPackage + "'", "Change package declaration to '" + expectedPackage + "'", "package_obj.gif", new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    XtendFile file = (XtendFile)element;
                    String newPackageName = Strings.isEmpty((String)expectedPackage) ? null : expectedPackage;
                    String oldPackageName = file.getPackage();
                    for (EObject obj : file.eResource().getContents()) {
                        JvmDeclaredType type;
                        String typePackage;
                        if (!(obj instanceof JvmDeclaredType) || !Objects.equal((Object)(typePackage = (type = (JvmDeclaredType)obj).getPackageName()), (Object)oldPackageName) && (typePackage == null || !typePackage.startsWith(String.valueOf(oldPackageName) + "."))) continue;
                        type.internalSetIdentifier(null);
                        type.setPackageName(newPackageName);
                    }
                    file.setPackage(newPackageName);
                }
            });
        }
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.wrong_file")
    public void fixFileName(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null && issue.getData().length == 1) {
            String expectedFileName = issue.getData()[0];
            final IFile iFile = this.projectUtil.findFileStorage(issue.getUriToProblem(), true);
            final IPath pathToMoveTo = iFile.getParent().getFullPath().append(expectedFileName).addFileExtension(iFile.getFileExtension());
            if (!iFile.getWorkspace().getRoot().exists(pathToMoveTo)) {
                String label = "Rename file to '" + expectedFileName + ".xtend'";
                acceptor.accept(issue, label, label, "xtend_file.png", new IModification(){

                    public void apply(IModificationContext context) throws Exception {
                        DisplayRunHelper.runAsyncInDisplayThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    iFile.move(pathToMoveTo, 2, null);
                                }
                                catch (CoreException e) {
                                    logger.error((Object)e);
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    protected XExpression findContainerExpressionInBlockExpression(EObject expr) {
        if (expr == null) {
            return null;
        }
        EObject container = expr.eContainer();
        if (container instanceof XBlockExpression) {
            return (XExpression)expr;
        }
        return this.findContainerExpressionInBlockExpression(container);
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.xbase_lib_not_on_classpath")
    public void putXtendOnClasspath(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add Xtend libs to classpath", "Add Xtend libs to classpath", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                ResourceSet resourceSet = element.eResource().getResourceSet();
                IJavaProject javaProject = XtendQuickfixProvider.this.projectProvider.getJavaProject(resourceSet);
                XtendQuickfixProvider.this.xtendLibAdder.addLibsToClasspath(javaProject, (IProgressMonitor)new NullProgressMonitor());
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.missing_abstract")
    public void makeClassAbstract(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Make class abstract", "Make class abstract", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XtendQuickfixProvider.this.internalDoAddAbstractKeyword(element, context);
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.api_type_inference")
    public void specifyTypeExplicitly(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Infer type", "Infer type", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                Object featureAfterType = null;
                JvmField jvmElement = null;
                if (element instanceof XtendFunction) {
                    XtendFunction function = (XtendFunction)element;
                    featureAfterType = function.getCreateExtensionInfo() == null ? XtendPackage.Literals.XTEND_FUNCTION__NAME : XtendPackage.Literals.XTEND_FUNCTION__CREATE_EXTENSION_INFO;
                    jvmElement = XtendQuickfixProvider.this.associations.getDirectlyInferredOperation((XtendFunction)element);
                } else if (element instanceof XtendField) {
                    featureAfterType = XtendPackage.Literals.XTEND_FIELD__NAME;
                    jvmElement = XtendQuickfixProvider.this.associations.getJvmField((XtendField)element);
                }
                if (jvmElement != null) {
                    LightweightTypeReference type = XtendQuickfixProvider.this.batchTypeResolver.resolveTypes(element).getActualType((JvmIdentifiableElement)jvmElement);
                    INode node = (INode)Iterables.getFirst((Iterable)NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)featureAfterType), null);
                    if (node == null) {
                        throw new IllegalStateException("Could not determine node for " + element);
                    }
                    if (type == null) {
                        throw new IllegalStateException("Could not determine type for " + element);
                    }
                    ReplacingAppendable appendable = (ReplacingAppendable)XtendQuickfixProvider.this.appendableFactory.create(context.getXtextDocument(), (XtextResource)element.eResource(), node.getOffset(), 0);
                    appendable.append(type);
                    appendable.append((CharSequence)" ");
                    appendable.commitChanges();
                }
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.implicit_return")
    public void fixImplicitReturn(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add \"return\" keyword", "Add \"return\" keyword", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)element);
                ReplacingAppendable appendable = (ReplacingAppendable)XtendQuickfixProvider.this.appendableFactory.create(context.getXtextDocument(), (XtextResource)element.eResource(), node.getOffset(), 0);
                appendable.append((CharSequence)"return ");
                appendable.commitChanges();
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.unnecessary_modifier")
    public void removeUnnecessaryModifier(Issue issue, IssueResolutionAcceptor acceptor) {
        String[] issueData = issue.getData();
        if (issueData == null || issueData.length == 0) {
            return;
        }
        String label = "Remove the unnecessary modifier.";
        String description = "The modifier is unnecessary and could be removed.";
        String image = "fix_indent.gif";
        acceptor.accept(issue, label, description, image, (IModification)new ITextualMultiModification(){

            public void apply(IModificationContext context) throws Exception {
                if (context instanceof IssueModificationContext) {
                    Issue theIssue = ((IssueModificationContext)context).getIssue();
                    Integer offset = theIssue.getOffset();
                    IXtextDocument document = context.getXtextDocument();
                    document.replace(offset.intValue(), theIssue.getLength().intValue(), "");
                    while (Character.isWhitespace(document.getChar(offset.intValue()))) {
                        document.replace(offset.intValue(), 1, "");
                    }
                }
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.missing_abstract_modifier")
    public void addModifierAccordingToTypename(Issue issue, IssueResolutionAcceptor acceptor) {
        String label = "Add missing abstract modifier.";
        String description = "Add the abstract modifier to match naming conventions for the type name. Delete final modifier if necessary.";
        String image = null;
        acceptor.accept(issue, label, description, image, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                if (element instanceof XtendClass) {
                    int index = 0;
                    EList modifiers = ((XtendClass)element).getModifiers();
                    boolean modExist = !modifiers.isEmpty();
                    modifiers.remove("final");
                    if (modifiers.contains("public") || modifiers.contains("package")) {
                        ++index;
                    }
                    if (modExist) {
                        modifiers.add(index, "abstract");
                    } else {
                        XtendQuickfixProvider.this.internalDoAddAbstractKeyword(element, context);
                    }
                }
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.invalid_return_type_in_case_of_junit_annotation")
    public void changeJUnitMethodReturnTypeToVoid(Issue issue, IssueResolutionAcceptor acceptor) {
        String label = "Change return type to void.";
        String description = "Change the return type to void to be recognized by JUnit.";
        String image = "fix_indent.gif";
        acceptor.acceptMulti(issue, label, description, image, (element, ctx) -> {
            ctx.setUpdateCrossReferences(false);
            ctx.setUpdateRelatedFiles(false);
            ctx.addModification((Notifier)element, ele -> ele.setReturnType(this.typeReferences.getTypeForName(Void.TYPE, ele, new JvmTypeReference[0])));
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.unused_private_member")
    public void removeUnusedPrivateMember(final Issue issue, IssueResolutionAcceptor acceptor) {
        String label = "Remove member.";
        String description = "Remove the unused private member.";
        String image = "delete_edit.png";
        acceptor.accept(issue, label, description, image, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                final IXtextDocument document = context.getXtextDocument();
                document.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                    public void process(XtextResource state) throws Exception {
                        EObject element = state.getEObject(issue.getUriToProblem().fragment());
                        ICompositeNode elementNode = NodeModelUtils.findActualNodeFor((EObject)element);
                        Position elementPosition = new Position(elementNode.getOffset(), elementNode.getLength());
                        document.addPosition(elementPosition);
                        if (element instanceof XtendField) {
                            JvmField field = (this).XtendQuickfixProvider.this.associations.getJvmField((XtendField)element);
                            List assignments = EcoreUtil2.eAllContentsAsList((Resource)element.eResource()).stream().filter(XAssignment.class::isInstance).map(XAssignment.class::cast).filter(assignment -> field == assignment.getFeature()).map(assignment -> {
                                ICompositeNode assignmentNode = NodeModelUtils.findActualNodeFor((EObject)assignment);
                                int offset = assignmentNode.getOffset();
                                XExpression assignmentValue = assignment.getValue();
                                int length = assignmentNode.getLength();
                                if ((this).XtendQuickfixProvider.this.expressionHelper.hasSideEffects(assignmentValue)) {
                                    length -= NodeModelUtils.findActualNodeFor((EObject)assignmentValue).getLength();
                                }
                                return new Position(offset, length);
                            }).collect(Collectors.toList());
                            for (Position assignment2 : assignments) {
                                document.addPosition(assignment2);
                            }
                            for (Position assignment2 : assignments) {
                                document.replace(assignment2.getOffset(), assignment2.getLength(), "");
                            }
                        }
                        document.replace(elementPosition.getOffset(), elementPosition.getLength(), "");
                    }
                });
                XtendQuickfixProvider.this.organizeImportsHandler.doOrganizeImports(document);
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.ternary_if_operator_is_not_allowed")
    public void refactorTernaryOperatorIntoNormalIf(Issue issue, IssueResolutionAcceptor acceptor) {
        String label = "Refactor into inline if-expression.";
        String description = "Refactor ternary expression (cond? a : b) \ninto an inline if-expression (if cond a else b).";
        String image = "delete_edit.png";
        if (issue == null) {
            return;
        }
        acceptor.accept(issue, label, description, image, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                IXtextDocument xtextDocument = context.getXtextDocument();
                if (xtextDocument == null || element == null || !(element instanceof XExpression)) {
                    return;
                }
                XIfExpression exp = (XIfExpression)element;
                ICompositeNode expNode = NodeModelUtils.findActualNodeFor((EObject)exp);
                if (expNode == null) {
                    throw new IllegalStateException("Node to refactor may not be null");
                }
                int expOffset = expNode.getTextRegion().getOffset();
                int expLength = expNode.getTextRegion().getLength();
                String ifExpr = this.buildIfExpression(exp, xtextDocument);
                xtextDocument.replace(expOffset, expLength, ifExpr);
            }

            private String buildIfExpression(XIfExpression expression, IXtextDocument document) throws Exception {
                String condStr;
                XExpression thenPart = expression.getThen();
                XExpression elsePart = expression.getElse();
                boolean outerBracketsSet = false;
                String ternExpStr = this.getString(NodeModelUtils.findActualNodeFor((EObject)expression), document);
                if (ternExpStr.endsWith(")")) {
                    outerBracketsSet = true;
                }
                if (!(condStr = this.getString(NodeModelUtils.findActualNodeFor((EObject)expression.getIf()), document)).contains("(")) {
                    condStr = "(" + condStr + ")";
                }
                String thenStr = "";
                String elseStr = "";
                if (thenPart instanceof XIfExpression && ((XIfExpression)thenPart).isConditionalExpression()) {
                    thenStr = this.buildIfExpression((XIfExpression)thenPart, document);
                }
                if (elsePart != null && elsePart instanceof XIfExpression && ((XIfExpression)elsePart).isConditionalExpression()) {
                    elseStr = this.buildIfExpression((XIfExpression)elsePart, document);
                }
                if (thenStr.isEmpty()) {
                    thenStr = this.getString(NodeModelUtils.findActualNodeFor((EObject)thenPart), document);
                }
                if (elsePart != null && elseStr.isEmpty()) {
                    elseStr = this.getString(NodeModelUtils.findActualNodeFor((EObject)elsePart), document);
                }
                String ifExpStr = this.combineIfExpParts(condStr, thenStr, elseStr, outerBracketsSet);
                return ifExpStr;
            }

            private String combineIfExpParts(String condStr, String thenStr, String elseStr, boolean outerBracketsSet) {
                String ifExpr = "if " + condStr + " " + thenStr;
                if (!elseStr.isEmpty()) {
                    ifExpr = String.valueOf(ifExpr) + " else " + elseStr;
                }
                if (outerBracketsSet) {
                    ifExpr = "(" + ifExpr + ")";
                }
                return ifExpr;
            }

            private String getString(ICompositeNode partNode, IXtextDocument doc) throws Exception {
                if (partNode == null) {
                    throw new IllegalStateException("Node to refactor may not be null");
                }
                ITextRegion partRegion = partNode.getTextRegion();
                int partOffset = partRegion.getOffset();
                int partLength = partRegion.getLength();
                String partString = doc.get(partOffset, partLength);
                return partString;
            }
        });
    }

    protected void internalDoAddAbstractKeyword(EObject element, IModificationContext context) throws BadLocationException {
        if (element instanceof XtendFunction) {
            element = element.eContainer();
        }
        if (element instanceof XtendClass) {
            XtendClass clazz = (XtendClass)element;
            IXtextDocument document = context.getXtextDocument();
            ICompositeNode clazzNode = NodeModelUtils.findActualNodeFor((EObject)clazz);
            if (clazzNode == null) {
                throw new IllegalStateException("Cannot determine node for clazz " + clazz.getName());
            }
            int offset = -1;
            for (ILeafNode leafNode : clazzNode.getLeafNodes()) {
                if (!leafNode.getText().equals("class")) continue;
                offset = leafNode.getOffset();
                break;
            }
            ReplacingAppendable appendable = (ReplacingAppendable)this.appendableFactory.create(document, (XtextResource)clazz.eResource(), offset, 0);
            appendable.append((CharSequence)"abstract ");
            appendable.commitChanges();
        }
    }

    static /* synthetic */ XtendExpressionHelper access$0(XtendQuickfixProvider xtendQuickfixProvider) {
        return xtendQuickfixProvider.expressionHelper;
    }
}

