/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.symbol;

import com.google.common.graph.Traverser;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.ReferenceAcceptor;
import org.eclipse.xtext.findReferences.TargetURICollector;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.DocumentExtensions;
import org.eclipse.xtext.ide.server.symbol.HierarchicalDocumentSymbolService;
import org.eclipse.xtext.ide.server.symbol.IDocumentSymbolService;
import org.eclipse.xtext.ide.util.CancelIndicatorProgressMonitor;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class DocumentSymbolService
implements IDocumentSymbolService {
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private TargetURICollector targetURICollector;
    @Inject
    private Provider<TargetURIs> targetURIProvider;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private HierarchicalDocumentSymbolService hierarchicalDocumentSymbolService;

    public List<? extends Location> getDefinitions(Document document, XtextResource resource, DefinitionParams params, IReferenceFinder.IResourceAccess resourceAccess, CancelIndicator cancelIndicator) {
        int offset = document.getOffSet(params.getPosition());
        return this.getDefinitions(resource, offset, resourceAccess, cancelIndicator);
    }

    public List<? extends Location> getDefinitions(XtextResource resource, int offset, IReferenceFinder.IResourceAccess resourceAccess, CancelIndicator cancelIndicator) {
        EObject element = this.eObjectAtOffsetHelper.getElementWithNameAt(resource, offset);
        if (element == null) {
            return Collections.emptyList();
        }
        ArrayList locations = new ArrayList();
        TargetURIs targetURIs = this.collectTargetURIs(element);
        for (URI targetURI : targetURIs) {
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            this.doRead(resourceAccess, targetURI, (Procedures.Procedure1<? super EObject>)((Procedures.Procedure1)obj -> {
                Location location = this.getDocumentExtensions(targetURI).newLocation((EObject)obj);
                if (location != null) {
                    locations.add(location);
                }
            }));
        }
        return locations;
    }

    public List<? extends Location> getReferences(Document document, XtextResource resource, ReferenceParams params, IReferenceFinder.IResourceAccess resourceAccess, IResourceDescriptions indexData, CancelIndicator cancelIndicator) {
        int offset = document.getOffSet(params.getPosition());
        List<Object> definitions = Collections.emptyList();
        if (params.getContext().isIncludeDeclaration()) {
            definitions = this.getDefinitions(resource, offset, resourceAccess, cancelIndicator);
        }
        List<? extends Location> references = this.getReferences(resource, offset, resourceAccess, indexData, cancelIndicator);
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(definitions);
        result.addAll(references);
        return result;
    }

    public List<? extends Location> getReferences(XtextResource resource, int offset, IReferenceFinder.IResourceAccess resourceAccess, IResourceDescriptions indexData, CancelIndicator cancelIndicator) {
        EObject element = this.eObjectAtOffsetHelper.resolveElementAt(resource, offset);
        if (element == null) {
            return Collections.emptyList();
        }
        ArrayList locations = new ArrayList();
        TargetURIs targetURIs = this.collectTargetURIs(element);
        this.referenceFinder.findAllReferences(targetURIs, resourceAccess, indexData, (IReferenceFinder.Acceptor)new ReferenceAcceptor(this.resourceServiceProviderRegistry, reference -> {
            URI sourceEObjectUri = reference.getSourceEObjectUri();
            this.doRead(resourceAccess, sourceEObjectUri, (Procedures.Procedure1<? super EObject>)((Procedures.Procedure1)obj -> {
                Location location = this.getDocumentExtensions(sourceEObjectUri).newLocation((EObject)obj, (EStructuralFeature)reference.getEReference(), reference.getIndexInList());
                if (location != null) {
                    locations.add(location);
                }
            }));
        }), (IProgressMonitor)new CancelIndicatorProgressMonitor(cancelIndicator));
        return locations;
    }

    protected TargetURIs collectTargetURIs(EObject targetObject) {
        TargetURIs targetURIs = (TargetURIs)this.targetURIProvider.get();
        this.targetURICollector.add(targetObject, targetURIs);
        return targetURIs;
    }

    @Override
    public List<DocumentSymbol> getSymbols(Document document, XtextResource resource, DocumentSymbolParams params, CancelIndicator cancelIndicator) {
        return this.getSymbols(resource, cancelIndicator);
    }

    public List<DocumentSymbol> getSymbols(XtextResource resource, CancelIndicator cancelIndicator) {
        ArrayList<DocumentSymbol> infos = new ArrayList<DocumentSymbol>();
        List<DocumentSymbol> rootSymbols = this.hierarchicalDocumentSymbolService.getSymbols(resource, cancelIndicator);
        for (DocumentSymbol rootSymbol : rootSymbols) {
            Iterable symbols = Traverser.forTree(DocumentSymbol::getChildren).depthFirstPreOrder((Object)rootSymbol);
            for (DocumentSymbol s : symbols) {
                infos.add(s);
            }
        }
        return infos;
    }

    protected EObject getContainer(EObject obj) {
        return obj.eContainer();
    }

    protected WorkspaceSymbol createSymbol(String uri, DocumentSymbol symbol, Functions.Function1<? super DocumentSymbol, ? extends String> containerNameProvider) {
        WorkspaceSymbol workspaceSymbol = new WorkspaceSymbol();
        workspaceSymbol.setName(symbol.getName());
        workspaceSymbol.setKind(symbol.getKind());
        workspaceSymbol.setTags(symbol.getTags());
        Location location = new Location();
        location.setUri(uri);
        location.setRange(symbol.getSelectionRange());
        workspaceSymbol.setLocation(Either.forLeft((Object)location));
        workspaceSymbol.setContainerName((String)containerNameProvider.apply((Object)symbol));
        return workspaceSymbol;
    }

    protected WorkspaceSymbol createSymbol(EObject object) {
        String name = this.getSymbolName(object);
        if (name == null) {
            return null;
        }
        SymbolKind kind = this.getSymbolKind(object);
        if (kind == null) {
            return null;
        }
        Location location = this.getSymbolLocation(object);
        if (location == null) {
            return null;
        }
        WorkspaceSymbol symbol = new WorkspaceSymbol();
        symbol.setName(name);
        symbol.setKind(kind);
        symbol.setLocation(Either.forLeft((Object)location));
        return symbol;
    }

    protected String getSymbolName(EObject object) {
        return this.getSymbolName(this.qualifiedNameProvider.getFullyQualifiedName(object));
    }

    protected SymbolKind getSymbolKind(EObject object) {
        return this.getSymbolKind(object.eClass());
    }

    protected Location getSymbolLocation(EObject object) {
        return this.getDocumentExtensions(object.eResource().getURI()).newLocation(object);
    }

    public List<? extends WorkspaceSymbol> getSymbols(IResourceDescription resourceDescription, String query, IReferenceFinder.IResourceAccess resourceAccess, CancelIndicator cancelIndicator) {
        LinkedList symbols = new LinkedList();
        for (IEObjectDescription description : resourceDescription.getExportedObjects()) {
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            if (!this.filter(description, query)) continue;
            this.createSymbol(description, resourceAccess, (Procedures.Procedure1<? super WorkspaceSymbol>)((Procedures.Procedure1)symbol -> symbols.add(symbol)));
        }
        return symbols;
    }

    protected boolean filter(IEObjectDescription description, String query) {
        return description.getQualifiedName().toLowerCase().toString().contains(query.toLowerCase());
    }

    protected void createSymbol(IEObjectDescription description, IReferenceFinder.IResourceAccess resourceAccess, Procedures.Procedure1<? super WorkspaceSymbol> acceptor) {
        String name = this.getSymbolName(description);
        if (name == null) {
            return;
        }
        SymbolKind kind = this.getSymbolKind(description);
        if (kind == null) {
            return;
        }
        this.getSymbolLocation(description, resourceAccess, (Procedures.Procedure1<? super Location>)((Procedures.Procedure1)location -> {
            WorkspaceSymbol symbol = new WorkspaceSymbol(name, kind, Either.forLeft((Object)location));
            acceptor.apply((Object)symbol);
        }));
    }

    protected WorkspaceSymbol createSymbol(IEObjectDescription description) {
        String symbolName = this.getSymbolName(description);
        if (symbolName == null) {
            return null;
        }
        SymbolKind symbolKind = this.getSymbolKind(description);
        if (symbolKind == null) {
            return null;
        }
        WorkspaceSymbol symbol = new WorkspaceSymbol();
        symbol.setName(symbolName);
        symbol.setKind(symbolKind);
        return symbol;
    }

    protected String getSymbolName(IEObjectDescription description) {
        return this.getSymbolName(description.getQualifiedName());
    }

    protected SymbolKind getSymbolKind(IEObjectDescription description) {
        return this.getSymbolKind(description.getEClass());
    }

    protected void getSymbolLocation(IEObjectDescription description, IReferenceFinder.IResourceAccess resourceAccess, Procedures.Procedure1<? super Location> acceptor) {
        this.doRead(resourceAccess, description.getEObjectURI(), (Procedures.Procedure1<? super EObject>)((Procedures.Procedure1)obj -> {
            Location location = this.getSymbolLocation((EObject)obj);
            if (location != null) {
                acceptor.apply((Object)location);
            }
        }));
    }

    protected String getSymbolName(QualifiedName qualifiedName) {
        if (qualifiedName != null) {
            return qualifiedName.toString();
        }
        return null;
    }

    protected SymbolKind getSymbolKind(EClass type) {
        return SymbolKind.Property;
    }

    protected void doRead(IReferenceFinder.IResourceAccess resourceAccess, URI objectURI, Procedures.Procedure1<? super EObject> acceptor) {
        resourceAccess.readOnly(objectURI, resourceSet -> {
            EObject object = resourceSet.getEObject(objectURI, true);
            if (object != null) {
                acceptor.apply((Object)object);
            }
            return null;
        });
    }

    private DocumentExtensions getDocumentExtensions(URI targetURI) {
        return (DocumentExtensions)this.resourceServiceProviderRegistry.getResourceServiceProvider(targetURI.trimFragment()).get(DocumentExtensions.class);
    }
}

