/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.jdt;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.PatternSearchJob;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.AbstractJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.access.impl.TypeResourceServices;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;
import org.eclipse.xtext.common.types.access.jdt.IJdtTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.JdtBasedTypeFactory;
import org.eclipse.xtext.common.types.access.jdt.JdtTypeMirror;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.resource.ResourceSetContext;
import org.eclipse.xtext.resource.SynchronizedXtextResourceSet;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Wrapper;

public class JdtTypeProvider
extends AbstractJvmTypeProvider
implements IJdtTypeProvider {
    private static final String PRIMITIVES = URIHelperConstants.PRIMITIVES_URI.segment(0);
    private static final boolean SKIP_SECONDARY_TYPES = Boolean.getBoolean("xtext.skipSecondaryTypes");
    private final IJavaProject javaProject;
    private final TypeURIHelper typeUriHelper;
    private final JdtBasedTypeFactory typeFactory;
    private final WorkingCopyOwner workingCopyOwner;

    public JdtTypeProvider(IJavaProject javaProject, ResourceSet resourceSet) {
        this(javaProject, resourceSet, null);
    }

    public JdtTypeProvider(IJavaProject javaProject, ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess) {
        this(javaProject, resourceSet, indexedJvmTypeAccess, null);
    }

    @Deprecated
    public JdtTypeProvider(IJavaProject javaProject, ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess, WorkingCopyOwner workingCopyOwner) {
        this(javaProject, resourceSet, indexedJvmTypeAccess, workingCopyOwner, null);
    }

    public JdtTypeProvider(IJavaProject javaProject, ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess, WorkingCopyOwner workingCopyOwner, TypeResourceServices services) {
        super(resourceSet, indexedJvmTypeAccess, services);
        if (javaProject == null) {
            throw new IllegalArgumentException("javaProject may not be null");
        }
        this.javaProject = javaProject;
        this.typeUriHelper = this.createTypeURIHelper();
        this.workingCopyOwner = workingCopyOwner;
        this.typeFactory = this.createTypeFactory();
    }

    protected JdtBasedTypeFactory createTypeFactory() {
        return new JdtBasedTypeFactory(this.typeUriHelper, this.workingCopyOwner);
    }

    protected TypeURIHelper createTypeURIHelper() {
        return new TypeURIHelper();
    }

    public JvmType findTypeByName(String name) {
        return this.doFindTypeByName(name, false);
    }

    protected JvmType doFindTypeByName(String name, boolean traverseNestedTypes) {
        String signature = this.getSignature(name);
        if (signature == null) {
            return null;
        }
        URI resourceURI = this.typeUriHelper.createResourceURI(signature);
        if (resourceURI.segment(0) == PRIMITIVES) {
            return this.findPrimitiveType(signature, resourceURI);
        }
        return this.findObjectType(signature, resourceURI, traverseNestedTypes);
    }

    public JvmType findTypeByName(String name, boolean binaryNestedTypeDelimiter) {
        JvmType result = this.doFindTypeByName(name, false);
        if (result != null || this.isBinaryNestedTypeDelimiter(name, binaryNestedTypeDelimiter)) {
            return result;
        }
        AbstractJvmTypeProvider.ClassNameVariants nameVariants = new AbstractJvmTypeProvider.ClassNameVariants(name);
        while (result == null && nameVariants.hasNext()) {
            String nextVariant = (String)nameVariants.next();
            result = this.doFindTypeByName(nextVariant, true);
        }
        return result;
    }

    private String getSignature(String name) {
        if (Strings.isEmpty((String)name)) {
            throw new IllegalArgumentException("null");
        }
        String signature = null;
        try {
            signature = name.startsWith("[") ? name : Signature.createTypeSignature((String)name, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JvmType findObjectType(String signature, URI resourceURI, boolean traverseNestedTypes) {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet instanceof SynchronizedXtextResourceSet) {
            Object object = ((SynchronizedXtextResourceSet)resourceSet).getLock();
            synchronized (object) {
                return this.doFindObjectType(signature, resourceURI, traverseNestedTypes);
            }
        }
        return this.doFindObjectType(signature, resourceURI, traverseNestedTypes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JvmType doFindObjectType(String signature, URI resourceURI, boolean traverseNestedTypes) {
        TypeResource resource = this.getLoadedResourceForJavaURI(resourceURI);
        try {
            JvmType result = this.findLoadedOrDerivedObjectType(signature, resourceURI, resource, traverseNestedTypes);
            if (result != null || resource != null) {
                if (result != null && !this.canLink(result)) {
                    return null;
                }
                return result;
            }
            try {
                return this.findObjectTypeInJavaProject(signature, resourceURI, traverseNestedTypes);
            }
            catch (JavaModelException e) {
                return null;
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        catch (IndexedJvmTypeAccess.ShadowedTypeException e) {
            return null;
        }
        catch (IndexedJvmTypeAccess.UnknownNestedTypeException e) {
            return null;
        }
    }

    private boolean canLink(JvmType type) {
        IndexedJvmTypeAccess indexedJvmTypeAccess;
        Resource resource = type.eResource();
        if (resource instanceof TypeResource) {
            IMirror mirror = ((TypeResource)resource).getMirror();
            if (mirror instanceof JdtTypeMirror) {
                try {
                    return this.canLink(((JdtTypeMirror)mirror).getMirroredType());
                }
                catch (JavaModelException e) {
                    return false;
                }
            }
            return true;
        }
        URI resourceURI = resource.getURI();
        return !resourceURI.isPlatformResource() || !resourceURI.segment(1).equals(this.javaProject.getProject().getName()) || (indexedJvmTypeAccess = this.getIndexedJvmTypeAccess()) == null || !indexedJvmTypeAccess.isIndexingPhase((Notifier)this.getResourceSet());
    }

    private JvmType findLoadedOrDerivedObjectType(String signature, URI resourceURI, TypeResource resource, boolean traverseNestedTypes) throws IndexedJvmTypeAccess.UnknownNestedTypeException {
        JvmType result;
        JvmType jvmType = result = resource != null ? this.findTypeBySignature(signature, resource, traverseNestedTypes) : null;
        if (result != null) {
            return result;
        }
        result = this.findObjectTypeInIndex(signature, resourceURI);
        if (result != null) {
            return result;
        }
        return null;
    }

    private JvmType findObjectTypeInJavaProject(String signature, URI resourceURI, boolean traverseNestedTypes) throws JavaModelException {
        IType type = this.findObjectTypeInJavaProject(resourceURI);
        if (type != null) {
            try {
                return this.createResourceAndFindType(resourceURI, type, signature, traverseNestedTypes);
            }
            catch (IOException ioe) {
                return null;
            }
            catch (WrappedException wrapped) {
                if (wrapped.getCause() instanceof IOException) {
                    return null;
                }
                throw wrapped;
            }
        }
        return null;
    }

    private JvmType createResourceAndFindType(URI resourceURI, IType type, String signature, boolean traverseNestedTypes) throws IOException {
        TypeResource resource = this.createResource(resourceURI, type);
        resource.load(Collections.singletonMap("OPTION_CLASSPATH_CONTEXT", this.javaProject));
        return this.findTypeBySignature(signature, resource, traverseNestedTypes);
    }

    private TypeResource createResource(URI resourceURI, IType type) {
        TypeResource resource = this.doCreateResource(resourceURI);
        this.getResourceSet().getResources().add((Object)resource);
        if (type.exists()) {
            IMirror mirror = this.createMirror(type);
            resource.setMirror(mirror);
        }
        return resource;
    }

    private IType findObjectTypeInJavaProject(URI resourceURI) throws JavaModelException {
        String topLevelType = resourceURI.segment(resourceURI.segmentCount() - 1);
        return this.findObjectTypeInJavaProject(topLevelType);
    }

    private IType findObjectTypeInJavaProject(String topLevelType) throws JavaModelException {
        IType type;
        int lastDot = topLevelType.lastIndexOf(46);
        String packageName = null;
        String typeName = topLevelType;
        if (lastDot != -1) {
            typeName = typeName.substring(lastDot + 1);
            packageName = topLevelType.substring(0, lastDot);
        }
        if ((type = this.findPrimaryType(packageName, typeName)) == null && !SKIP_SECONDARY_TYPES) {
            type = this.findSecondaryType(Strings.emptyIfNull((String)packageName), typeName);
        }
        if (type != null && !this.canLink(type)) {
            return null;
        }
        return type;
    }

    protected IType findPrimaryType(String packageName, String typeName) throws JavaModelException {
        JavaProject casted = (JavaProject)this.javaProject;
        NameLookup nameLookup = this.getNameLookup(casted);
        NameLookup.Answer answer = nameLookup.findType(typeName, packageName, false, 0x100001E, false, true, false, null);
        return answer == null ? null : answer.type;
    }

    private NameLookup getNameLookup(JavaProject casted) throws JavaModelException {
        return casted.newNameLookup(this.getWorkingCopies());
    }

    protected IType findSecondaryType(String packageName, final String typeName) throws JavaModelException {
        Wrapper result;
        int copiesLength;
        IPackageFragmentRoot[] sourceFolders = this.getSourceFolders();
        IndexManager indexManager = JavaModelManager.getIndexManager();
        if (indexManager.awaitingJobsCount() > 0) {
            return this.findSecondaryTypeInSourceFolders(packageName, typeName, sourceFolders);
        }
        TypeDeclarationPattern pattern = new TypeDeclarationPattern(packageName == null ? CharOperation.NO_CHAR : packageName.toCharArray(), CharOperation.NO_CHAR_CHAR, typeName.toCharArray(), 'S', 8);
        final HashSet<String> workingCopyPaths = new HashSet<String>();
        String workingCopyPath = null;
        ICompilationUnit[] copies = this.getWorkingCopies();
        int n = copiesLength = copies == null ? 0 : copies.length;
        if (copies != null) {
            if (copiesLength == 1) {
                ICompilationUnit singleWC = copies[0];
                if (singleWC.getPackageDeclaration(packageName).exists() && (result = singleWC.getType(typeName)).exists()) {
                    return result;
                }
                workingCopyPath = copies[0].getPath().toString();
            } else {
                int i = 0;
                while (i < copiesLength) {
                    IType result2;
                    ICompilationUnit workingCopy = copies[i];
                    if (workingCopy.getPackageDeclaration(packageName).exists() && (result2 = workingCopy.getType(typeName)).exists()) {
                        return result2;
                    }
                    workingCopyPaths.add(workingCopy.getPath().toString());
                    ++i;
                }
            }
        }
        final String singleWkcpPath = workingCopyPath;
        result = Wrapper.forType(IType.class);
        IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                switch (copiesLength) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (singleWkcpPath == null) {
                            throw new IllegalStateException();
                        }
                        if (!singleWkcpPath.equals(documentPath)) break;
                        return true;
                    }
                    default: {
                        if (!workingCopyPaths.contains(documentPath)) break;
                        return true;
                    }
                }
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(documentPath));
                ICompilationUnit unit = JavaCore.createCompilationUnitFrom((IFile)file);
                IType type = unit.getType(typeName);
                result.set((Object)type);
                return false;
            }
        };
        try {
            indexManager.performConcurrentJob((IJob)new PatternSearchJob((SearchPattern)pattern, BasicSearchEngine.getDefaultSearchParticipant(), BasicSearchEngine.createJavaSearchScope((IJavaElement[])sourceFolders), searchRequestor), 3, null);
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
        return (IType)result.get();
    }

    protected IType findSecondaryTypeInSourceFolders(String packageName, String typeName, IPackageFragmentRoot[] sourceFolders) throws JavaModelException {
        IPackageFragmentRoot[] iPackageFragmentRootArray = sourceFolders;
        int n = sourceFolders.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot sourceFolder = iPackageFragmentRootArray[n2];
            IPackageFragment packageFragment = sourceFolder.getPackageFragment(Strings.emptyIfNull((String)packageName));
            if (packageFragment.exists()) {
                ICompilationUnit[] units;
                ICompilationUnit[] iCompilationUnitArray = units = packageFragment.getCompilationUnits();
                int n3 = units.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICompilationUnit unit = iCompilationUnitArray[n4];
                    IType type = unit.getType(typeName);
                    if (type.exists()) {
                        return type;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private ICompilationUnit[] getWorkingCopies() {
        if (ResourceSetContext.get((Notifier)this.getResourceSet()).isBuilder()) {
            return new ICompilationUnit[0];
        }
        return JavaModelManager.getJavaModelManager().getWorkingCopies((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, false);
    }

    private IPackageFragmentRoot[] getSourceFolders() throws JavaModelException {
        if (this.javaProject instanceof JavaProject) {
            return this.getSourceFolders((JavaProject)this.javaProject);
        }
        IPackageFragmentRoot[] allRoots = this.javaProject.getAllPackageFragmentRoots();
        int length = allRoots.length;
        int size = 0;
        IPackageFragmentRoot[] allSourceFolders = new IPackageFragmentRoot[length];
        int i = 0;
        while (i < length) {
            if (allRoots[i].getKind() == 1) {
                allSourceFolders[size++] = allRoots[i];
            }
            ++i;
        }
        if (size < length) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = allSourceFolders;
            allSourceFolders = new IPackageFragmentRoot[size];
            System.arraycopy(iPackageFragmentRootArray, 0, allSourceFolders, 0, size);
        }
        return allSourceFolders;
    }

    private IPackageFragmentRoot[] getSourceFolders(JavaProject javaProject) throws JavaModelException {
        ObjectVector result = new ObjectVector();
        this.collectSourcePackageFragmentRoots(javaProject, Sets.newHashSet(), null, result);
        Object[] rootArray = new IPackageFragmentRoot[result.size()];
        result.copyInto(rootArray);
        return rootArray;
    }

    private void collectSourcePackageFragmentRoots(JavaProject javaProject, HashSet<String> rootIDs, IClasspathEntry referringEntry, ObjectVector result) throws JavaModelException {
        if (referringEntry == null) {
            rootIDs.add(javaProject.rootID());
        } else if (rootIDs.contains(javaProject.rootID())) {
            return;
        }
        IWorkspaceRoot workspaceRoot = javaProject.getProject().getWorkspace().getRoot();
        IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            switch (entry.getEntryKind()) {
                case 2: {
                    IProject casted;
                    if (referringEntry != null && !entry.isExported()) {
                        return;
                    }
                    IPath pathToProject = entry.getPath();
                    IResource referencedProject = workspaceRoot.findMember(pathToProject);
                    if (referencedProject == null || referencedProject.getType() != 4 || !JavaProject.hasJavaNature((IProject)(casted = (IProject)referencedProject))) break;
                    rootIDs.add(javaProject.rootID());
                    JavaProject referencedJavaProject = (JavaProject)JavaCore.create((IProject)casted);
                    this.collectSourcePackageFragmentRoots(referencedJavaProject, rootIDs, entry, result);
                    break;
                }
                case 3: {
                    Object target;
                    IPath projectPath = javaProject.getProject().getFullPath();
                    IPath entryPath = entry.getPath();
                    if (!projectPath.isPrefixOf(entryPath) || (target = JavaModel.getTarget((IPath)entryPath, (boolean)true)) == null || !(target instanceof IFolder) && !(target instanceof IProject)) break;
                    IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)target);
                    result.add((Object)root);
                }
            }
            ++n2;
        }
    }

    protected boolean canLink(IType type) throws JavaModelException {
        IndexedJvmTypeAccess indexedJvmTypeAccess = this.getIndexedJvmTypeAccess();
        if (indexedJvmTypeAccess != null && indexedJvmTypeAccess.isIndexingPhase((Notifier)this.getResourceSet())) {
            IResource underlyingResource = type.getUnderlyingResource();
            if (underlyingResource == null) {
                return true;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource srcUnderlyingResource;
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getKind() == 1 && (srcUnderlyingResource = root.getUnderlyingResource()) != null && srcUnderlyingResource.contains((ISchedulingRule)underlyingResource)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return true;
    }

    private JvmType findObjectTypeInIndex(String signature, URI resourceURI) throws IndexedJvmTypeAccess.UnknownNestedTypeException {
        URI proxyURI;
        EObject candidate;
        IndexedJvmTypeAccess indexedJvmTypeAccess = this.getIndexedJvmTypeAccess();
        if (indexedJvmTypeAccess != null && (candidate = indexedJvmTypeAccess.getIndexedJvmType(proxyURI = resourceURI.appendFragment(this.typeUriHelper.getFragment(signature)), this.getResourceSet(), true)) instanceof JvmType) {
            return (JvmType)candidate;
        }
        return null;
    }

    private TypeResource getLoadedResourceForJavaURI(URI resourceURI) {
        TypeResource resource = (TypeResource)this.getResourceForJavaURI(resourceURI, false);
        return resource;
    }

    private JvmType findPrimitiveType(String signature, URI resourceURI) {
        TypeResource resource = (TypeResource)this.getResourceForJavaURI(resourceURI, true);
        JvmType result = this.findTypeBySignature(signature, resource, false);
        return result;
    }

    protected Resource getResourceForJavaURI(URI resourceURI, boolean loadOnDemand) {
        return this.getResourceSet().getResource(resourceURI, loadOnDemand);
    }

    public JvmType findTypeBySignature(String signature, TypeResource resource) {
        return this.findTypeBySignature(signature, resource, false);
    }

    private JvmType findTypeBySignature(String signature, TypeResource resource, boolean traverseNestedTypes) {
        String fragment = this.typeUriHelper.getFragment(signature);
        JvmType result = (JvmType)resource.getEObject(fragment);
        if (result != null || !traverseNestedTypes) {
            return result;
        }
        EList contents = resource.getContents();
        if (contents.isEmpty()) {
            return null;
        }
        String rootTypeName = resource.getURI().segment(1);
        String nestedTypeName = fragment.substring(rootTypeName.length() + 1);
        List segments = Strings.split((String)nestedTypeName, (String)"$");
        EObject rootType = (EObject)contents.get(0);
        if (rootType instanceof JvmDeclaredType) {
            result = this.findNestedType((JvmDeclaredType)rootType, segments, 0);
        }
        return result;
    }

    protected IMirror createMirrorForFQN(String name) {
        IType type;
        block3: {
            try {
                type = this.findObjectTypeInJavaProject(name);
                if (type != null && type.exists()) break block3;
                return null;
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        return this.createMirror(type);
    }

    protected IMirror createMirror(IType type) {
        String elementName = type.getElementName();
        if (!elementName.equals(type.getTypeQualifiedName())) {
            return null;
        }
        return new JdtTypeMirror(type, this.typeFactory, this.services);
    }

    @Override
    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    @Override
    public TypeURIHelper getTypeUriHelper() {
        return this.typeUriHelper;
    }

    public JdtBasedTypeFactory getJdtBasedTypeFactory() {
        return this.typeFactory;
    }
}

