/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.ide.serializer.hooks.IEObjectSnapshot;
import org.eclipse.xtext.ide.serializer.hooks.IReferenceSnapshot;
import org.eclipse.xtext.ide.serializer.hooks.IResourceSnapshot;

public class RelatedResourcesProvider {
    public List<RelatedResource> getRelatedResources(Collection<IResourceSnapshot> snapshots) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (IResourceSnapshot res : snapshots) {
            for (IEObjectSnapshot obj : res.getObjects().values()) {
                for (IReferenceSnapshot ref : obj.getIncomingReferences()) {
                    URI source = ref.getSourceEObjectUri().trimFragment();
                    RelatedResource related = (RelatedResource)result.get(source);
                    if (related == null) {
                        related = new RelatedResource(source);
                        result.put(source, related);
                    }
                    related.outgoingReferences.add(ref);
                }
            }
        }
        HashSet added = Sets.newHashSet();
        HashSet removed = Sets.newHashSet();
        for (IResourceSnapshot res : snapshots) {
            URI newUri;
            URI oldUri = res.getURI();
            if (!oldUri.equals(newUri = res.getResource().getURI())) {
                added.add(newUri);
                removed.add(oldUri);
                continue;
            }
            result.remove(newUri);
        }
        removed.removeAll(added);
        for (URI uri : removed) {
            result.remove(uri);
        }
        return ImmutableList.copyOf(result.values());
    }

    public static class RelatedResource {
        protected final List<IReferenceSnapshot> outgoingReferences = Lists.newArrayList();
        protected final URI uri;

        public RelatedResource(URI uri) {
            this.uri = uri;
        }

        public URI getUri() {
            return this.uri;
        }

        public String toString() {
            ArrayList out = Lists.newArrayList();
            for (IReferenceSnapshot s : this.outgoingReferences) {
                out.add(s.toString());
            }
            Collections.sort(out);
            return String.valueOf(this.getClass().getSimpleName()) + " " + this.uri + "\n" + Joiner.on((String)"\n").join((Iterable)out);
        }
    }
}

