/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.generator.trace;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.generator.trace.FileOpener;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.Strings;

public class StorageBasedTextEditorOpener
extends FileOpener {
    private static final Logger LOG = Logger.getLogger(StorageBasedTextEditorOpener.class);
    private final ITextRegion region;
    private final IStorage storage;

    public StorageBasedTextEditorOpener(IStorage storage) {
        this(storage, null);
    }

    public StorageBasedTextEditorOpener(IStorage storage, ITextRegion region) {
        this.storage = storage;
        this.region = region;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        IWorkbenchAdapter workbenchAdapter = this.adapt(this.storage, IWorkbenchAdapter.class);
        return workbenchAdapter != null ? workbenchAdapter.getImageDescriptor((Object)this.storage) : null;
    }

    @Override
    public String getQualifiedLabel() {
        String path = this.storage.getFullPath().toString();
        String regionLabel = this.getRegionLabel();
        if (Strings.isEmpty((String)regionLabel)) {
            return path;
        }
        return String.valueOf(path) + " " + regionLabel;
    }

    protected String getRegionLabel() {
        if (this.region instanceof ITextRegionWithLineInformation) {
            ITextRegionWithLineInformation lines = (ITextRegionWithLineInformation)this.region;
            if (lines.getLineNumber() == lines.getEndLineNumber()) {
                return String.format("line %d", lines.getLineNumber());
            }
            return String.format("lines %d-%d", lines.getLineNumber(), lines.getEndLineNumber());
        }
        if (this.region != null) {
            return String.format("offset %d, lenght %d", this.region.getOffset(), this.region.getLength());
        }
        return "";
    }

    @Override
    public String getShortLabel() {
        return this.storage.getName();
    }

    @Override
    public void open(IWorkbenchPage page) {
        try {
            IEditorInput input = EditorUtils.createEditorInput(this.storage);
            IEditorDescriptor editorDescriptor = IDE.getEditorDescriptor((String)this.storage.getName(), (boolean)true, (boolean)false);
            IEditorPart opened = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)editorDescriptor.getId());
            if (this.region != null && opened instanceof ITextEditor) {
                ITextEditor openedTextEditor = (ITextEditor)opened;
                openedTextEditor.selectAndReveal(this.region.getOffset(), this.region.getLength());
            }
        }
        catch (PartInitException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

