/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.autoedit;

import com.google.inject.Singleton;
import org.eclipse.xtext.ui.editor.model.TerminalsTokenTypeToPartitionMapper;

@Singleton
public class TokenTypeToPartitionMapper
extends TerminalsTokenTypeToPartitionMapper {
    public static final String JAVA_DOC_PARTITION = "__java_javadoc";
    public static final String RICH_STRING_LITERAL_PARTITION = "__rich_string";
    public static final String[] SUPPORTED_TOKEN_TYPES = new String[]{"__comment", "__java_javadoc", "__sl_comment", "__string", "__rich_string", "__dftl_partition_content_type"};

    protected String calculateId(String tokenName, int tokenType) {
        if ("RULE_RICH_TEXT".equals(tokenName) || "RULE_RICH_TEXT_START".equals(tokenName) || "RULE_RICH_TEXT_END".equals(tokenName) || "RULE_RICH_TEXT_INBETWEEN".equals(tokenName) || "RULE_COMMENT_RICH_TEXT_END".equals(tokenName) || "RULE_COMMENT_RICH_TEXT_INBETWEEN".equals(tokenName)) {
            return RICH_STRING_LITERAL_PARTITION;
        }
        if ("RULE_ML_COMMENT".equals(tokenName)) {
            return "__comment";
        }
        return super.calculateId(tokenName, tokenType);
    }

    protected String getMappedValue(int tokenType) {
        if (tokenType == -10000) {
            return JAVA_DOC_PARTITION;
        }
        return super.getMappedValue(tokenType);
    }

    public String[] getSupportedPartitionTypes() {
        return SUPPORTED_TOKEN_TYPES;
    }

    public boolean isMultiLineComment(String partitionType) {
        return super.isMultiLineComment(partitionType) || JAVA_DOC_PARTITION.equals(partitionType);
    }
}

