/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.java.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.descriptions.EObjectDescriptionBasedStubGenerator;
import org.eclipse.xtext.java.resource.ClassFileCache;
import org.eclipse.xtext.java.resource.JavaResource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class IndexAwareNameEnvironment
implements INameEnvironment {
    private final Resource resource;
    private final ClassLoader classLoader;
    private final IResourceDescriptions resourceDescriptions;
    private final EObjectDescriptionBasedStubGenerator stubGenerator;
    private final ClassFileCache classFileCache;
    private Map<QualifiedName, NameEnvironmentAnswer> nameToAnswerCache = new HashMap<QualifiedName, NameEnvironmentAnswer>();

    public void cleanup() {
        this.nameToAnswerCache.clear();
        this.classFileCache.clear();
    }

    public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
        List segments = Arrays.stream(compoundTypeName).map(String::valueOf).collect(Collectors.toList());
        QualifiedName className = QualifiedName.create(segments);
        return this.findType(className);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NameEnvironmentAnswer findType(QualifiedName className) {
        try {
            if (this.classFileCache.containsKey(className)) {
                IBinaryType t = this.classFileCache.get(className);
                if (t != null) return new NameEnvironmentAnswer(t, null);
                return null;
            }
            if (this.nameToAnswerCache.containsKey(className)) {
                return this.nameToAnswerCache.get(className);
            }
            IEObjectDescription candidate = (IEObjectDescription)IterableExtensions.head((Iterable)this.resourceDescriptions.getExportedObjects(TypesPackage.Literals.JVM_DECLARED_TYPE, className, false));
            NameEnvironmentAnswer result = null;
            if (candidate != null) {
                IResourceDescription resourceDescription = this.resourceDescriptions.getResourceDescription(candidate.getEObjectURI().trimFragment());
                Resource res = this.resource.getResourceSet().getResource(resourceDescription.getURI(), false);
                String source = null;
                source = res instanceof JavaResource ? ((JavaResource)res).getOriginalSource() : this.stubGenerator.getJavaStubSource(candidate, resourceDescription);
                CompilationUnit compilationUnit = new CompilationUnit(source.toCharArray(), String.valueOf(className.toString("/")) + ".java", null);
                result = new NameEnvironmentAnswer((ICompilationUnit)compilationUnit, null);
            } else {
                String fileName = String.valueOf(className.toString("/")) + ".class";
                URL url = this.classLoader.getResource(fileName);
                if (url == null) {
                    this.nameToAnswerCache.put(className, null);
                    this.classFileCache.put(className, null);
                    return null;
                }
                ClassFileReader reader = null;
                Throwable throwable = null;
                Object var8_15 = null;
                try (InputStream stream = url.openStream();){
                    reader = ClassFileReader.read((InputStream)stream, (String)fileName);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                if (reader == null) {
                    return null;
                }
                this.classFileCache.put(className, (IBinaryType)reader);
                result = new NameEnvironmentAnswer((IBinaryType)reader, null);
            }
            this.nameToAnswerCache.put(className, result);
            return result;
        }
        catch (IOException | ClassFormatException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        List segments = Arrays.stream(packageName).map(String::valueOf).collect(Collectors.toList());
        segments.add(String.valueOf(typeName));
        QualifiedName className = QualifiedName.create(segments);
        return this.findType(className);
    }

    public boolean isPackage(char[][] parentPackageName, char[] packageName) {
        if (packageName == null || packageName.length == 0) {
            return false;
        }
        return Character.isLowerCase(packageName[0]);
    }

    public IndexAwareNameEnvironment(Resource resource, ClassLoader classLoader, IResourceDescriptions resourceDescriptions, EObjectDescriptionBasedStubGenerator stubGenerator, ClassFileCache classFileCache) {
        this.resource = resource;
        this.classLoader = classLoader;
        this.resourceDescriptions = resourceDescriptions;
        this.stubGenerator = stubGenerator;
        this.classFileCache = classFileCache;
    }
}

