/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.xtend.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.xtend.XtendFile;
import org.eclipse.internal.xtend.xtend.ast.AbstractExtension;
import org.eclipse.internal.xtend.xtend.ast.Around;
import org.eclipse.internal.xtend.xtend.ast.Check;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.ast.ExtensionImportStatement;
import org.eclipse.internal.xtend.xtend.ast.NamespaceImportStatement;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFile
extends SyntaxElement
implements XtendFile {
    private static final List<NamespaceImportStatement> EMPTY_NAMESPACEIMPORTSTATEMENTS = Collections.emptyList();
    private static final List<ExtensionImportStatement> EMPTY_EXTENSION_IMPORT_STATEMENTS = Collections.emptyList();
    private static final List<Extension> EMPTY_EXTENSIONS = Collections.emptyList();
    private static final List<Around> EMPTY_AROUNDS = Collections.emptyList();
    private static final List<Check> EMPTY_CHECKS = Collections.emptyList();
    private final List<NamespaceImportStatement> nsImports;
    private final List<ExtensionImportStatement> extImports;
    private final List<Extension> extensions;
    private final List<Around> arounds;
    private final List<Check> checks;
    private String fullyQualifiedName;

    public List<Check> getChecks() {
        return this.checks;
    }

    public ExtensionFile(List<NamespaceImportStatement> nsImports, List<ExtensionImportStatement> extImports, List<Extension> extensions, List<Around> arounds, List<Check> checks) {
        this.nsImports = nsImports != null && !nsImports.isEmpty() ? nsImports : EMPTY_NAMESPACEIMPORTSTATEMENTS;
        this.extImports = extImports != null && !extImports.isEmpty() ? extImports : EMPTY_EXTENSION_IMPORT_STATEMENTS;
        this.extensions = extensions != null && !extensions.isEmpty() ? extensions : EMPTY_EXTENSIONS;
        this.arounds = arounds != null && !arounds.isEmpty() ? arounds : EMPTY_AROUNDS;
        this.checks = checks != null && !checks.isEmpty() ? checks : EMPTY_CHECKS;
        for (Extension extension : this.extensions) {
            extension.setExtensionFile(this);
        }
        for (Around around : this.arounds) {
            around.setParent(this);
        }
    }

    @Override
    public List<Around> getArounds() {
        return this.arounds;
    }

    @Override
    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public List<ExtensionImportStatement> getExtImports() {
        return this.extImports;
    }

    public List<NamespaceImportStatement> getNsImports() {
        return this.nsImports;
    }

    @Override
    public String[] getImportedNamespaces() {
        ArrayList<String> namespaces = new ArrayList<String>();
        for (NamespaceImportStatement nsImport : this.nsImports) {
            namespaces.add(nsImport.getImportedId().toString());
        }
        return namespaces.toArray(new String[namespaces.size()]);
    }

    public List<String> getImportedNamespacesAsList() {
        return Arrays.asList(this.getImportedNamespaces());
    }

    @Override
    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        ExecutionContext _ctx = ctx;
        try {
            HashMap<String, Object> info;
            _ctx = _ctx.cloneWithResource(this);
            if (_ctx.getCallback() != null && !_ctx.getCallback().pre(this, _ctx)) {
                return;
            }
            for (ExtensionImportStatement imp : this.extImports) {
                imp.analyze(_ctx, issues);
            }
            HashSet<Identifier> uniqueNames = new HashSet<Identifier>();
            for (ExtensionImportStatement extensionImportStatement : this.extImports) {
                if (uniqueNames.contains(extensionImportStatement.getImportedId())) {
                    String msg = "Duplicate extension importing: " + extensionImportStatement.getImportedId().toString();
                    issues.add(new AnalysationIssue(AnalysationIssue.SYNTAX_ERROR, msg, extensionImportStatement));
                }
                uniqueNames.add(extensionImportStatement.getImportedId());
            }
            for (Extension extension : this.extensions) {
                try {
                    extension.analyze(_ctx, issues);
                }
                catch (RuntimeException ex) {
                    info = new HashMap<String, Object>();
                    info.put("extension", extension);
                    _ctx.handleRuntimeException(ex, this, info);
                }
            }
            for (Around around : this.arounds) {
                try {
                    around.analyze(_ctx, issues);
                }
                catch (RuntimeException ex) {
                    info = new HashMap();
                    info.put("around", around);
                    _ctx.handleRuntimeException(ex, this, info);
                }
            }
            for (Check check : this.checks) {
                try {
                    check.analyze(_ctx, issues);
                }
                catch (RuntimeException ex) {
                    _ctx.handleRuntimeException(ex, this, null);
                }
            }
            for (NamespaceImportStatement namespaceImportStatement : this.nsImports) {
                namespaceImportStatement.analyze(_ctx, issues);
            }
            this.checkAmbiguous(_ctx, issues);
        }
        finally {
            if (_ctx.getCallback() != null) {
                _ctx.getCallback().post(this, _ctx, null);
            }
        }
    }

    private void checkAmbiguous(ExecutionContext ctx, Set<AnalysationIssue> issuesFromThisResource) {
        HashMap<Extension, Extension> allExtensions = new HashMap<Extension, Extension>();
        for (Extension extension : this.getExtensions()) {
            extension.init(ctx);
            Extension old = allExtensions.put(extension, extension);
            if (old == null) continue;
            issuesFromThisResource.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "Duplicate extension definition: " + extension.toOutlineString() + " also defined in Line " + old.getLine(), (AbstractExtension)extension, false, extension.getLine()));
            issuesFromThisResource.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "Duplicate extension definition: " + extension.toOutlineString() + " also defined in Line " + extension.getLine(), (AbstractExtension)old, false, old.getLine()));
        }
        allExtensions.clear();
        allExtensions = null;
    }

    @Override
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    public String[] getImportedExtensions() {
        ArrayList<String> namespaces = new ArrayList<String>();
        for (ExtensionImportStatement extImport : this.extImports) {
            namespaces.add(extImport.getImportedId().toString());
        }
        return this.getImportedExtensionsAsList().toArray(new String[namespaces.size()]);
    }

    public List<String> getImportedExtensionsAsList() {
        ArrayList<String> namespaces = new ArrayList<String>();
        for (ExtensionImportStatement extImport : this.extImports) {
            namespaces.add(extImport.getImportedId().toString());
        }
        return namespaces;
    }

    @Override
    public List<Extension> getPublicExtensions(ResourceManager rm, ExecutionContext ctx) {
        return this.getPublicExtensions(rm, ctx, new HashSet<String>());
    }

    @Override
    public List<Extension> getPublicExtensions(ResourceManager rm, ExecutionContext ctx, Set<String> flowoverCache) {
        if (flowoverCache.contains(this.getFullyQualifiedName())) {
            return new ArrayList<Extension>();
        }
        flowoverCache.add(this.getFullyQualifiedName());
        ArrayList<Extension> result = new ArrayList<Extension>();
        for (Extension ext : this.extensions) {
            if (ext.isPrivate()) continue;
            result.add(ext);
        }
        for (ExtensionImportStatement imp : this.extImports) {
            if (!imp.isExported()) continue;
            XtendFile xf = (XtendFile)rm.loadResource(imp.getImportedId().toString(), "ext");
            if (xf == null) {
                throw new RuntimeException("Unable to reexport extension file " + imp.getImportedId().toString() + " from " + this.getFullyQualifiedName());
            }
            ExecutionContext context = ctx.cloneWithResource(xf);
            List<Extension> publicExtensions = xf.getPublicExtensions(rm, context, flowoverCache);
            for (Extension extension : publicExtensions) {
                extension.init(context);
                if (result.contains(extension)) continue;
                result.add(extension);
            }
        }
        return result;
    }

    public void check(ExecutionContext ctx, Collection<?> objects, Issues issues, boolean warnIfNothingChecked) {
        ExecutionContext _ctx = ctx.cloneWithResource(this);
        for (Check check : this.checks) {
            check.validate(_ctx, objects, issues, warnIfNothingChecked);
        }
    }

    public String toString() {
        return this.getFileName();
    }
}

