/*
 * generated by Xtext
 */
package org.eclipse.xtext.xtend2.scoping;

import java.util.Set;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.annotations.scoping.XbaseWithAnnotationsScopeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IJvmFeatureDescriptionProvider;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendField;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;
import org.eclipse.xtext.xtend2.xtend2.XtendMember;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;

/**
 * @author Sven Efftinge
 * @author Sebastian Zarnekow - Implicit first argument
 */
public class Xtend2ScopeProvider extends XbaseWithAnnotationsScopeProvider {

	private static final int IMPORTED_STATIC_FEATURE_PRIORITY = 50;
	private static final int DEFAULT_EXTENSION_PRIORITY = 45;
	private static final int IMPLICIT_ARGUMENT_PRIORITY = 400;
	
	private static final int THIS_EXTENSION_PRIORITY_OFFSET = 200;
	private static final int DYNAMIC_EXTENSION_PRIORITY_OFFSET = 210;
	private static final int STATIC_EXTENSION_PRIORITY_OFFSET = 220;
	
	@Inject
	private IXtend2JvmAssociations xtend2jvmAssociations;

	@Inject
	private Provider<StaticallyImportedFeaturesProvider> staticallyImportedFeaturesProvider;

	@Inject
	private Provider<ExtensionMethodsFeaturesProvider> extensionMethodsFeaturesProvider;

	@Inject
	private TypeReferences typeReferences;

	@Override
	protected void addStaticFeatureDescriptionProviders(
			Resource resource, 
			JvmDeclaredType contextType,
			IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
		super.addStaticFeatureDescriptionProviders(resource, contextType, acceptor);
		
		StaticallyImportedFeaturesProvider staticProvider = staticallyImportedFeaturesProvider.get();
		staticProvider.setResourceContext(resource);
		staticProvider.setExtensionProvider(false);
		
		addFeatureDescriptionProviders(contextType, staticProvider, null, null, IMPORTED_STATIC_FEATURE_PRIORITY, true, acceptor);
	}
	
	@Override
	protected void addFeatureDescriptionProvidersForAssignment(
			Resource resource, JvmDeclaredType contextType,
			XExpression implicitReceiver, XExpression implicitArgument, int priority,
			IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
		super.addFeatureDescriptionProvidersForAssignment(resource, contextType, implicitReceiver, implicitArgument, priority, acceptor);
		
		if (implicitReceiver == null || implicitArgument != null) {
			final StaticallyImportedFeaturesProvider staticProvider = staticallyImportedFeaturesProvider.get();
			staticProvider.setResourceContext(resource);
			staticProvider.setExtensionProvider(true);
			if (implicitArgument != null) {
				// use the implicit argument as implicit receiver
				SimpleAcceptor casted = (SimpleAcceptor) acceptor;
				JvmTypeReference implicitArgumentType = getTypeProvider().getType(implicitArgument, true);
				IAcceptor<IJvmFeatureDescriptionProvider> myAcceptor = casted.getParent().curry(implicitArgumentType, casted.getExpression());
				addFeatureDescriptionProvidersForAssignment(contextType, staticProvider, implicitArgument, null, priority + STATIC_EXTENSION_PRIORITY_OFFSET, true, myAcceptor);
			} else {
				addFeatureDescriptionProvidersForAssignment(contextType, staticProvider, implicitReceiver, implicitArgument, priority + STATIC_EXTENSION_PRIORITY_OFFSET, true, acceptor);
			}
		}
		
		final XtendClass xtendClass = ((XtendFile) resource.getContents().get(0)).getXtendClass();
		// extensions for this
		JvmGenericType inferredJvmType = xtend2jvmAssociations.getInferredType(xtendClass);
		if (inferredJvmType != null) {
			boolean isThis = false;
			if (implicitReceiver instanceof XFeatureCall) {
				isThis = ((XFeatureCall) implicitReceiver).getFeature() == inferredJvmType;
			}
			if (implicitReceiver == null || isThis) {
				XFeatureCall callToThis = XbaseFactory.eINSTANCE.createXFeatureCall();
				callToThis.setFeature(inferredJvmType);
				// injected extensions
				Iterable<XtendField> extensionFields = getExtensionDependencies(xtendClass);
				int extensionPriority = priority + DYNAMIC_EXTENSION_PRIORITY_OFFSET;
				if (isThis && implicitArgument == null)
					extensionPriority = DEFAULT_EXTENSION_PRIORITY;
				for (XtendField extensionField : extensionFields) {
					JvmIdentifiableElement dependencyImplicitReceiver = findImplicitReceiverFor(extensionField);
					XMemberFeatureCall callToDependency = XbaseFactory.eINSTANCE.createXMemberFeatureCall();
					callToDependency.setMemberCallTarget(EcoreUtil2.clone(callToThis));
					callToDependency.setFeature(dependencyImplicitReceiver);
					if (dependencyImplicitReceiver != null) {
						ExtensionMethodsFeaturesProvider extensionFeatureProvider = extensionMethodsFeaturesProvider.get();
						extensionFeatureProvider.setContext(extensionField.getType());
						extensionFeatureProvider.setExpectNoParameters(isThis);
						addFeatureDescriptionProvidersForAssignment(contextType, extensionFeatureProvider, callToDependency, implicitArgument, extensionPriority, false, acceptor);
					}
				}
				JvmParameterizedTypeReference typeRef = typeReferences.createTypeRef(inferredJvmType);
				ExtensionMethodsFeaturesProvider featureProvider = extensionMethodsFeaturesProvider.get();
				featureProvider.setContext(typeRef);
				featureProvider.setExpectNoParameters(isThis);
				addFeatureDescriptionProvidersForAssignment(contextType, featureProvider, callToThis, implicitArgument, priority + THIS_EXTENSION_PRIORITY_OFFSET, false, acceptor);
			}
		}
	}

	@Override
	protected void addFeatureDescriptionProviders(
			Resource resource, 
			JvmDeclaredType contextType,
			XExpression implicitReceiver,
			XExpression implicitArgument,
			int priority,
			IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
		super.addFeatureDescriptionProviders(resource, contextType, implicitReceiver, implicitArgument, priority, acceptor);
		
		if (implicitReceiver == null || implicitArgument != null) {
			final StaticallyImportedFeaturesProvider staticProvider = staticallyImportedFeaturesProvider.get();
			staticProvider.setResourceContext(resource);
			staticProvider.setExtensionProvider(true);
			if (implicitArgument != null) {
				// use the implicit argument as implicit receiver
				SimpleAcceptor casted = (SimpleAcceptor) acceptor;
				JvmTypeReference implicitArgumentType = getTypeProvider().getType(implicitArgument, true);
				IAcceptor<IJvmFeatureDescriptionProvider> myAcceptor = casted.getParent().curry(implicitArgumentType, casted.getExpression());
				addFeatureDescriptionProviders(contextType, staticProvider, implicitArgument, null, priority + STATIC_EXTENSION_PRIORITY_OFFSET, true, myAcceptor);
			} else {
				addFeatureDescriptionProviders(contextType, staticProvider, implicitReceiver, implicitArgument, priority + STATIC_EXTENSION_PRIORITY_OFFSET, true, acceptor);
			}
		}
		
		final XtendClass xtendClass = ((XtendFile) resource.getContents().get(0)).getXtendClass();
		// extensions for this
		JvmGenericType inferredJvmType = xtend2jvmAssociations.getInferredType(xtendClass);
		if (inferredJvmType != null) {
			boolean isThis = false;
			if (implicitReceiver instanceof XFeatureCall) {
				isThis = ((XFeatureCall) implicitReceiver).getFeature() == inferredJvmType;
			}
			if (implicitReceiver == null || isThis) {
				XFeatureCall callToThis = XbaseFactory.eINSTANCE.createXFeatureCall();
				callToThis.setFeature(inferredJvmType);
				// injected extensions
				Iterable<XtendField> extensionFields = getExtensionDependencies(xtendClass);
				int extensionPriority = priority + DYNAMIC_EXTENSION_PRIORITY_OFFSET;
				if (isThis && implicitArgument == null)
					extensionPriority = DEFAULT_EXTENSION_PRIORITY;
				boolean isStatic = isStaticContext(((SimpleAcceptor)acceptor).getExpression());
				for (XtendField extensionField : extensionFields) {
					JvmIdentifiableElement dependencyImplicitReceiver = findImplicitReceiverFor(extensionField);
					XMemberFeatureCall callToDependency = XbaseFactory.eINSTANCE.createXMemberFeatureCall();
					callToDependency.setMemberCallTarget(EcoreUtil2.clone(callToThis));
					callToDependency.setFeature(dependencyImplicitReceiver);
					if (dependencyImplicitReceiver != null) {
						ExtensionMethodsFeaturesProvider extensionFeatureProvider = extensionMethodsFeaturesProvider.get();
						extensionFeatureProvider.setContext(extensionField.getType());
						extensionFeatureProvider.setExpectNoParameters(isThis);
						addFeatureDescriptionProviders(contextType, extensionFeatureProvider, callToDependency, implicitArgument, extensionPriority, isStatic, acceptor);
					}
				}
				JvmParameterizedTypeReference typeRef = typeReferences.createTypeRef(inferredJvmType);
				ExtensionMethodsFeaturesProvider featureProvider = extensionMethodsFeaturesProvider.get();
				featureProvider.setContext(typeRef);
				featureProvider.setExpectNoParameters(isThis);
				addFeatureDescriptionProviders(contextType, featureProvider, callToThis, implicitArgument, priority + THIS_EXTENSION_PRIORITY_OFFSET, isStatic, acceptor);
			}
		}
	}
	
	protected boolean isStaticContext(EObject expression) {
		XtendMember feature = EcoreUtil2.getContainerOfType(expression, XtendMember.class);
		if (feature instanceof XtendFunction)
			return ((XtendFunction) feature).isStatic();
		if (feature instanceof XtendField)
			return ((XtendField) feature).isStatic();
		return false;
	}
	
	protected JvmIdentifiableElement findImplicitReceiverFor(XtendField XtendField) {
		Set<EObject> elements = xtend2jvmAssociations.getJvmElements(XtendField);
		if (!elements.isEmpty()) {
			final JvmIdentifiableElement field = (JvmIdentifiableElement) elements.iterator().next();
			return field;
		}
		return null;
	}

	protected Iterable<XtendField> getExtensionDependencies(XtendClass context) {
		return Iterables.filter(EcoreUtil2.typeSelect(context.getMembers(), XtendField.class),
				new Predicate<XtendField>() {
					public boolean apply(XtendField input) {
						return input.isExtension();
					}
				});
	}

	@Override
	protected JvmDeclaredType getContextType(EObject call) {
		if (call == null)
			return null;
		XtendClass containerClass = EcoreUtil2.getContainerOfType(call, XtendClass.class);
		if (containerClass != null && containerClass.getName() != null)
			return xtend2jvmAssociations.getInferredType(containerClass);
		else
			return super.getContextType(call);
	}
	
	@Override
	protected void addFeatureCallScopes(
			EObject featureCall, 
			final IScope localVariableScope,
			final IJvmFeatureScopeAcceptor featureScopeDescriptions) {
		IEObjectDescription implicitThis = localVariableScope.getSingleElement(THIS);
		if (implicitThis != null) {
			EObject implicitReceiver = implicitThis.getEObjectOrProxy();
			if (implicitReceiver instanceof JvmIdentifiableElement) {
				JvmTypeReference receiverType = getTypeProvider().getTypeForIdentifiable((JvmIdentifiableElement) implicitReceiver);
				if (receiverType != null) {
					XFeatureCall receiver = XbaseFactory.eINSTANCE.createXFeatureCall();
					receiver.setFeature((JvmIdentifiableElement) implicitReceiver);
					IEObjectDescription implicitIt = localVariableScope.getSingleElement(IT);
					if (implicitIt != null) {
						EObject implicitArgument = implicitIt.getEObjectOrProxy();
						if (implicitArgument instanceof JvmIdentifiableElement) {
							JvmTypeReference argumentType = getTypeProvider().getTypeForIdentifiable((JvmIdentifiableElement) implicitArgument);
							if (argumentType != null) {
								XFeatureCall argument = XbaseFactory.eINSTANCE.createXFeatureCall();
								argument.setFeature((JvmIdentifiableElement) implicitArgument);
								addFeatureScopes(receiverType, featureCall, getContextType(featureCall), receiver, argument, IMPLICIT_ARGUMENT_PRIORITY, featureScopeDescriptions);
							}
						}
					}
				}
			}
		}
		super.addFeatureCallScopes(featureCall, localVariableScope, featureScopeDescriptions);
	}
}
