/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.serializer;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;
import org.eclipse.xtext.util.EmfFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugSequenceAcceptor
implements ISequenceAcceptor {
    protected static final int COLS = 5;
    protected static final ICompositeNode NO_NODE = new CompositeNode();
    protected int indentation = 0;
    protected boolean printInstantly;
    protected List<List<String>> table = Lists.newArrayList();
    protected GrammarElementTitleSwitch titles = new GrammarElementTitleSwitch().showAssignments();

    public DebugSequenceAcceptor() {
        this(false);
    }

    public DebugSequenceAcceptor(boolean printInstantly) {
        this.printInstantly = printInstantly;
    }

    public void acceptAssignedCrossRefDatatype(RuleCall rc, String token, EObject value, int index, ICompositeNode node) {
        this.add(this.titles.doSwitch((EObject)rc), token, EmfFormatter.objPath((EObject)value), index, (INode)node);
    }

    public void acceptAssignedCrossRefEnum(RuleCall enumRC, String token, EObject value, int index, ICompositeNode node) {
        this.add(this.titles.doSwitch((EObject)enumRC), token, EmfFormatter.objPath((EObject)value), index, (INode)node);
    }

    public void acceptAssignedCrossRefTerminal(RuleCall rc, String token, EObject value, int index, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)rc), token, EmfFormatter.objPath((EObject)value), index, (INode)node);
    }

    public void acceptAssignedDatatype(RuleCall datatypeRC, String token, Object value, int index, ICompositeNode node) {
        this.add(this.titles.doSwitch((EObject)datatypeRC), token, "'" + value + "'", index, (INode)node);
    }

    public void acceptAssignedEnum(RuleCall enumRC, String token, Object value, int index, ICompositeNode node) {
        this.add(this.titles.doSwitch((EObject)enumRC), token, "'" + value + "'", index, (INode)node);
    }

    public void acceptAssignedKeyword(Keyword keyword, String token, Boolean value, int index, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)keyword), token, String.valueOf(value), index, (INode)node);
    }

    public void acceptAssignedKeyword(Keyword keyword, String token, String value, int index, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)keyword), token, "'" + value + "'", index, (INode)node);
    }

    public void acceptAssignedTerminal(RuleCall terminalRC, String token, Object value, int index, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)terminalRC), token, "'" + value + "'", index, (INode)node);
    }

    public void acceptComment(AbstractRule rule, String token, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)rule), token, "", -1, (INode)node);
    }

    public void acceptUnassignedAction(Action action) {
        this.add(this.titles.doSwitch((EObject)action), "", "", -1, (INode)NO_NODE);
    }

    public void acceptUnassignedDatatype(RuleCall datatypeRC, String value, ICompositeNode node) {
        this.add(this.titles.doSwitch((EObject)datatypeRC), "'" + value + "'", "", -1, (INode)node);
    }

    public void acceptUnassignedEnum(RuleCall enumRC, String value, ICompositeNode node) {
        this.add(this.titles.doSwitch((EObject)enumRC), "'" + value + "'", "", -1, (INode)node);
    }

    public void acceptUnassignedKeyword(Keyword keyword, String token, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)keyword), "'" + token + "'", "", -1, (INode)node);
    }

    public void acceptUnassignedTerminal(RuleCall terminalRC, String value, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)terminalRC), "'" + value + "'", "", -1, (INode)node);
    }

    public void acceptWhitespace(AbstractRule rule, String token, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)rule), token, "", -1, (INode)node);
    }

    protected void add(String grammar, String token, String value, int index, INode node) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.indentation) {
            buf.append("  ");
            ++i;
        }
        buf.append(grammar);
        ArrayList row = Lists.newArrayList();
        row.add(buf.toString());
        row.add(token);
        row.add(value);
        row.add(index < 0 ? "" : String.valueOf(index));
        row.add(node == NO_NODE ? "" : this.node2text(node));
        this.table.add(row);
        if (this.printInstantly) {
            System.out.println(Joiner.on((char)'\t').join((Iterable)row));
        }
    }

    public boolean enterAssignedAction(Action action, EObject semanticChild, ICompositeNode node) {
        this.add(String.valueOf(this.titles.doSwitch((EObject)action)) + " {", semanticChild.eClass().getName(), "", -1, (INode)node);
        ++this.indentation;
        return true;
    }

    public boolean enterAssignedParserRuleCall(RuleCall rc, EObject newCurrent, ICompositeNode node) {
        this.add(String.valueOf(this.titles.doSwitch((EObject)rc)) + " {", newCurrent.eClass().getName(), "", -1, (INode)node);
        ++this.indentation;
        return true;
    }

    public void enterUnassignedParserRuleCall(RuleCall rc) {
        this.add(String.valueOf(this.titles.doSwitch((EObject)rc)) + " {", "", "", -1, (INode)NO_NODE);
        ++this.indentation;
    }

    public void finish() {
    }

    public List<String> getColumn(int i) {
        ArrayList result = Lists.newArrayList();
        for (List<String> line : this.table) {
            if (line.size() <= i || line.get(i) == null || line.get(i).length() <= 0) continue;
            result.add(line.get(i));
        }
        return result;
    }

    public List<String> getList() {
        int columns = 5;
        Object[] width = new Integer[columns - 1];
        Arrays.fill(width, (Object)1);
        for (List<String> line : this.table) {
            int i = 0;
            while (i < line.size() && i < width.length) {
                width[i] = Math.max((Integer)width[i], line.get(i).length());
                ++i;
            }
        }
        String format = "%-" + Joiner.on((String)"s %-").join(width) + "s %s";
        ArrayList lines = Lists.newArrayList();
        for (List<String> line : this.table) {
            lines.add(String.format(format, line.toArray()));
        }
        return lines;
    }

    public List<List<String>> getTable() {
        return this.table;
    }

    public void leaveAssignedAction(Action action, EObject semanticChild) {
        --this.indentation;
        this.add("}", "", "", -1, (INode)NO_NODE);
    }

    public void leaveAssignedParserRuleCall(RuleCall rc, EObject semanticChild) {
        --this.indentation;
        this.add("}", "", "", -1, (INode)NO_NODE);
    }

    public void leaveUnssignedParserRuleCall(RuleCall rc) {
        --this.indentation;
        this.add("}", "", "", -1, (INode)NO_NODE);
    }

    protected String node2text(INode node) {
        if (node == null) {
            return "(node is null)";
        }
        if (node instanceof ILeafNode) {
            return String.valueOf(this.titles.doSwitch(node.getGrammarElement())) + " -> " + node.getText();
        }
        if (node instanceof ICompositeNode) {
            return this.titles.doSwitch(node.getGrammarElement());
        }
        return "(unknown node)";
    }

    public String toString() {
        return Joiner.on((String)"\n").join(this.getList());
    }
}

