/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typing;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Set;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeConformanceComputationArgument;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeConformanceResult;
import org.eclipse.xtext.xbase.typing.Closures;
import org.eclipse.xtext.xbase.typing.SynonymTypesProvider;

@Singleton
public class XbaseTypeConformanceComputer
extends TypeConformanceComputer {
    @Inject
    private Closures closures;
    @Inject
    private SynonymTypesProvider synonymTypeProvider;

    public TypeConformanceResult isConformant(JvmTypeReference left, JvmTypeReference right, TypeConformanceComputationArgument flags) {
        TypeConformanceResult result = super.isConformant(left, right, flags);
        if (result.isConformant()) {
            return result;
        }
        if (!flags.isAsTypeArgument() && flags.isAllowPrimitiveConversion()) {
            JvmTypeReference leftFunction = this.closures.getCompatibleFunctionType(left, false, flags.isRawType());
            JvmTypeReference rightFunction = this.closures.getCompatibleFunctionType(right, false, flags.isRawType());
            if (leftFunction != null && rightFunction != null && (left != leftFunction || right != rightFunction) && (result = super.isConformant(leftFunction, rightFunction, flags)).isConformant()) {
                result = TypeConformanceResult.merge((TypeConformanceResult)result, (TypeConformanceResult)new TypeConformanceResult(TypeConformanceResult.Kind.DEMAND_CONVERSION));
                return result;
            }
        }
        Set<JvmTypeReference> synonymTypes = this.synonymTypeProvider.getSynonymTypes(right, true);
        for (JvmTypeReference synonymType : synonymTypes) {
            result = super.isConformant(left, synonymType, flags);
            if (!result.isConformant()) continue;
            return result;
        }
        return result;
    }
}

