/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.resource.IClasspathUriResolver;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.util.JdtClasspathUriResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextResourceSetProvider
implements IResourceSetProvider {
    private static final Logger LOG = Logger.getLogger(XtextResourceSetProvider.class);
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;

    @Override
    public ResourceSet get(IProject project) {
        XtextResourceSet set = (XtextResourceSet)this.resourceSetProvider.get();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null && javaProject.exists()) {
            set.getURIConverter().getURIMap().putAll(this.computePlatformURIMap(javaProject));
            set.setClasspathURIContext((Object)javaProject);
            set.setClasspathUriResolver((IClasspathUriResolver)new JdtClasspathUriResolver());
        }
        return set;
    }

    protected Map<URI, URI> computePlatformURIMap(IJavaProject javaProject) {
        HashMap hashMap = Maps.newHashMap((Map)EcorePlugin.computePlatformURIMap());
        try {
            IClasspathEntry[] classpath;
            if (!javaProject.exists()) {
                return hashMap;
            }
            IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getResolvedClasspath(true);
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classPathEntry = iClasspathEntryArray[n2];
                IPath path = classPathEntry.getPath();
                if (path != null && "jar".equals(path.getFileExtension())) {
                    try {
                        String name;
                        JarFile jarFile;
                        Manifest manifest;
                        File file = path.toFile();
                        if (file != null && file.exists() && (manifest = (jarFile = new JarFile(file)).getManifest()) != null && (name = manifest.getMainAttributes().getValue("Bundle-SymbolicName")) != null) {
                            int indexOf = name.indexOf(59);
                            if (indexOf > 0) {
                                name = name.substring(0, indexOf);
                            }
                            if (!EcorePlugin.getPlatformResourceMap().containsKey(name)) {
                                String p = "archive:" + file.toURI() + "!/";
                                URI uri = URI.createURI((String)p);
                                URI platformResourceKey = URI.createPlatformResourceURI((String)(String.valueOf(name) + "/"), (boolean)false);
                                URI platformPluginKey = URI.createPlatformPluginURI((String)(String.valueOf(name) + "/"), (boolean)false);
                                hashMap.put(platformResourceKey, uri);
                                hashMap.put(platformPluginKey, uri);
                            }
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return hashMap;
    }
}

