/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceQuery;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchResultEvents;
import org.eclipse.xtext.util.IAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceSearchResult
implements ISearchResult,
IAcceptor<IReferenceDescription> {
    private ReferenceQuery query;
    private List<IReferenceDescription> matchingReferences;
    private List<ISearchResultListener> listeners;

    protected ReferenceSearchResult(ReferenceQuery query) {
        this.query = query;
        this.matchingReferences = Lists.newArrayList();
        this.listeners = Lists.newArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEvent(SearchResultEvent searchResultEvent) {
        List<ISearchResultListener> list = this.listeners;
        synchronized (list) {
            for (ISearchResultListener listener : this.listeners) {
                listener.searchResultChanged(searchResultEvent);
            }
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getLabel() {
        return this.query.getLabel();
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public void accept(IReferenceDescription referenceDescription) {
        this.matchingReferences.add(referenceDescription);
        this.fireEvent(new ReferenceSearchResultEvents.Added(this, referenceDescription));
    }

    public List<IReferenceDescription> getMatchingReferences() {
        return this.matchingReferences;
    }

    public void reset() {
        this.matchingReferences.clear();
        this.fireEvent(new ReferenceSearchResultEvents.Reset(this));
    }

    public void finish() {
        this.fireEvent(new ReferenceSearchResultEvents.Finish(this));
    }
}

