/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.outline;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.xtext.builder.DerivedResourceMarkers;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.ui.editor.GlobalURIEditorOpener;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineNodeElementOpener;

public class JvmOutlineNodeElementOpener
extends OutlineNodeElementOpener {
    private static Logger LOG = Logger.getLogger(JvmOutlineNodeElementOpener.class);
    @Inject
    private IJavaElementFinder javaElementFinder;
    @Inject
    private DerivedResourceMarkers derivedResourceMarkers;
    @Inject
    private GlobalURIEditorOpener globalURIEditorOpener;

    protected void openEObject(EObject state) {
        try {
            IJavaElement javaElement;
            if (state instanceof JvmIdentifiableElement && (javaElement = this.javaElementFinder.findElementFor((JvmIdentifiableElement)state)) instanceof IMember) {
                IMarker[] iMarkerArray;
                IResource resource = javaElement.getResource();
                if (resource instanceof IFile && (iMarkerArray = this.derivedResourceMarkers.findDerivedResourceMarkers((IFile)resource)).length != 0) {
                    IMarker derivedResourceMarker = iMarkerArray[0];
                    URI sourceResourceURI = URI.createURI((String)this.derivedResourceMarkers.getSource(derivedResourceMarker)).trimFragment();
                    this.globalURIEditorOpener.open(sourceResourceURI, (Object)javaElement, true);
                    return;
                }
                this.globalURIEditorOpener.open(null, (Object)javaElement, true);
                return;
            }
        }
        catch (Exception exc) {
            LOG.error((Object)"Error opening java editor", (Throwable)exc);
        }
        super.openEObject(state);
    }
}

