/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.xtext.util.Exceptions;
import org.eclipse.xtext.util.ReflectionUtil;
import org.eclipse.xtext.util.SimpleCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolymorphicDispatcher<RT> {
    private static final Logger log = Logger.getLogger(PolymorphicDispatcher.class);
    private final List<? extends Object> targets;
    private final Predicate<Method> methodFilter;
    private final ErrorHandler<RT> handler;
    private final SimpleCache<List<Class<?>>, List<MethodDesc>> cache = new SimpleCache(new Function<List<Class<?>>, List<MethodDesc>>(){

        public List<MethodDesc> apply(List<Class<?>> paramTypes) {
            ArrayList<MethodDesc> result = new ArrayList<MethodDesc>();
            for (MethodDesc methodDesc : PolymorphicDispatcher.this.getDeclaredMethodsOrderedBySpecificParameterType()) {
                if (!methodDesc.isInvokeable(paramTypes)) continue;
                if (result.isEmpty()) {
                    result.add(methodDesc);
                    continue;
                }
                int compare = PolymorphicDispatcher.this.compare((MethodDesc)result.get(0), methodDesc);
                if (compare < 0) {
                    result.clear();
                    result.add(methodDesc);
                    continue;
                }
                if (compare != 0) continue;
                result.add(methodDesc);
            }
            return result;
        }
    });
    private List<MethodDesc> cachedDescriptors;

    public static <T> PolymorphicDispatcher<T> createForSingleTarget(String methodName, Object singleTarget) {
        return new PolymorphicDispatcher(methodName, Collections.singletonList(singleTarget));
    }

    public static <T> PolymorphicDispatcher<T> createForSingleTarget(String methodName, int min, int max, Object singleTarget) {
        return new PolymorphicDispatcher(methodName, min, max, Collections.singletonList(singleTarget));
    }

    public static <T> PolymorphicDispatcher<T> createForVarTarget(String methodName, Object ... targets) {
        return new PolymorphicDispatcher(methodName, Arrays.asList(targets));
    }

    public PolymorphicDispatcher(String methodName, List<? extends Object> targets) {
        this(methodName, 1, 1, targets);
    }

    public PolymorphicDispatcher(String methodName, int minParams, int maxParams, List<? extends Object> targets) {
        this(methodName, minParams, maxParams, targets, new DefaultErrorHandler());
    }

    public PolymorphicDispatcher(String methodName, int minParams, int maxParams, List<? extends Object> targets, ErrorHandler<RT> handler) {
        this(targets, new MethodNameFilter(methodName, minParams, maxParams), handler);
    }

    public PolymorphicDispatcher(List<? extends Object> targets, Predicate<Method> methodFilter) {
        this(targets, methodFilter, new DefaultErrorHandler());
    }

    public PolymorphicDispatcher(List<? extends Object> targets, Predicate<Method> methodFilter, ErrorHandler<RT> handler) {
        this.targets = targets;
        this.methodFilter = methodFilter;
        this.handler = handler;
    }

    private int compare(MethodDesc o1, MethodDesc o2) {
        List<Class<?>> paramTypes1 = Arrays.asList(o1.getParameterTypes());
        List<Class<?>> paramTypes2 = Arrays.asList(o2.getParameterTypes());
        if (paramTypes1.size() > paramTypes2.size()) {
            return 1;
        }
        if (paramTypes2.size() > paramTypes1.size()) {
            return -1;
        }
        int i = 0;
        while (i < paramTypes1.size()) {
            Class<?> class2;
            Class<?> class1 = paramTypes1.get(i);
            if (!class1.equals(class2 = paramTypes2.get(i))) {
                if (class1.isAssignableFrom(class2)) {
                    return -1;
                }
                if (class2.isAssignableFrom(class1)) {
                    return 1;
                }
            }
            ++i;
        }
        if (!o1.getDeclaringClass().equals(o2.getDeclaringClass())) {
            if (o1.getDeclaringClass().isAssignableFrom(o2.getDeclaringClass())) {
                return 1;
            }
            if (o2.getDeclaringClass().isAssignableFrom(o1.getDeclaringClass())) {
                return -1;
            }
        }
        int compareTo = Integer.valueOf(this.targets.indexOf(o2.target)).compareTo(this.targets.indexOf(o1.target));
        return compareTo;
    }

    public RT invoke(Object ... params) {
        List<MethodDesc> result = this.cache.get(this.getTypes(params));
        if (result.size() > 1) {
            return this.handleAmbigousMethods(result, params);
        }
        if (result.isEmpty()) {
            return this.handleNoSuchMethod(params);
        }
        try {
            MethodDesc current = result.get(0);
            current.method.setAccessible(true);
            return (RT)current.method.invoke(current.target, params);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            return this.handler.handle(params, e.getTargetException());
        }
        catch (IllegalArgumentException e) {
            return this.handler.handle(params, e);
        }
        catch (IllegalAccessException e) {
            return this.handler.handle(params, e);
        }
    }

    protected RT handleNoSuchMethod(Object ... params) {
        return this.handler.handle(params, new NoSuchMethodException(this.methodFilter, params));
    }

    protected RT handleAmbigousMethods(List<MethodDesc> result, Object ... params) {
        throw new IllegalStateException("Ambiguous methods " + result + " for params " + Arrays.toString(params));
    }

    private List<Class<?>> getTypes(Object[] params) {
        ArrayList result = new ArrayList(params.length);
        int i = 0;
        while (i < params.length) {
            if (params[i] != null) {
                result.add(params[i].getClass());
            } else {
                result.add(this.getDefaultClass(i));
            }
            ++i;
        }
        return result;
    }

    protected Class<?> getDefaultClass(int paramIndex) {
        return Object.class;
    }

    private List<MethodDesc> getDeclaredMethodsOrderedBySpecificParameterType() {
        if (this.cachedDescriptors != null) {
            return this.cachedDescriptors;
        }
        this.cachedDescriptors = new ArrayList<MethodDesc>();
        for (Object object : this.targets) {
            Class<?> current = object.getClass();
            while (current != Object.class) {
                Method[] methods;
                Method[] methodArray = methods = current.getDeclaredMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (this.methodFilter.apply((Object)method)) {
                        this.cachedDescriptors.add(this.createMethodDesc(object, method));
                    }
                    ++n2;
                }
                current = current.getSuperclass();
            }
        }
        Collections.sort(this.cachedDescriptors, new Comparator<MethodDesc>(){

            @Override
            public int compare(MethodDesc o1, MethodDesc o2) {
                return PolymorphicDispatcher.this.compare(o1, o2);
            }
        });
        return this.cachedDescriptors;
    }

    protected MethodDesc createMethodDesc(Object target, Method method) {
        return new MethodDesc(target, method);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultErrorHandler<RT>
    implements ErrorHandler<RT> {
        @Override
        public RT handle(Object[] params, Throwable e) {
            return (RT)Exceptions.throwUncheckedException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ErrorHandler<P> {
        public P handle(Object[] var1, Throwable var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MethodDesc {
        private final Object target;
        private final Method method;

        protected MethodDesc(Object target, Method method) {
            this.target = target;
            this.method = method;
        }

        public Class<?> getDeclaringClass() {
            return this.method.getDeclaringClass();
        }

        public Class<?>[] getParameterTypes() {
            return this.method.getParameterTypes();
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getTarget() {
            return this.target;
        }

        public boolean isInvokeable(List<Class<?>> paramTypes) {
            if (this.getParameterTypes().length != paramTypes.size()) {
                return false;
            }
            int i = 0;
            while (i < paramTypes.size()) {
                Class<?> paramClass = paramTypes.get(i);
                if (!ReflectionUtil.getObjectType(this.getParameterTypes()[i]).isAssignableFrom(ReflectionUtil.getObjectType(paramClass))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public String toString() {
            return this.method.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MethodNameFilter
    implements Predicate<Method> {
        private final int maxParams;
        private final String methodName;
        private final int minParams;

        private MethodNameFilter(String methodName, int minParams, int maxParams) {
            this.maxParams = maxParams;
            this.methodName = methodName;
            this.minParams = minParams;
        }

        public boolean apply(Method param) {
            return param.getName().equals(this.methodName) && param.getParameterTypes().length >= this.minParams && param.getParameterTypes().length <= this.maxParams;
        }

        public String toString() {
            return "'" + this.methodName + "'";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoSuchMethodException
    extends java.lang.NoSuchMethodException {
        private static final long serialVersionUID = 1L;
        private final Predicate<Method> methodFilter;
        private final Object[] params;

        public NoSuchMethodException(Predicate<Method> methodFilter, Object[] params) {
            this.methodFilter = methodFilter;
            this.params = params;
        }

        @Override
        public String getMessage() {
            return "Couldn't find method '" + this.methodFilter.toString() + "' for objects " + Arrays.toString(this.params);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NullErrorHandler<RT>
    implements ErrorHandler<RT> {
        public static <RT> ErrorHandler<RT> get() {
            return new NullErrorHandler<RT>();
        }

        @Override
        public RT handle(Object[] params, Throwable throwable) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Predicates {
        public static Predicate<Method> forName(String name) {
            return new MethodNameFilter(name, 1, 1);
        }

        public static Predicate<Method> forName(String name, int params) {
            return new MethodNameFilter(name, params, params);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WarningErrorHandler<RT>
    implements ErrorHandler<RT> {
        private Logger logger;

        public WarningErrorHandler(Logger logger) {
            this.logger = logger;
        }

        public static <RT> ErrorHandler<RT> get(Logger logger) {
            return new WarningErrorHandler<RT>(logger);
        }

        @Override
        public RT handle(Object[] params, Throwable throwable) {
            this.logger.warn((Object)("Error in polymorphic dispatcher : " + throwable.getMessage()), throwable);
            return null;
        }
    }
}

