/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.Position;
import org.eclipse.xtext.resource.EObjectHandleImpl;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextDocumentContentObserver;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.util.concurrent.IEObjectHandle;
import org.eclipse.xtext.util.concurrent.IStateAccess;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextDocument
extends Document
implements IXtextDocument {
    private XtextResource resource = null;
    private final ListenerList modelListeners = new ListenerList(1);
    private final ListenerList xtextDocumentObservers = new ListenerList(1);
    private final XtextDocumentLocker stateAccess = this.createDocumentLocker();
    private static final Logger log = Logger.getLogger(XtextDocument.class);
    private transient Job validationJob;
    private ReadWriteLock positionsLock = new ReentrantReadWriteLock();
    private Lock positionsReadLock = this.positionsLock.readLock();
    private Lock positionsWriteLock = this.positionsLock.writeLock();

    public void setInput(XtextResource resource) {
        Assert.isNotNull((Object)resource);
        this.resource = resource;
    }

    public void disposeInput() {
        if (this.resource != null) {
            ResourceSet resourceSet = this.resource.getResourceSet();
            if (resourceSet != null) {
                resourceSet.getResources().clear();
                resourceSet.eAdapters().clear();
            }
            this.resource = null;
        }
    }

    protected XtextDocumentLocker createDocumentLocker() {
        return new XtextDocumentLocker();
    }

    public <T> T readOnly(IUnitOfWork<T, XtextResource> work) {
        return (T)this.stateAccess.readOnly(work);
    }

    public <T> T modify(IUnitOfWork<T, XtextResource> work) {
        return this.stateAccess.modify(work);
    }

    protected void ensureThatStateIsNotReturned(Object exec, IUnitOfWork<?, XtextResource> uow) {
    }

    @Override
    public void addModelListener(IXtextModelListener listener) {
        Assert.isNotNull((Object)listener);
        this.modelListeners.add((Object)listener);
    }

    @Override
    public void removeModelListener(IXtextModelListener listener) {
        Assert.isNotNull((Object)listener);
        this.modelListeners.remove((Object)listener);
    }

    protected void notifyModelListeners(XtextResource res) {
        Object[] listeners = this.modelListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IXtextModelListener)listeners[i]).modelChanged(res);
            ++i;
        }
    }

    @Override
    public void addXtextDocumentContentObserver(IXtextDocumentContentObserver observer) {
        this.addDocumentListener(observer);
        this.xtextDocumentObservers.add((Object)observer);
    }

    @Override
    public void removeXtextDocumentContentObserver(IXtextDocumentContentObserver observer) {
        this.xtextDocumentObservers.remove((Object)observer);
        this.removeDocumentListener(observer);
    }

    protected <T> void updateContentBeforeRead() {
        Object[] listeners = this.xtextDocumentObservers.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IXtextDocumentContentObserver)listeners[i]).performNecessaryUpdates(this.stateAccess);
            ++i;
        }
    }

    public void setValidationJob(Job validationJob) {
        this.validationJob = validationJob;
    }

    public void checkAndUpdateAnnotations() {
        this.validationJob.cancel();
        this.validationJob.schedule();
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        URI uri = this.resource.getURI();
        if ((adapterType == IFile.class || adapterType == IResource.class) && uri.isPlatformResource()) {
            return (T)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        }
        return null;
    }

    @Override
    public <T extends EObject> IEObjectHandle<T> createHandle(T obj) {
        return new EObjectHandleImpl(obj, (IStateAccess)this);
    }

    public Position[] getPositions(String category, int offset, int length, boolean canStartBefore, boolean canEndAfter) throws BadPositionCategoryException {
        this.positionsReadLock.lock();
        try {
            Position[] positionArray = super.getPositions(category, offset, length, canStartBefore, canEndAfter);
            return positionArray;
        }
        finally {
            this.positionsReadLock.unlock();
        }
    }

    public Position[] getPositions(String category) throws BadPositionCategoryException {
        this.positionsReadLock.lock();
        try {
            Position[] positionArray = super.getPositions(category);
            return positionArray;
        }
        finally {
            this.positionsReadLock.unlock();
        }
    }

    public void addPosition(Position position) throws BadLocationException {
        this.positionsWriteLock.lock();
        try {
            super.addPosition(position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }

    public void addPosition(String category, Position position) throws BadLocationException, BadPositionCategoryException {
        this.positionsWriteLock.lock();
        try {
            super.addPosition(category, position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }

    public void removePosition(Position position) {
        this.positionsWriteLock.lock();
        try {
            super.removePosition(position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }

    public void removePosition(String category, Position position) throws BadPositionCategoryException {
        this.positionsWriteLock.lock();
        try {
            super.removePosition(category, position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XtextDocumentLocker
    extends IStateAccess.AbstractImpl<XtextResource>
    implements IXtextDocumentContentObserver.Processor {
        protected XtextDocumentLocker() {
        }

        protected XtextResource getState() {
            return XtextDocument.this.resource;
        }

        protected void beforeReadOnly(XtextResource res, IUnitOfWork<?, XtextResource> work) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("read - " + Thread.currentThread().getName()));
            }
            XtextDocument.this.updateContentBeforeRead();
        }

        protected void beforeModify(XtextResource state, IUnitOfWork<?, XtextResource> work) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("write - " + Thread.currentThread().getName()));
            }
        }

        protected void afterReadOnly(XtextResource res, Object result, IUnitOfWork<?, XtextResource> work) {
            XtextDocument.this.ensureThatStateIsNotReturned(result, work);
        }

        protected void afterModify(XtextResource res, Object result, IUnitOfWork<?, XtextResource> work) {
            XtextDocument.this.ensureThatStateIsNotReturned(result, work);
            XtextDocument.this.notifyModelListeners(XtextDocument.this.resource);
        }

        public <T> T modify(IUnitOfWork<T, XtextResource> work) {
            try {
                XtextDocument.this.validationJob.cancel();
                Object object = super.modify(work);
                return (T)object;
            }
            catch (RuntimeException e) {
                try {
                    XtextResource state = this.getState();
                    if (state != null) {
                        state.reparse(XtextDocument.this.get());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                XtextDocument.this.checkAndUpdateAnnotations();
            }
        }

        @Override
        public <T> T process(IUnitOfWork<T, XtextResource> transaction) {
            if (transaction != null) {
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("process - " + Thread.currentThread().getName()));
                    }
                    T t = this.modify(transaction);
                    return t;
                }
                finally {
                    this.readLock.lock();
                    this.writeLock.unlock();
                }
            }
            return null;
        }
    }
}

