/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.StatefulResourceDescription;
import org.eclipse.xtext.ui.editor.findrefs.Messages;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchResult;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchResultEvents;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchViewTreeNode;

public class ReferenceSearchResultContentProvider
implements ITreeContentProvider,
ISearchResultListener,
IResourceDescription.Event.Listener {
    private IResourceDescriptions resourceDescriptions;
    private List<ReferenceSearchViewTreeNode> rootNodes;
    private TreeViewer viewer;
    private List<SearchResultEvent> batchedSearchResultEvents = Lists.newArrayList();
    private volatile boolean isUIUpdateScheduled;

    @Inject
    public ReferenceSearchResultContentProvider(IResourceDescriptions resourceDescriptions) {
        this.resourceDescriptions = resourceDescriptions;
        if (resourceDescriptions instanceof IResourceDescription.Event.Source) {
            ((IResourceDescription.Event.Source)resourceDescriptions).addListener((IResourceDescription.Event.Listener)this);
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ReferenceSearchViewTreeNode) {
            return Iterables.newArray(((ReferenceSearchViewTreeNode)parentElement).getChildren(), ReferenceSearchViewTreeNode.class);
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof ReferenceSearchViewTreeNode) {
            return ((ReferenceSearchViewTreeNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ReferenceSearchViewTreeNode) {
            return !((ReferenceSearchViewTreeNode)element).getChildren().isEmpty();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (this.rootNodes == null || this.rootNodes.isEmpty()) {
            return new Object[0];
        }
        return Iterables.newArray(this.rootNodes, ReferenceSearchViewTreeNode.class);
    }

    public void dispose() {
        this.rootNodes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Viewer viewer2 = viewer;
        synchronized (viewer2) {
            if (this.rootNodes != null) {
                this.rootNodes.clear();
            }
            if (oldInput instanceof ReferenceSearchResult) {
                ((ReferenceSearchResult)oldInput).removeListener(this);
            }
            if (newInput instanceof ReferenceSearchResult && viewer instanceof TreeViewer) {
                ((ReferenceSearchResult)newInput).addListener(this);
                this.viewer = (TreeViewer)viewer;
                for (IReferenceDescription referenceDescription : ((ReferenceSearchResult)newInput).getMatchingReferences()) {
                    this.addReference(referenceDescription, false);
                }
            }
        }
    }

    private void addReference(IReferenceDescription referenceDescription, boolean isUpdateViewer) {
        URI containerEObjectURI = referenceDescription.getContainerEObjectURI();
        URI eObjectURI = containerEObjectURI == null ? referenceDescription.getSourceEObjectUri() : containerEObjectURI;
        IResourceDescription resourceDescription = this.resourceDescriptions.getResourceDescription(eObjectURI.trimFragment());
        if (resourceDescription != null) {
            ReferenceSearchViewTreeNode resourceNode = this.resourceNode(resourceDescription, isUpdateViewer);
            for (IEObjectDescription eObjectDescription : resourceDescription.getExportedObjects()) {
                if (!eObjectDescription.getEObjectURI().equals((Object)eObjectURI)) continue;
                ReferenceSearchViewTreeNode referenceNode = new ReferenceSearchViewTreeNode(resourceNode, referenceDescription, eObjectDescription);
                if (!isUpdateViewer) continue;
                this.viewer.add((Object)resourceNode, (Object)referenceNode);
                this.viewer.expandToLevel((Object)resourceNode, 1);
            }
        }
    }

    private ReferenceSearchViewTreeNode resourceNode(IResourceDescription resourceDescription, boolean isUpdateViewer) {
        ReferenceSearchViewTreeNode node2;
        if (this.rootNodes == null) {
            this.rootNodes = Lists.newArrayList();
        }
        for (ReferenceSearchViewTreeNode node2 : this.rootNodes) {
            Object nodeDescription = node2.getDescription();
            if (!(nodeDescription instanceof IResourceDescription) || !((IResourceDescription)nodeDescription).getURI().equals((Object)resourceDescription.getURI())) continue;
            return node2;
        }
        node2 = new ReferenceSearchViewTreeNode(null, resourceDescription, resourceDescription);
        this.rootNodes.add(node2);
        if (isUpdateViewer) {
            this.viewer.add(this.viewer.getInput(), (Object)node2);
        }
        return node2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchResultChanged(SearchResultEvent e) {
        List<SearchResultEvent> list = this.batchedSearchResultEvents;
        synchronized (list) {
            this.batchedSearchResultEvents.add(e);
        }
        if (!this.isUIUpdateScheduled) {
            new UIUpdater().schedule();
        }
    }

    public void descriptionsChanged(final IResourceDescription.Event event) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (ReferenceSearchResultContentProvider.this.rootNodes != null) {
                    block0: for (IResourceDescription.Delta delta : event.getDeltas()) {
                        if (delta.getNew() instanceof StatefulResourceDescription) continue;
                        Iterator i = ReferenceSearchResultContentProvider.this.rootNodes.iterator();
                        while (i.hasNext()) {
                            ReferenceSearchViewTreeNode rootNode = (ReferenceSearchViewTreeNode)i.next();
                            if (!((IResourceDescription)rootNode.getDescription()).getURI().equals((Object)delta.getUri())) continue;
                            if (delta.getNew() == null) {
                                i.remove();
                                ReferenceSearchResultContentProvider.this.viewer.remove((Object)rootNode);
                                continue block0;
                            }
                            Iterable newReferenceDescriptions = delta.getNew().getReferenceDescriptions();
                            ArrayList removedReferenceNodes = Lists.newArrayList();
                            for (ReferenceSearchViewTreeNode referenceNode : rootNode.getChildren()) {
                                final URI referenceSourceURI = ((IReferenceDescription)referenceNode.getDescription()).getSourceEObjectUri();
                                if (!Iterables.isEmpty((Iterable)Iterables.filter((Iterable)newReferenceDescriptions, (Predicate)new Predicate<IReferenceDescription>(){

                                    public boolean apply(IReferenceDescription input) {
                                        return input.getSourceEObjectUri().equals((Object)referenceSourceURI);
                                    }
                                }))) continue;
                                removedReferenceNodes.add(referenceNode);
                            }
                            for (ReferenceSearchViewTreeNode removedReferenceNode : removedReferenceNodes) {
                                rootNode.removeChild(removedReferenceNode);
                            }
                            if (rootNode.getChildren().isEmpty()) {
                                i.remove();
                                ReferenceSearchResultContentProvider.this.viewer.remove((Object)rootNode);
                                continue block0;
                            }
                            ReferenceSearchResultContentProvider.this.viewer.remove((Object)rootNode, Iterables.newArray((Iterable)removedReferenceNodes, ReferenceSearchViewTreeNode.class));
                        }
                    }
                }
            }
        });
    }

    private class UIUpdater
    extends UIJob {
        public UIUpdater() {
            super(Messages.ReferenceSearchResultContentProvider_label);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            ArrayList events;
            ReferenceSearchResultContentProvider.this.isUIUpdateScheduled = false;
            List list = ReferenceSearchResultContentProvider.this.batchedSearchResultEvents;
            synchronized (list) {
                events = Lists.newArrayList((Iterable)ReferenceSearchResultContentProvider.this.batchedSearchResultEvents);
                ReferenceSearchResultContentProvider.this.batchedSearchResultEvents.clear();
            }
            for (SearchResultEvent event : events) {
                if (event instanceof ReferenceSearchResultEvents.Added) {
                    ReferenceSearchResultContentProvider.this.addReference(((ReferenceSearchResultEvents.Added)event).getReferenceDescription(), true);
                    continue;
                }
                if (!(event instanceof ReferenceSearchResultEvents.Reset) || ReferenceSearchResultContentProvider.this.rootNodes == null || ReferenceSearchResultContentProvider.this.rootNodes.isEmpty()) continue;
                TreeViewer treeViewer = ReferenceSearchResultContentProvider.this.viewer;
                synchronized (treeViewer) {
                    ReferenceSearchResultContentProvider.this.viewer.remove(ReferenceSearchResultContentProvider.this.viewer.getInput(), Iterables.newArray((Iterable)ReferenceSearchResultContentProvider.this.rootNodes, ReferenceSearchViewTreeNode.class));
                    ReferenceSearchResultContentProvider.this.rootNodes = null;
                }
            }
            return Status.OK_STATUS;
        }
    }
}

