/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.runtime.util;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.Messages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtoTransformationValidator {
    public static final int QVTO_ROOT_DIAGNOSTIC = 1;
    public static final int QVTO_CHILD_DIAGNOSTIC = 2;

    private QvtoTransformationValidator() {
    }

    public static Diagnostic validateQvtoScript(URI uriTransf, IProgressMonitor monitor, Map<String, String> options) {
        try {
            QvtModule qvtModule = TransformationUtil.getQvtModule(uriTransf);
            QvtCompilerOptions qvtOptions = new QvtCompilerOptions();
            qvtOptions.setModuleWithErrorAllowed(true);
            qvtModule.setQvtCompilerOptions(qvtOptions);
            CompiledUnit compiledUnit = qvtModule.getUnit();
            return QvtoTransformationValidator.fillCompilationDiagnostic(compiledUnit, uriTransf);
        }
        catch (MdaException e) {
            return new BasicDiagnostic(4, uriTransf.toString(), 1, e.getMessage(), new Object[0]);
        }
    }

    private static Diagnostic fillCompilationDiagnostic(CompiledUnit compiledUnit, URI uri) {
        BasicDiagnostic result = new BasicDiagnostic(1, uri.toString(), 1, NLS.bind((String)Messages.moduleDiagnosticChain, (Object)uri.toString()), new Object[0]);
        for (QvtMessage msg : compiledUnit.getProblems()) {
            result.add(QvtoTransformationValidator.createDiagnostic(msg, uri));
        }
        return result;
    }

    private static Diagnostic createDiagnostic(QvtMessage msg, URI uri) {
        return new BasicDiagnostic(msg.getSeverity() == 4 ? 4 : 2, uri.toString(), 2, msg.getMessage(), new Object[0]);
    }
}

