/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lpg.runtime.IToken;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxRegistry;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContextImpl;
import org.eclipse.m2m.internal.qvt.oml.common.project.DeployedTransformation;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.CompletionProposalUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionProposal;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors.AbstractCollector;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportModuleCollector
extends AbstractCollector {
    @Override
    protected boolean isApplicableInternal(QvtCompletionData data) {
        IToken leftToken = data.getLeftToken();
        return leftToken.getKind() == 141;
    }

    @Override
    public void addPropoposals(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        this.addLocalModulesProposals(proposals, data);
        this.addDeployedModulesProposals(proposals, data);
        ResolutionContextImpl loadContext = new ResolutionContextImpl(data.getCFile().getURI());
        for (BlackboxUnitDescriptor unitDescriptor : BlackboxRegistry.INSTANCE.getCompilationUnitDescriptors((ResolutionContext)loadContext)) {
            String proposalString = unitDescriptor.getQualifiedName();
            QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(proposalString, ImportModuleCollector.isJdtUnitUri(unitDescriptor.getURI()) ? "cat-package" : "cat-mapping", data);
            CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
        }
    }

    private static boolean isJdtUnitUri(URI uri) {
        return "jdt".equals(uri.query());
    }

    private void addLocalModulesProposals(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        UnitProxy unit = data.getCFile();
        URI compiledFileURI = unit.getURI();
        IResource compiledFile = URIUtils.getResource((URI)compiledFileURI);
        if (compiledFile.getType() != 1) {
            return;
        }
        this.addFolderProposals(unit, proposals, data, new String[0]);
    }

    private void addFolderProposals(UnitProxy excludedFile, Collection<ICompletionProposal> proposals, QvtCompletionData data, String[] path) {
        final ArrayList members = new ArrayList();
        UnitResolver resolver = excludedFile.getResolver();
        if (resolver instanceof UnitProvider) {
            UnitProvider unitProvider = (UnitProvider)resolver;
            UnitProvider.UnitVisitor visitor = new UnitProvider.UnitVisitor(){

                public boolean visitUnit(UnitProxy unit) {
                    members.add(unit);
                    return true;
                }
            };
            unitProvider.accept(visitor, null, 2, false);
            Collections.sort(members, new Comparator<UnitProxy>(){

                @Override
                public int compare(UnitProxy unit1, UnitProxy unit2) {
                    return unit1.getQualifiedName().compareTo(unit2.getQualifiedName());
                }
            });
        }
        for (UnitProxy memberUnit : members) {
            if (memberUnit.equals((Object)excludedFile)) continue;
            String qualifiedName = memberUnit.getQualifiedName();
            QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(qualifiedName, "cat-class", data);
            CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
        }
    }

    private void addDeployedModulesProposals(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        List transformations = QvtTransformationRegistry.getInstance().getTransformations();
        for (DeployedTransformation transformation : transformations) {
            String proposalString = transformation.getId();
            QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(proposalString, "cat-class", data);
            CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
        }
    }
}

