/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtbase.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.resource.ASResourceImpl;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.values.Value;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.ocl.xtext.essentialocl.utilities.EssentialOCLCSResource;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;

public class PivotTestCase
extends TestCase {
    public static final @NonNull String PLUGIN_ID = "org.eclipse.qvtd.xtext.qvtbase.tests";
    public static final @NonNull TracingOption TEST_START = new TracingOption("org.eclipse.qvtd.xtext.qvtbase.tests", "test/start");
    protected static boolean noDebug = false;
    static long startTime;

    /*
     * Unable to fully structure code
     */
    public static @NonNull List<Diagnostic> assertDiagnostics(@NonNull String prefix, @NonNull List<Diagnostic> diagnostics, String ... messages) {
        expected = new HashMap<String, Integer>();
        var7_4 = messages;
        var6_5 = messages.length;
        var5_7 = 0;
        while (var5_7 < var6_5) {
            message = var7_4[var5_7];
            count = (Integer)expected.get(message);
            count = count == null ? 1 : count + 1;
            expected.put(message, count);
            ++var5_7;
        }
        s1 = null;
        for (Diagnostic diagnostic : diagnostics) {
            actual = diagnostic.getMessage();
            expectedCount = (Integer)expected.get(actual);
            if (expectedCount == null || expectedCount <= 0) {
                if (s1 == null) {
                    s1 = new StringBuilder();
                    s1.append("\nUnexpected errors");
                }
                s1.append("\n");
                s1.append(actual);
                continue;
            }
            expected.put(actual, expectedCount - 1);
        }
        s2 = null;
        for (String key : expected.keySet()) {
            count = (Integer)expected.get(key);
            if (PivotTestCase.$assertionsDisabled || count != null) ** GOTO lbl43
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                if (s2 == null) {
                    s2 = new StringBuilder();
                    s2.append("\nMissing errors");
                }
                s2.append("\n");
                s2.append(key);
lbl43:
                // 2 sources

                v0 = count;
                count = v0 - 1;
                ** while (v0.intValue() > 0)
            }
lbl46:
            // 1 sources

        }
        if (s1 == null) {
            if (s2 != null) {
                PivotTestCase.fail((String)s2.toString());
            }
        } else if (s2 == null) {
            PivotTestCase.fail((String)s1.toString());
        } else {
            PivotTestCase.fail((String)(String.valueOf(s1.toString()) + s2.toString()));
        }
        return diagnostics;
    }

    public static void assertNoDiagnosticErrors(String message, XtextResource xtextResource) {
        List diagnostics = xtextResource.validateConcreteSyntax();
        if (diagnostics.size() > 0) {
            StringBuilder s = new StringBuilder();
            s.append(message);
            for (Diagnostic diagnostic : diagnostics) {
                s.append("\n");
                s.append(diagnostic.toString());
            }
            PivotTestCase.fail((String)s.toString());
        }
    }

    public static void assertNoResourceErrors(@NonNull String prefix, @NonNull Resource resource) {
        String message = PivotUtil.formatResourceDiagnostics((List)resource.getErrors(), (String)prefix, (String)"\n\t");
        if (message != null) {
            PivotTestCase.fail((String)message);
        }
    }

    public static void assertNoUnresolvedProxies(String message, Resource resource) {
        Map unresolvedProxies = EcoreUtil.UnresolvedProxyCrossReferencer.find((Resource)resource);
        if (unresolvedProxies.size() > 0) {
            StringBuilder s = new StringBuilder();
            s.append(unresolvedProxies.size());
            s.append(" unresolved proxies in '" + resource.getURI() + "' ");
            s.append(message);
            for (Map.Entry unresolvedProxy : unresolvedProxies.entrySet()) {
                s.append("\n");
                BasicEObjectImpl key = (BasicEObjectImpl)unresolvedProxy.getKey();
                s.append(key.eProxyURI());
                for (EStructuralFeature.Setting setting : (Collection)unresolvedProxy.getValue()) {
                    s.append("\n\t");
                    EObject eObject = setting.getEObject();
                    s.append(eObject.toString());
                }
            }
            PivotTestCase.fail((String)s.toString());
        }
    }

    public static void assertNoValidationErrors(String string, Resource resource) {
        for (EObject eObject : resource.getContents()) {
            PivotTestCase.assertNoValidationErrors(string, eObject);
        }
    }

    public static void assertNoValidationErrors(String string, EObject eObject) {
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject, validationContext);
        List children = diagnostic.getChildren();
        if (children.size() <= 0) {
            return;
        }
        StringBuilder s = new StringBuilder();
        s.append(String.valueOf(children.size()) + " validation errors: " + string);
        for (Diagnostic child : children) {
            Object data;
            s.append("\n\t");
            if (child.getData().size() > 0 && (data = child.getData().get(0)) instanceof Element) {
                Element eScope = (Element)data;
                while (eScope instanceof Element) {
                    ModelElementCS csElement = ElementUtil.getCsElement((Element)eScope);
                    if (csElement != null) {
                        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
                        if (node != null) {
                            Resource eResource = csElement.eResource();
                            if (eResource != null) {
                                s.append(String.valueOf(eResource.getURI().lastSegment()) + ":");
                            }
                            int startLine = node.getStartLine();
                            s.append(String.valueOf(startLine) + ":");
                        }
                        s.append(String.valueOf(((Element)data).eClass().getName()) + ": ");
                        break;
                    }
                    eScope = eScope.eContainer();
                }
            }
            s.append(child.getMessage());
        }
        PivotTestCase.fail((String)s.toString());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static void assertResourceErrors(String prefix, Resource resource, String ... messages) {
        Integer count;
        HashMap<String, Integer> expected = new HashMap<String, Integer>();
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            count = (Integer)expected.get(message);
            count = count == null ? 1 : count + 1;
            expected.put(message, count);
            ++n2;
        }
        StringBuilder s1 = null;
        for (Resource.Diagnostic error : resource.getErrors()) {
            String actual = error.getMessage();
            Integer expectedCount = (Integer)expected.get(actual);
            if (expectedCount == null || expectedCount <= 0) {
                if (s1 == null) {
                    s1 = new StringBuilder();
                    s1.append("\nUnexpected errors");
                }
                s1.append("\n");
                s1.append(actual);
                continue;
            }
            expected.put(actual, expectedCount - 1);
        }
        StringBuilder s2 = null;
        for (String key : expected.keySet()) {
            Integer n3;
            count = (Integer)ClassUtil.nonNullState((Object)((Integer)expected.get(key)));
            if (true) {
                n3 = count;
                count = n3 - 1;
                if (n3 <= 0) continue;
            }
            do {
                if (s2 == null) {
                    s2 = new StringBuilder();
                    s2.append("\nMissing errors");
                }
                s2.append("\n");
                s2.append(key);
                n3 = count;
                count = n3 - 1;
            } while (n3 > 0);
        }
        if (s1 == null) {
            if (s2 == null) {
                return;
            }
            PivotTestCase.fail((String)s2.toString());
            return;
        }
        if (s2 == null) {
            PivotTestCase.fail((String)s1.toString());
            return;
        }
        PivotTestCase.fail((String)(String.valueOf(s1.toString()) + s2.toString()));
    }

    public static @NonNull List<Diagnostic> assertValidationDiagnostics(@NonNull String prefix, @NonNull Resource resource, String ... messages) {
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        return PivotTestCase.assertValidationDiagnostics(prefix, resource, validationContext, messages);
    }

    public static @NonNull List<Diagnostic> assertValidationDiagnostics(@NonNull String prefix, @NonNull Resource resource, Map<Object, Object> validationContext, String ... messages) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (EObject eObject : resource.getContents()) {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject, validationContext);
            diagnostics.addAll(diagnostic.getChildren());
        }
        return messages != null ? PivotTestCase.assertDiagnostics(prefix, diagnostics, messages) : Collections.emptyList();
    }

    protected static Value failOn(String expression, Throwable e) {
        if (e instanceof EvaluationException) {
            Throwable eCause = e.getCause();
            if (eCause != null) {
                return PivotTestCase.failOn(expression, eCause);
            }
            throw new Error("Failed to evaluate \"" + expression + "\"", e);
        }
        if (e instanceof EvaluationException) {
            throw new Error("Failed to parse or evaluate \"" + expression + "\"", e);
        }
        throw new Error("Failure for \"" + expression + "\"", e);
    }

    public static Resource getEcoreFromCS(@NonNull OCL ocl, String testDocument, URI ecoreURI) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(testDocument.getBytes());
        URI xtextURI = URI.createURI((String)"test.oclinecore");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EssentialOCLCSResource xtextResource = (EssentialOCLCSResource)resourceSet.createResource(xtextURI, null);
        assert (xtextResource != null);
        ocl.getEnvironmentFactory().adapt((Notifier)xtextResource);
        xtextResource.load((InputStream)inputStream, null);
        PivotTestCase.assertNoResourceErrors("Loading Xtext", (Resource)xtextResource);
        Resource pivotResource = PivotTestCase.savePivotFromCS(ocl, (BaseCSResource)xtextResource, null);
        Resource ecoreResource = PivotTestCase.savePivotAsEcore(ocl, pivotResource, ecoreURI, true);
        return ecoreResource;
    }

    public static Resource savePivotAsEcore(@NonNull OCL ocl, @NonNull Resource pivotResource, URI ecoreURI, boolean validateSaved) throws IOException {
        return PivotTestCase.savePivotAsEcore(ocl, pivotResource, ecoreURI, null, validateSaved);
    }

    public static @NonNull Resource savePivotAsEcore(@NonNull OCL ocl, @NonNull Resource pivotResource, URI ecoreURI, Map<String, Object> options, boolean validateSaved) throws IOException {
        URI uri = ecoreURI != null ? ecoreURI : URI.createURI((String)"test.ecore");
        XMLResource ecoreResource = AS2Ecore.createResource((EnvironmentFactoryInternal)((EnvironmentFactoryInternal)ocl.getEnvironmentFactory()), (Resource)pivotResource, (URI)uri, null);
        PivotTestCase.assertNoResourceErrors("Ecore2Pivot failed", (Resource)ecoreResource);
        if (ecoreURI != null) {
            ecoreResource.save(DefaultCompilerOptions.defaultSavingOptions);
        }
        if (validateSaved) {
            PivotTestCase.assertNoValidationErrors("Ecore2Pivot invalid", (Resource)ecoreResource);
        }
        return ecoreResource;
    }

    public static @NonNull Resource savePivotFromCS(@NonNull OCL ocl, @NonNull BaseCSResource xtextResource, URI pivotURI) throws IOException {
        ASResource pivotResource = xtextResource.getASResource();
        PivotTestCase.assertNoUnresolvedProxies("Unresolved proxies", (Resource)pivotResource);
        if (pivotURI != null) {
            pivotResource.setURI(pivotURI);
            pivotResource.save(DefaultCompilerOptions.defaultSavingOptions);
        }
        return pivotResource;
    }

    public static void unloadResourceSet(ResourceSet resourceSet) {
        for (Resource resource : resourceSet.getResources()) {
            resource.unload();
        }
        resourceSet.eAdapters().clear();
    }

    public static void debugPrintln(String string) {
        if (!noDebug) {
            System.out.println(string);
        }
    }

    public @NonNull String getName() {
        return TestUtil.getName((String)this.getTestName());
    }

    public @NonNull String getTestName() {
        return (String)ClassUtil.nonNullState((Object)super.getName());
    }

    protected void setUp() throws Exception {
        super.setUp();
        ASResourceImpl.CHECK_IMMUTABILITY.setState(true);
        TEST_START.println("-----Starting " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.getName() + "-----");
        startTime = System.nanoTime();
    }

    protected void tearDown() throws Exception {
        long time = System.nanoTime() - startTime;
        super.tearDown();
    }
}

