/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.utilities;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;

public class CompilerUtil {
    public static final @NonNull Map<Object, Object> defaultSavingOptions = new HashMap<Object, Object>();

    static {
        defaultSavingOptions.put("ENCODING", "UTF-8");
        defaultSavingOptions.put("LINE_DELIMITER", "\n");
        defaultSavingOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        defaultSavingOptions.put("SCHEMA_LOCATION_IMPLEMENTATION", Boolean.TRUE);
        defaultSavingOptions.put("LINE_WIDTH", 132);
    }

    public static void assertNoResourceErrors(@NonNull String prefix, @NonNull Resource resource) {
        String message = PivotUtil.formatResourceDiagnostics((List)resource.getErrors(), (String)prefix, (String)"\n\t");
        if (message != null) assert (false) : message;
    }

    public static void assertNoResourceSetErrors(@NonNull String prefix, @NonNull Resource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        assert (resourceSet != null) : String.valueOf(prefix) + " no ResourceSet for " + resource;
        for (Resource aResource : resourceSet.getResources()) {
            if (aResource == null) continue;
            CompilerUtil.assertNoResourceErrors(prefix, aResource);
        }
    }

    public static void assertNoUnresolvedProxies(String message, Resource resource) {
        Map unresolvedProxies = EcoreUtil.UnresolvedProxyCrossReferencer.find((Resource)resource);
        if (unresolvedProxies.size() > 0) {
            StringBuilder s = new StringBuilder();
            s.append(unresolvedProxies.size());
            s.append(" unresolved proxies in '" + resource.getURI() + "' ");
            s.append(message);
            for (Map.Entry unresolvedProxy : unresolvedProxies.entrySet()) {
                s.append("\n");
                BasicEObjectImpl key = (BasicEObjectImpl)unresolvedProxy.getKey();
                s.append(key.eProxyURI());
                for (EStructuralFeature.Setting setting : (Collection)unresolvedProxy.getValue()) {
                    s.append("\n\t");
                    EObject eObject = setting.getEObject();
                    s.append(eObject.toString());
                }
            }
            assert (false) : s.toString();
        }
    }

    public static void assertNoValidationErrors(@NonNull String prefix, @NonNull Resource resource) {
        for (EObject eObject : resource.getContents()) {
            CompilerUtil.assertNoValidationErrors(prefix, eObject);
        }
    }

    public static void assertNoValidationErrors(@NonNull String string, EObject eObject) {
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject, validationContext);
        List children = diagnostic.getChildren();
        if (children.size() <= 0) {
            return;
        }
        StringBuilder s = new StringBuilder();
        s.append(String.valueOf(children.size()) + " validation errors");
        for (Diagnostic child : children) {
            Object data;
            s.append("\n\t");
            if (child.getData().size() > 0 && (data = child.getData().get(0)) instanceof Element) {
                Element eScope = (Element)data;
                while (eScope instanceof Element) {
                    eScope = eScope.eContainer();
                }
            }
            s.append(child.getMessage());
        }
        assert (false) : s.toString();
    }

    public static void indent(@NonNull StringBuilder s, int depth) {
        int i = 0;
        while (i < depth) {
            s.append("    ");
            ++i;
        }
    }

    public static void normalizeNameables(@NonNull List<@NonNull ? extends Nameable> nameables) {
        if (nameables instanceof EList) {
            ECollections.sort((EList)((EList)nameables), (Comparator)NameUtil.NAMEABLE_COMPARATOR);
        } else {
            Collections.sort(nameables, NameUtil.NAMEABLE_COMPARATOR);
        }
    }

    public static <T> void removeAll(@NonNull Collection<T> removeFrom, @NonNull Iterable<T> elementsToTemove) {
        for (T element : elementsToTemove) {
            removeFrom.remove(element);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void throwExceptionWithProblems(@NonNull CodeGenerator codeGenerator, @NonNull Exception e) throws Exception {
        @NonNull List problems = codeGenerator.getProblems();
        if (problems != null) {
            StringBuilder s = new StringBuilder();
            for (Exception ex : problems) {
                s.append(String.valueOf(ex.toString()) + "\n");
            }
            s.append(e.toString());
            throw new CompilerChainException(e, s.toString(), new Object[0]);
        }
        throw e;
    }
}

