/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.lpg.AbstractFormattingHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSTFormattingHelper
extends AbstractFormattingHelper
implements EValidator.SubstitutionLabelProvider {
    public static final CSTFormattingHelper INSTANCE = new CSTFormattingHelper();

    public String formatName(Object object) {
        if (object == null) {
            return this.formatString(null);
        }
        if (object instanceof ENamedElement) {
            return this.formatString(((ENamedElement)object).getName());
        }
        if (object instanceof EObject) {
            return this.formatName(((EObject)object).eClass());
        }
        return object.getClass().getName();
    }

    public String formatQualifiedName(Object object) {
        if (object instanceof EObject) {
            String resourceName;
            EObject eObject = (EObject)object;
            EObject container = eObject.eContainer();
            if (container != null) {
                return String.valueOf(this.formatQualifiedName(container)) + this.getSeparator() + this.formatName(object);
            }
            Resource resource = eObject.eResource();
            if (resource != null && (resourceName = this.formatResource(resource)) != null) {
                return String.valueOf(resourceName) + this.getSeparator() + this.formatName(object);
            }
        }
        return this.formatName(object);
    }

    public String formatResource(Resource resource) {
        if (resource == null) {
            return "<null-resource>";
        }
        URI uri = resource.getURI();
        if (uri == null) {
            return "<null-uri>";
        }
        String s = uri.toString();
        int i = s.lastIndexOf("/");
        return i >= 0 ? s.substring(i + 1) : s;
    }

    public String getFeatureLabel(EStructuralFeature structuralFeature) {
        return this.formatName(structuralFeature);
    }

    public String getObjectLabel(EObject object) {
        return this.formatQualifiedName(object);
    }

    public String getValueLabel(EDataType dataType, Object value) {
        return EcoreUtil.convertToString((EDataType)dataType, (Object)value);
    }

    public <T> List<T> sort(Collection<T> objects) {
        ArrayList<SortKey<T>> indexes = new ArrayList<SortKey<T>>(objects.size());
        for (T object : objects) {
            indexes.add(new SortKey<T>(object));
        }
        Collections.sort(indexes);
        ArrayList list = new ArrayList(objects.size());
        for (SortKey sortKey : indexes) {
            list.add(sortKey.getObject());
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SortKey<T>
    implements Comparable<SortKey<T>> {
        protected final String key;
        protected final T object;

        public SortKey(T object) {
            this.key = CSTFormattingHelper.this.formatQualifiedName(object);
            this.object = object;
        }

        @Override
        public int compareTo(SortKey<T> o) {
            return this.key.compareTo(o.key);
        }

        public T getObject() {
            return this.object;
        }
    }
}

