/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLRootNamespaceParser
extends DefaultHandler {
    public static final String XMLNS_PREFIX_COLON = "xmlns:";
    public static final int XMLNS_PREFIX_LENGTH = "xmlns".length();
    protected Map<String, String> xmlnsMap = null;
    private String xmiPrefix = null;

    public static String parse(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        SAXParser parser = parserFactory.newSAXParser();
        XMLRootNamespaceParser handler = new XMLRootNamespaceParser();
        try {
            parser.parse(inputStream, (DefaultHandler)handler);
            return null;
        }
        catch (FoundRootURIException e) {
            return e.getRootURI();
        }
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        int colonAt;
        String prefix;
        boolean atRoot;
        boolean bl = atRoot = this.xmlnsMap == null;
        if (atRoot) {
            this.xmlnsMap = new HashMap<String, String>();
            int iMax = attributes.getLength();
            int i = 0;
            while (i < iMax) {
                String qName = attributes.getQName(i);
                String prefix2 = null;
                String value = attributes.getValue(i);
                if (qName.equals("xmlns")) {
                    prefix2 = "";
                } else if (qName.startsWith(XMLNS_PREFIX_COLON)) {
                    prefix2 = qName.substring(XMLNS_PREFIX_COLON.length());
                }
                if (prefix2 != null) {
                    this.xmlnsMap.put(prefix2, value);
                    if ("http://www.omg.org/XMI".equals(value)) {
                        this.xmiPrefix = prefix2;
                    }
                }
                ++i;
            }
        }
        String string = prefix = (colonAt = name.indexOf(58)) >= 0 ? name.substring(0, colonAt) : "";
        if (prefix.equals(this.xmiPrefix)) {
            return;
        }
        throw new FoundRootURIException(this.xmlnsMap.get(prefix));
    }

    public static class FoundRootURIException
    extends SAXException {
        private String rootURI = null;

        public FoundRootURIException(String rootURI) {
            this.rootURI = rootURI;
        }

        public String getRootURI() {
            return this.rootURI;
        }
    }
}

