/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.environment;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.qvt.declarative.modelregistry.model.Accessor;
import org.eclipse.qvt.declarative.modelregistry.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessorKindRegistry {
    private final Map<String, Class<? extends Accessor>> kindToClassMap = new HashMap<String, Class<? extends Accessor>>();
    private final AccessorClassToAccessorMap classToPrototypeMap = new AccessorClassToAccessorMap();

    public Accessor createAccessor(String accessorKind, String accessorName) {
        Class<? extends Accessor> accessorClass = this.kindToClassMap.get(accessorKind != null ? accessorKind : "Model Name");
        if (accessorClass == null) {
            return null;
        }
        return this.createAccessor(accessorClass, accessorName);
    }

    public <A extends Accessor> A createAccessor(Class<A> accessorClass, String accessorName) {
        A accessorPrototype = this.classToPrototypeMap.get(accessorClass);
        try {
            return (A)((Accessor)ClassUtils.asClassChecked(accessorPrototype.newInstance(accessorName), accessorClass));
        }
        catch (Exception e) {
            ModelRegistryEnvironment.logError("Unable to construct '" + accessorPrototype.getClass().getName() + "' instance", e);
            return null;
        }
    }

    public Class<? extends Accessor> getAccessorClass(String accessorKind) {
        return this.kindToClassMap.get(accessorKind);
    }

    public Collection<String> getKinds() {
        return this.kindToClassMap.keySet();
    }

    public <A extends Accessor> void addAccessor(A accessorPrototype) {
        Class<A> accessorClass = ClassUtils.getClass(accessorPrototype);
        this.kindToClassMap.put(accessorPrototype.getKind(), accessorClass);
        this.classToPrototypeMap.put(accessorClass, accessorPrototype);
    }

    public <A extends Accessor> String toAccessorString(Class<A> accessorClass) {
        A prototype = this.classToPrototypeMap.get(accessorClass);
        return String.valueOf(prototype.getKind()) + ":" + prototype.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AccessorClassToAccessorMap {
        private HashMap<Class<? extends Accessor>, Accessor> map = new HashMap();

        private AccessorClassToAccessorMap() {
        }

        public <A extends Accessor> A get(Class<A> key) {
            return (A)this.map.get(key);
        }

        public <A extends Accessor> A put(Class<A> key, A value) {
            return (A)this.map.put(key, value);
        }
    }
}

