/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.paged;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryContentProvider;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.qvt.declarative.ecore.adapters.ResourceSetMappingMetaDataRegistryAdapter;
import org.eclipse.qvt.declarative.ecore.mappings.IMappingMetaData;
import org.eclipse.qvt.declarative.ecore.mappings.IMappingMetaDataRegistry;
import org.eclipse.qvt.declarative.ecore.mappings.MappingConfigurationException;
import org.eclipse.qvt.declarative.ecore.utils.TracingOption;
import org.eclipse.qvt.declarative.editor.ui.ICreationFactory;
import org.eclipse.qvt.declarative.editor.ui.IMasterPageManager;
import org.eclipse.qvt.declarative.editor.ui.IPageManager;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.actions.HideResourceAdaptersAction;
import org.eclipse.qvt.declarative.editor.ui.actions.PagedActionBarContributor;
import org.eclipse.qvt.declarative.editor.ui.commands.MasterPageSaveCommand;
import org.eclipse.qvt.declarative.editor.ui.commands.PageChangeCommand;
import org.eclipse.qvt.declarative.editor.ui.commands.ResourceSetSaveCommand;
import org.eclipse.qvt.declarative.editor.ui.operations.OperationHistoryListener;
import org.eclipse.qvt.declarative.editor.ui.paged.BaseEditor;
import org.eclipse.qvt.declarative.editor.ui.paged.PagedContentOutlinePage;
import org.eclipse.qvt.declarative.editor.ui.paged.PagedEditingDomainFactory;
import org.eclipse.qvt.declarative.editor.ui.paged.PagedOperationHistoryListener;
import org.eclipse.qvt.declarative.editor.ui.paged.PagedPropertySheetPage;
import org.eclipse.qvt.declarative.editor.ui.pages.IPageFactoryRegistry;
import org.eclipse.qvt.declarative.editor.ui.pages.PageDefinitions;
import org.eclipse.qvt.declarative.editor.ui.pages.PageDefinitionsReader;
import org.eclipse.qvt.declarative.editor.ui.text.TextResource;
import org.eclipse.qvt.declarative.editor.ui.tree.TreePageManager;
import org.eclipse.qvt.declarative.modelregistry.eclipse.EclipseProjectHandle;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedEditor
extends BaseEditor
implements IEditingDomainProvider,
IResourceChangeListener,
IGotoMarker,
ISelectionProvider,
ISelectionChangedListener,
ITabbedPropertySheetPageContributor {
    protected final ICreationFactory creationFactory;
    protected TextResource textResource;
    protected XMLResource masterResource;
    protected final Map<IEditorPart, IPageManager> pageManagers = new HashMap<IEditorPart, IPageManager>();
    protected IMasterPageManager masterPageManager = null;
    protected IPageManager validPageManager = null;
    protected IPageManager activePageManager = null;
    protected TransactionalEditingDomainImpl editingDomain;
    protected PagedContentOutlinePage contentOutlinePage = null;
    protected IPropertySheetPage propertySheetPage = null;
    protected IPartListener partListener = new PartListener();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected ISelectionProvider currentSelectionProvider;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected OperationHistoryListener operationHistoryListener;
    private long resourceSetTimeStamp = 0L;
    private PageDefinitions pageFactoryRegistries = null;
    protected IShowInTargetList showInTargetList = null;
    public static TracingOption traceEditorShowDirty = new TracingOption("editor/show/dirty");
    public static TracingOption traceOperationHistory = new TracingOption("operation/history");

    protected PagedEditor(ICreationFactory creationFactory) {
        this.creationFactory = creationFactory;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.initializeEditingDomain();
    }

    public void addPage(int index, IEditorPart editor, IEditorInput input) throws PartInitException {
        super.addPage(index, editor, input);
        CTabFolder tabFolder = (CTabFolder)this.getContainer();
        CTabItem[] items = tabFolder.getItems();
        CTabItem oldItem = items[index];
        Control savedControl = oldItem.getControl();
        Object savedData = oldItem.getData();
        oldItem.dispose();
        CTabItem item = new CTabItem(tabFolder, 64, index);
        item.setControl(savedControl);
        item.setData(savedData);
    }

    public void addPageManager(IPageManager pageManager) {
        IEditorPart editor = pageManager.getEditor();
        IFileEditorInput editorInput = pageManager.getEditorInput();
        String pageTitle = pageManager.getTitle();
        Image pageImage = pageManager.getImage();
        try {
            editor.getClass();
            editorInput.getClass();
            int pageIndex = this.addPage(editor, (IEditorInput)editorInput);
            this.setPageText(pageIndex, pageTitle);
            this.setPageImage(pageIndex, pageImage);
            this.pageManagers.put(pageManager.getEditor(), pageManager);
            IUndoContext undoContext = pageManager.getUndoContext();
            if (undoContext != null) {
                this.getUndoContext().addMatch(undoContext);
            }
        }
        catch (PartInitException e) {
            this.showError("Error creating nested " + pageTitle + " editor", (Exception)((Object)e));
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    protected PagedContentOutlinePage createContentOutlinePage() {
        PagedContentOutlinePage page = new PagedContentOutlinePage(this);
        return page;
    }

    protected void createModel() {
        Throwable loadingException;
        XMLResource loadedResource;
        ResourceSet resourceSet;
        block19: {
            URI sourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
            resourceSet = this.getResourceSet();
            loadedResource = null;
            loadingException = null;
            try {
                loadedResource = this.masterResource = (XMLResource)resourceSet.getResource(sourceURI, true);
                this.textResource = null;
            }
            catch (WrappedException e) {
                Throwable cause = e.getCause();
                Resource reloadedResource = resourceSet.getResource(sourceURI, false);
                if (cause instanceof SAXException) {
                    if (reloadedResource != null) {
                        resourceSet.getResources().remove((Object)reloadedResource);
                    }
                    URI resourceURI = sourceURI.appendFileExtension(this.creationFactory.getEcoreExtension());
                    try {
                        try {
                            this.masterResource = (XMLResource)resourceSet.getResource(resourceURI, true);
                        }
                        catch (WrappedException e1) {
                            Throwable e2 = e1.getCause();
                            if (e2 instanceof CoreException) {
                                IStatus status = ((CoreException)e2).getStatus();
                                int code = status.getCode();
                                if (status instanceof IResourceStatus) {
                                    this.masterResource = code == 368 ? (XMLResource)resourceSet.createResource(resourceURI) : (XMLResource)resourceSet.getResource(resourceURI, false);
                                }
                            }
                            if (this.masterResource == null) {
                                this.masterResource = (XMLResource)resourceSet.createResource(resourceURI);
                                this.showError("Failed to create '" + resourceURI + "'", (Exception)((Object)e1));
                            }
                            if (this.masterResource == null) {
                                this.masterResource = (XMLResource)resourceSet.createResource(resourceURI);
                                this.showError("Failed to create '" + resourceURI + "'", null);
                            }
                            this.textResource = new TextResource(sourceURI);
                            resourceSet.getResources().add(0, (Object)this.textResource);
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.masterResource == null) {
                            this.masterResource = (XMLResource)resourceSet.createResource(resourceURI);
                            this.showError("Failed to create '" + resourceURI + "'", null);
                        }
                        this.textResource = new TextResource(sourceURI);
                        resourceSet.getResources().add(0, (Object)this.textResource);
                        throw throwable;
                    }
                    if (this.masterResource == null) {
                        this.masterResource = (XMLResource)resourceSet.createResource(resourceURI);
                        this.showError("Failed to create '" + resourceURI + "'", null);
                    }
                    this.textResource = new TextResource(sourceURI);
                    resourceSet.getResources().add(0, (Object)this.textResource);
                }
                loadingException = e;
                loadedResource = reloadedResource;
            }
            catch (Exception e) {
                loadingException = e;
            }
        }
        if (this.hasGenerics(resourceSet)) {
            this.getActionBarContributor().showGenerics(true);
        }
        if (loadedResource != null) {
            Diagnostic diagnostic = this.analyzeResourceProblems((Resource)loadedResource, (Exception)loadingException);
            if (diagnostic.getSeverity() != 0) {
                this.resourceToDiagnosticMap.put(loadedResource, this.analyzeResourceProblems((Resource)loadedResource, (Exception)loadingException));
            }
            resourceSet.eAdapters().add((Object)this.problemIndicationAdapter);
            this.updateProblemIndication();
        }
    }

    protected PagedOperationHistoryListener createOperationHistoryListener() {
        return new PagedOperationHistoryListener(this);
    }

    protected PageDefinitions createPageFactoryRegistries() {
        return new PageDefinitions();
    }

    protected void createPages() {
        this.createModel();
        PageDefinitions pageFactoryRegistries = this.getPageFactoryRegistries();
        if (this.masterResource != null) {
            this.masterPageManager = pageFactoryRegistries.createMasterPageFor(this, this.masterResource, this.textResource);
        }
        if (this.masterPageManager == null) {
            try {
                throw new PartInitException("Failed to identify a Master Page Manager");
            }
            catch (PartInitException e) {
                QVTEditorPlugin.logError("Failed to identify a Master Page Manager", e);
                return;
            }
        }
        pageFactoryRegistries.createOtherPagesFor(this);
        if (this.textResource == null) {
            for (IPageManager pageManager : this.pageManagers.values()) {
                if (!(pageManager instanceof TreePageManager)) continue;
                this.validPageManager = pageManager;
                break;
            }
        }
        IEditorPart initialPage = this.masterPageManager.getInitialPage();
        this.setActiveEditor(initialPage);
        this.updateProblemIndication();
    }

    protected IPropertySheetPage createPropertySheetPage() {
        PagedPropertySheetPage page = new PagedPropertySheetPage(this);
        page.setPropertySourceProvider((IPropertySourceProvider)new TransactionalAdapterFactoryContentProvider(this.getTransactionalEditingDomain(), this.getAdapterFactory()));
        return page;
    }

    public Adapter createResourceAdapter(ResourceItemProviderAdapterFactory resourceItemProviderAdapterFactory, Resource resource) {
        return resourceItemProviderAdapterFactory.createResourceAdapter();
    }

    protected IShowInTargetList createShowInTargetList() {
        return new IShowInTargetList(){

            public String[] getShowInTargetIds() {
                return new String[]{"org.eclipse.ui.views.PropertySheet", "org.eclipse.ui.views.ContentOutline", "org.eclipse.qvt.declarative.editor.ui.cst"};
            }
        };
    }

    protected IUndoContext createUndoContext() {
        return new ObjectUndoContext((Object)this, PagedEditor.getString("UndoContext_label"));
    }

    public void deactivate(IPageManager oldPageManager, long pageChangeTimeStamp) {
        if (oldPageManager != null) {
            oldPageManager.deactivated(this.getProgressMonitor(), pageChangeTimeStamp);
        }
    }

    @Override
    public void dispose() {
        if (this.operationHistoryListener != null) {
            if (traceOperationHistory.isActive()) {
                traceOperationHistory.println("Remove " + this.operationHistoryListener.toString());
            }
            this.getOperationHistory().removeOperationHistoryListener((IOperationHistoryListener)this.operationHistoryListener);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.activePageManager != this.masterPageManager) {
            IMasterPageManager activeIndirectPageManager = this.activePageManager.getAdapter(IMasterPageManager.class);
            if (activeIndirectPageManager == null) {
                ResourceSetSaveCommand pageSaveCommand = new ResourceSetSaveCommand(this, monitor);
                this.getCommandStack().execute((Command)pageSaveCommand);
            } else {
                this.doSaveAs(monitor);
            }
        } else {
            MasterPageSaveCommand pageSaveCommand = new MasterPageSaveCommand(this, monitor);
            this.getCommandStack().execute((Command)pageSaveCommand);
        }
    }

    @Override
    public void doSaveAs() {
        this.doSaveAs(this.getProgressMonitor());
    }

    public void doSaveAs(IProgressMonitor monitor) {
        IPath suggestedPath;
        IMasterPageManager activeIndirectPageManager = this.activePageManager.getAdapter(IMasterPageManager.class);
        if (activeIndirectPageManager == null) {
            QVTEditorPlugin.logError(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".doSaveAs for a " + this.activePageManager.getClass().getName(), null);
            return;
        }
        IFile inputFile = this.getEditorInputFile();
        IPath inputPath = inputFile.getFullPath();
        if (inputPath.equals((Object)(suggestedPath = inputPath.removeFileExtension().addFileExtension(activeIndirectPageManager.getFileExtension())))) {
            suggestedPath = suggestedPath.removeLastSegments(1).append("Copy of " + inputFile.getName());
        }
        IFile suggestedFile = ResourcesPlugin.getWorkspace().getRoot().getFile(suggestedPath);
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getShell());
        saveAsDialog.setOriginalFile(suggestedFile);
        saveAsDialog.open();
        IPath saveAsPath = saveAsDialog.getResult();
        if (saveAsPath != null) {
            IFile saveAsFile = ResourcesPlugin.getWorkspace().getRoot().getFile(saveAsPath);
            activeIndirectPageManager.saveTo(saveAsFile, monitor);
        }
    }

    public void doSaveCommand(IProgressMonitor monitor) throws OperationCanceledException {
        this.masterPageManager.doSave(monitor);
        this.validPageManager = this.masterPageManager;
        this.getCommandStack().saveIsDone();
    }

    public PagedActionBarContributor getActionBarContributor() {
        return (PagedActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    @Override
    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    public IPageManager getActivePageManager() {
        return this.activePageManager;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            if (this.contentOutlinePage == null) {
                this.contentOutlinePage = this.createContentOutlinePage();
            }
            return this.contentOutlinePage;
        }
        if (key.equals(IPropertySheetPage.class)) {
            if (this.propertySheetPage == null) {
                this.propertySheetPage = this.createPropertySheetPage();
            }
            return this.propertySheetPage;
        }
        if (key.equals(IShowInTargetList.class)) {
            if (this.showInTargetList == null) {
                this.showInTargetList = this.createShowInTargetList();
            }
            return this.showInTargetList;
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        if (key.equals(IUndoContext.class)) {
            return this.getUndoContext();
        }
        return super.getAdapter(key);
    }

    public AdapterFactory getAdapterFactory() {
        return this.editingDomain.getAdapterFactory();
    }

    @Override
    public AdapterFactoryEditingDomain getAdapterFactoryEditingDomain() {
        return this.editingDomain;
    }

    public String getContributorId() {
        return QVTEditorPlugin.ID;
    }

    public ICreationFactory getCreationFactory() {
        return this.creationFactory;
    }

    protected Collection<AdapterFactory> getDomainAdapterFactories() {
        ArrayList<AdapterFactory> domainAdapterFactories = new ArrayList<AdapterFactory>();
        domainAdapterFactories.add((AdapterFactory)new EcoreItemProviderAdapterFactory());
        domainAdapterFactories.add((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return domainAdapterFactories;
    }

    @Override
    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public String getEditingDomainID() {
        return "org.eclipse.qvt.declarative.editingDomainID";
    }

    public IEditorPart getEditor(String pageTitle) {
        int count = this.getPageCount();
        int i = 0;
        while (i < count) {
            String pageText = this.getPageText(i);
            if (pageTitle.equals(pageText)) {
                return this.getEditor(i);
            }
            ++i;
        }
        return null;
    }

    public IFileEditorInput getEditorInput() {
        return (IFileEditorInput)super.getEditorInput();
    }

    public IFile getEditorInputFile() {
        return this.getEditorInput().getFile();
    }

    public IMappingMetaDataRegistry getMappingMetaDataRegistry() throws MappingConfigurationException {
        IMappingMetaData mappingMetaData = this.getCreationFactory().getMappingMetaData();
        ResourceSet resourceSet = this.getResourceSet();
        return ResourceSetMappingMetaDataRegistryAdapter.getMappingMetaDataRegistry((ResourceSet)resourceSet, (IMappingMetaData)mappingMetaData);
    }

    public IMasterPageManager getMasterPageManager() {
        return this.masterPageManager;
    }

    public long getNextResourceSetTimeStamp() {
        if (this.isDirtyPage()) {
            ++this.resourceSetTimeStamp;
        }
        return this.resourceSetTimeStamp;
    }

    public IOperationHistory getOperationHistory() {
        return this.getWorkspaceCommandStack().getOperationHistory();
    }

    public <T extends IPageFactoryRegistry<?>> T getPageFactoryRegistry(Class<T> class1) {
        return this.pageFactoryRegistries.get(class1);
    }

    public PageDefinitions getPageFactoryRegistries() {
        if (this.pageFactoryRegistries == null) {
            this.pageFactoryRegistries = this.createPageFactoryRegistries();
            this.initializePageFactoryRegistries();
        }
        return this.pageFactoryRegistries;
    }

    public int getPageIndex(IEditorPart editorPart) {
        int count = this.getPageCount();
        int i = 0;
        while (i < count) {
            IEditorPart editor = this.getEditor(i);
            if (editor == editorPart) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Collection<IPageManager> getPageManagers() {
        return this.pageManagers.values();
    }

    public String getPageTitle(IEditorPart editor) {
        int pageIndex = this.getPageIndex(editor);
        if (pageIndex < 0) {
            return null;
        }
        return this.getPageText(pageIndex);
    }

    public IProgressMonitor getProgressMonitor() {
        IProgressMonitor pm = null;
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            pm = manager.getProgressMonitor();
        }
        return pm != null ? pm : new NullProgressMonitor();
    }

    public IProject getProject() {
        return this.getEditorInputFile().getProject();
    }

    public IPropertySheetPage getPropertySheetPage() {
        return this.propertySheetPage;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.editingDomain.getResourceSet();
    }

    public long getResourceSetTimeStamp() {
        return this.resourceSetTimeStamp;
    }

    @Override
    public ISelection getSelection() {
        return this.editorSelection;
    }

    protected IStatusLineManager getStatusLineManager() {
        return this.getEditorSite().getActionBars().getStatusLineManager();
    }

    public IFolder getTmpDir() throws CoreException {
        IFolder tmpdir = this.getProject().getFolder(".tmpdir");
        if (!tmpdir.exists()) {
            tmpdir.create(true, false, null);
        }
        return tmpdir;
    }

    public TransactionalEditingDomain getTransactionalEditingDomain() {
        return this.editingDomain;
    }

    public ObjectUndoContext getUndoContext() {
        return this.operationHistoryListener.getUndoContext();
    }

    public Viewer getViewer() {
        return (Viewer)(this.currentSelectionProvider instanceof Viewer ? this.currentSelectionProvider : null);
    }

    public IWorkspaceCommandStack getWorkspaceCommandStack() {
        return (IWorkspaceCommandStack)super.getCommandStack();
    }

    public void gotoMarker(IMarker marker) {
        if (this.activePageManager != null && this.activePageManager.gotoMarker(marker)) {
            return;
        }
        this.setSelectionToViewer(this.markerHelper.getTargetObjects((Object)this.editingDomain, marker));
    }

    @Override
    protected void handleActivate() {
        super.handleActivate();
    }

    public void handleContentOutlineSelection(ISelection selection) {
        if (this.contentOutlinePage != null && this.currentSelectionProvider == this.contentOutlinePage.getTreeViewer()) {
            this.setSelection(selection);
        }
    }

    public boolean hasGenerics(ResourceSet resourceSet) {
        for (Resource resource : resourceSet.getResources()) {
            TreeIterator i = resource.getAllContents();
            while (i.hasNext()) {
                EObject eObject = (EObject)i.next();
                if (!(eObject instanceof ETypeParameter) && (!(eObject instanceof EGenericType) || ((EGenericType)eObject).getETypeArguments().isEmpty())) continue;
                return true;
            }
        }
        return false;
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        this.initializeOperationHistoryListener();
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    protected void initializeEditingDomain() {
        this.editingDomain = (TransactionalEditingDomainImpl)new PagedEditingDomainFactory().createEditingDomain();
        this.editingDomain.setID(this.getEditingDomainID());
        ComposedAdapterFactory adapterFactory = (ComposedAdapterFactory)this.editingDomain.getAdapterFactory();
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        for (AdapterFactory domainAdapterFactory : this.getDomainAdapterFactories()) {
            adapterFactory.addAdapterFactory(domainAdapterFactory);
        }
    }

    protected void initializeOperationHistoryListener() {
        this.operationHistoryListener = this.createOperationHistoryListener();
        if (traceOperationHistory.isActive()) {
            traceOperationHistory.println("Install " + this.operationHistoryListener.toString());
        }
        this.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this.operationHistoryListener);
        this.getUndoContext().addMatch(this.getWorkspaceCommandStack().getDefaultUndoContext());
    }

    protected void initializePageFactoryRegistries() {
        new PageDefinitionsReader(this).readRegistry();
    }

    public void initializeTreeViewer(TreeViewer viewer) {
        HideResourceAdaptersAction hideResourceAdaptersAction = this.getActionBarContributor().getHideResourceAdaptersAction();
        viewer.addFilter((ViewerFilter)new HideResourceAdaptersViewerFilter(hideResourceAdaptersAction));
        viewer.setContentProvider((IContentProvider)new TransactionalAdapterFactoryContentProvider((TransactionalEditingDomain)this.editingDomain, this.getAdapterFactory()));
        viewer.setLabelProvider((IBaseLabelProvider)new TransactionalAdapterFactoryLabelProvider((TransactionalEditingDomain)this.editingDomain, this.getAdapterFactory()));
        viewer.setInput((Object)this.getResourceSet());
        new AdapterFactoryTreeEditor(viewer.getTree(), this.getAdapterFactory());
        hideResourceAdaptersAction.addPropertyChangeListener(new HideResourceAdaptersPropertyChangeListener(viewer));
    }

    public boolean isDirty() {
        return this.operationHistoryListener.isDirty();
    }

    public boolean isDirtyPage() {
        return this.operationHistoryListener.isDirtyPage();
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        this.getActionBarContributor().menuAboutToShow(menuManager);
    }

    protected void pageChange(int newPageIndex) {
        IEditorPart newEditor;
        IPageManager newPageManager;
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
        if ((newPageManager = this.pageManagers.get(newEditor = this.getEditor(newPageIndex))) == null) {
            if (!(newEditor instanceof ProblemEditorPart)) {
                QVTEditorPlugin.logError("No page manager for page " + newPageIndex, null);
            }
            return;
        }
        if (this.activePageManager == newPageManager) {
            return;
        }
        if (this.activePageManager != null) {
            this.setActiveEditor(this.activePageManager.getEditor());
            PageChangeCommand pageChangeCommand = new PageChangeCommand(this, newPageManager);
            this.getCommandStack().execute((Command)pageChangeCommand);
        } else {
            this.setActivePageManager(newPageManager, this.resourceSetTimeStamp);
        }
    }

    public void registryChanged() {
        this.getDisplay().asyncExec((Runnable)new ModelRegistryChangedRunnable());
    }

    public void removePageManager(IPageManager pageManager) {
        this.pageManagers.remove(pageManager.getEditor());
        this.getUndoContext().removeMatch(pageManager.getUndoContext());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 1) {
            EclipseProjectHandle projectHandle = new EclipseProjectHandle(this.getProject());
            final IFile registryResource = projectHandle.getRegistryResource();
            IResourceDelta resourceDelta = event.getDelta();
            try {
                resourceDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) {
                        IResource changedResource = delta.getResource();
                        if (changedResource.equals((Object)registryResource)) {
                            PagedEditor.this.registryChanged();
                        }
                        return true;
                    }
                });
            }
            catch (CoreException coreException) {}
        }
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages;
                    IFileEditorInput fileEditorInput = PagedEditor.this.getEditorInput();
                    IProject project = fileEditorInput.getFile().getProject();
                    IWorkbenchPage[] iWorkbenchPageArray = pages = PagedEditor.this.getSite().getWorkbenchWindow().getPages();
                    int n = pages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchPage page = iWorkbenchPageArray[n2];
                        if (project.equals((Object)event.getResource())) {
                            IEditorPart editorPart = page.findEditor((IEditorInput)fileEditorInput);
                            page.closeEditor(editorPart, true);
                        }
                        ++n2;
                    }
                }
            });
        }
    }

    @Override
    protected void resumeResourceListening() {
        for (IPageManager pageManager : this.pageManagers.values()) {
            pageManager.resumeResourceListening();
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.setSelection(selectionChangedEvent.getSelection());
    }

    public void setActivePage(int pageIndex) {
        super.setActivePage(pageIndex);
    }

    public void setActivePageManager(IPageManager newPageManager, long pageChangeTimeStamp) {
        try {
            ObjectUndoContext editorUndoContext;
            newPageManager.activate(this.getProgressMonitor(), pageChangeTimeStamp);
            IUndoContext undoContext = newPageManager.getUndoContext();
            if (undoContext != null && !(editorUndoContext = this.getUndoContext()).matches(undoContext)) {
                editorUndoContext.addMatch(undoContext);
            }
            if (this.activePageManager != newPageManager) {
                int oldPageIndex;
                if (this.activePageManager != null && (oldPageIndex = this.getPageIndex(this.activePageManager.getEditor())) >= 0) {
                    this.showDirtyPage(false);
                }
                if (this.currentSelectionProvider == this.activePageManager) {
                    this.setCurrentSelectionProvider(newPageManager);
                }
                this.activePageManager = newPageManager;
                this.activePageManager.refresh();
                IEditorPart editorPart = this.activePageManager.getEditor();
                this.setActiveEditor(editorPart);
                int pageIndex = this.getPageIndex(editorPart);
                if (pageIndex >= 0) {
                    super.pageChange(pageIndex);
                }
            }
        }
        catch (Exception e) {
            String message = "Error activating " + newPageManager.getTitle() + " editor";
            this.showError(message, e);
        }
    }

    public void setCurrentSelectionProvider(ISelectionProvider newSelectionProvider) {
        if (this.currentSelectionProvider != newSelectionProvider) {
            if (this.currentSelectionProvider != null) {
                this.currentSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            this.currentSelectionProvider = newSelectionProvider;
            if (this.currentSelectionProvider != null) {
                this.currentSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
            this.setSelection((ISelection)(this.currentSelectionProvider == null ? StructuredSelection.EMPTY : this.currentSelectionProvider.getSelection()));
        }
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    protected void setPageText(int pageIndex, String text) {
        if (pageIndex == this.getActivePage() && this.isDirtyPage()) {
            text = "*" + text;
        }
        if (traceEditorShowDirty.isActive()) {
            traceEditorShowDirty.println("setPageText " + pageIndex + ":" + text);
        }
        super.setPageText(pageIndex, text);
    }

    public void setPageTitle(IEditorPart editor, String title) {
        int pageIndex = this.getPageIndex(editor);
        if (pageIndex >= 0) {
            this.setPageText(pageIndex, title);
        }
    }

    @Override
    public void setSelection(ISelection selection) {
        if (selection != null && selection.equals(this.editorSelection)) {
            return;
        }
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        if (this.activePageManager != null) {
            this.activePageManager.setSelection(selection);
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.setSelection(selection);
        }
        this.setSelectionToStatusLineManager(selection);
    }

    public void setSelectionToAll(ISelection selection) {
        if (selection != null && selection.equals(this.editorSelection)) {
            return;
        }
        this.editorSelection = selection;
        if (this.activePageManager != null) {
            this.activePageManager.setSelection(selection);
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.setSelection(selection);
        }
        this.setSelectionToStatusLineManager(selection);
    }

    public void setSelectionToStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        boolean isOutline = this.contentOutlinePage != null && this.currentSelectionProvider == this.contentOutlinePage.getTreeViewer();
        IStatusLineManager iStatusLineManager = statusLineManager = isOutline ? this.contentOutlinePage.getStatusLineManager() : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(PagedEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator(this.getAdapterFactory()).getText(collection.iterator().next());
                        statusLineManager.setMessage(PagedEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(PagedEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (PagedEditor.this.currentSelectionProvider != null) {
                        PagedEditor.this.currentSelectionProvider.setSelection((ISelection)new StructuredSelection(theSelection.toArray()));
                    }
                }
            };
            runnable.run();
        }
    }

    public void showDirtyPage(boolean isDirtyPage) {
        int pageIndex;
        String title = this.activePageManager.getTitle();
        if (traceEditorShowDirty.isActive()) {
            traceEditorShowDirty.println(Boolean.toString(isDirtyPage));
        }
        if ((pageIndex = this.getPageIndex(this.activePageManager.getEditor())) >= 0) {
            this.setPageText(pageIndex, title);
        }
    }

    public void showError(String message, Exception e) {
        Object status = e instanceof CoreException ? ((CoreException)((Object)e)).getStatus() : QVTEditorPlugin.createErrorStatus(message, e);
        String title = String.valueOf(this.getCreationFactory().getEditorName()) + " Editor Problem";
        ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)status);
        if (e != null) {
            QVTEditorPlugin.logError(message, e);
        }
    }

    @Override
    protected void suspendResourceListening() {
        for (IPageManager pageManager : this.pageManagers.values()) {
            pageManager.suspendResourceListening();
        }
    }

    public String toString() {
        IFile editorInputFile = this.getEditorInputFile();
        if (editorInputFile == null) {
            return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " null-editor-input-file";
        }
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " '" + editorInputFile.getName().toString() + "'";
    }

    public ISelection unwrapEditPartSelection(ISelection selection) {
        return selection;
    }

    protected static class HideResourceAdaptersPropertyChangeListener
    implements IPropertyChangeListener {
        protected final TreeViewer viewer;

        protected HideResourceAdaptersPropertyChangeListener(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty() == "checked") {
                this.viewer.refresh();
            }
        }
    }

    protected static class HideResourceAdaptersViewerFilter
    extends ViewerFilter {
        protected final HideResourceAdaptersAction hideResourceAdaptersAction;

        protected HideResourceAdaptersViewerFilter(HideResourceAdaptersAction hideResourceAdaptersAction) {
            this.hideResourceAdaptersAction = hideResourceAdaptersAction;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.hideResourceAdaptersAction.select(element);
        }
    }

    private final class ModelRegistryChangedRunnable
    implements Runnable {
        private ModelRegistryChangedRunnable() {
        }

        public void run() {
            PagedEditor.this.activePageManager.refresh();
        }
    }

    private final class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == PagedEditor.this.contentOutlinePage) {
                    PagedEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)PagedEditor.this);
                    PagedEditor.this.setCurrentSelectionProvider((ISelectionProvider)PagedEditor.this.contentOutlinePage.getTreeViewer());
                }
            } else if (p instanceof PropertySheet) {
                if (((PropertySheet)p).getCurrentPage() == PagedEditor.this.propertySheetPage) {
                    PagedEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)PagedEditor.this);
                    PagedEditor.this.handleActivate();
                }
            } else if (p == PagedEditor.this) {
                PagedEditor.this.setCurrentSelectionProvider(PagedEditor.this.activePageManager);
                PagedEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    }
}

