/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.ui.action;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.am3.core.AM3CorePlugin;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;
import org.eclipse.m2m.atl.ocl.core.OclQuery;

public class ActionANTTransformation
extends Action {
    private ASMModelElement antTransformation;
    private String uriTCSFile;

    public ActionANTTransformation(String text, ASMModelElement antTransformation, String uriTCSFile) {
        super(text);
        this.antTransformation = antTransformation;
        this.uriTCSFile = uriTCSFile;
    }

    public void run() {
        Job job = new Job("ANTTransformation"){

            public IStatus run(IProgressMonitor mon) {
                Status ret = null;
                mon.beginTask("ANT Transformation", -1);
                mon.subTask("Init ANT properties");
                HashMap<String, ASMModel> models = new HashMap<String, ASMModel>();
                models.put("AM3", AM3CorePlugin.getDefault().getHandler().getAsmModelAM3());
                models.put("mgm", AM3CorePlugin.getDefault().getHandler().getAsmModelMegamodel());
                HashMap<String, String> mapProperties = new HashMap<String, String>();
                ASMOclAny context = ActionANTTransformation.this.antTransformation.get(null, "context");
                ASMSequence properties = (ASMSequence)context.get(null, "properties");
                Iterator it = properties.iterator();
                while (it.hasNext()) {
                    try {
                        ASMModelElement property = (ASMModelElement)it.next();
                        ASMString propertyName = (ASMString)property.get(null, "propertyName");
                        ASMString correspondingAttribute = (ASMString)property.get(null, "correspondingAttribute");
                        ASMOclAny attributeValue = new OclQuery("AM3!Artifact.allInstances()->select(e | e.uri = '" + ActionANTTransformation.this.uriTCSFile + "')->first()." + correspondingAttribute.getSymbol()).eval(models);
                        if (attributeValue instanceof ASMString) {
                            mapProperties.put(propertyName.getSymbol(), ((ASMString)attributeValue).getSymbol());
                            continue;
                        }
                        System.err.println("Only string type is allowed for ANT property");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ASMSequence parameters = (ASMSequence)ActionANTTransformation.this.antTransformation.get(null, "parameters");
                Iterator it2 = parameters.iterator();
                while (it2.hasNext()) {
                    ASMModelElement me = (ASMModelElement)it2.next();
                    ASMString name = (ASMString)me.get(null, "name");
                    ASMString relationName = (ASMString)me.get(null, "reachableBy");
                    ASMSequence propertiesParam = (ASMSequence)me.get(null, "properties");
                    Iterator it22 = propertiesParam.iterator();
                    while (it22.hasNext()) {
                        try {
                            ASMModelElement property = (ASMModelElement)it22.next();
                            ASMString propertyName = (ASMString)property.get(null, "propertyName");
                            ASMString correspondingAttribute = (ASMString)property.get(null, "correspondingAttribute");
                            ASMOclAny attributeValue = new OclQuery("AM3!" + relationName.getSymbol() + ".allInstances()->select(e |" + "\te.relationEnds->exists(f | f.artifact.uri = '" + ActionANTTransformation.this.uriTCSFile + "')" + ")->first().relationEnds->select(e |" + "\te.artifact.oclIsKindOf(AM3!" + name.getSymbol() + ")" + ")->first().artifact." + correspondingAttribute.getSymbol()).eval(models);
                            if (attributeValue instanceof ASMString) {
                                mapProperties.put(propertyName.getSymbol(), ((ASMString)attributeValue).getSymbol());
                                continue;
                            }
                            System.err.println("Only string type is allowed for ANT property");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                AntRunner runner = new AntRunner();
                ASMString uriTransformation = (ASMString)ActionANTTransformation.this.antTransformation.get(null, "uri");
                IWorkspace wks = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot wksroot = wks.getRoot();
                IFile currentAntFile = wksroot.getFile((IPath)new Path(uriTransformation.getSymbol()));
                runner.setBuildFileLocation(currentAntFile.getLocation().toOSString());
                runner.addUserProperties(mapProperties);
                try {
                    mon.subTask("ANT script execution");
                    runner.run(mon);
                    ret = new Status(0, "org.eclipse.am3.tools.ant", 0, "Execution terminated", null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return ret;
            }
        };
        job.setPriority(40);
        job.schedule();
    }
}

