/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.debug.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.m2m.atl.adt.debug.core.AtlDebugElement;
import org.eclipse.m2m.atl.adt.debug.core.AtlDebugTarget;
import org.eclipse.m2m.atl.adt.debug.core.AtlMapValue;
import org.eclipse.m2m.atl.adt.debug.core.AtlVariable;
import org.eclipse.m2m.atl.engine.vm.adwp.BooleanValue;
import org.eclipse.m2m.atl.engine.vm.adwp.IntegerValue;
import org.eclipse.m2m.atl.engine.vm.adwp.NullValue;
import org.eclipse.m2m.atl.engine.vm.adwp.ObjectReference;
import org.eclipse.m2m.atl.engine.vm.adwp.RealValue;
import org.eclipse.m2m.atl.engine.vm.adwp.StringValue;
import org.eclipse.m2m.atl.engine.vm.adwp.Value;

public class AtlValue
extends AtlDebugElement
implements IValue {
    String typeName;
    String asString;
    Value value;
    ObjectReference asType = null;
    AtlDebugTarget atlDT;

    public AtlValue(Value value, ObjectReference asType, AtlDebugTarget atlDT) {
        this(value, atlDT);
        this.asType = asType;
        this.typeName = AtlValue.getTypeName(value, asType);
        this.asString = value.toString();
    }

    public AtlValue(Value value, AtlDebugTarget atlDT) {
        super(atlDT);
        this.value = value;
        this.atlDT = atlDT;
        this.typeName = AtlValue.getTypeName(value);
        this.asString = this.typeName.equals("EnumLiteral") ? ((StringValue)((ObjectReference)value).call("toString", Collections.EMPTY_LIST)).getValue() : value.toString();
    }

    static String getTypeName(Value value) {
        return AtlValue.getTypeName(value, null);
    }

    static String getTypeName(Value value, ObjectReference asType) {
        String ret = null;
        if (value instanceof BooleanValue) {
            ret = "Boolean";
        }
        if (value instanceof IntegerValue) {
            ret = "Integer";
        }
        if (value instanceof RealValue) {
            ret = "Real";
        }
        if (value instanceof StringValue) {
            ret = "String";
        }
        if (value instanceof NullValue) {
            ret = "Null";
        }
        if (value instanceof ObjectReference) {
            ObjectReference or = (ObjectReference)value;
            ObjectReference v = asType;
            if (v == null) {
                v = or.call("oclType", new ArrayList());
            }
            if (v instanceof ObjectReference) {
                or = v;
                ret = ((StringValue)or.call("getName", new ArrayList())).getValue();
            } else {
                ret = "ObjectReference";
            }
        }
        return ret;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.typeName;
    }

    public String getValueString() throws DebugException {
        return this.asString;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    private IVariable[] getProperties(ObjectReference orValue, ObjectReference type, String supertypesName, String contentsName, String referenceName, String attributeName) throws DebugException {
        IVariable[] ret = null;
        ArrayList<AtlVariable> list = new ArrayList<AtlVariable>();
        ObjectReference supertypes = (ObjectReference)type.get(supertypesName);
        int n = ((IntegerValue)supertypes.call("size", new ArrayList())).getValue();
        int i = 1;
        while (i <= n) {
            ObjectReference element = (ObjectReference)supertypes.call("at", Arrays.asList(IntegerValue.valueOf((int)i)));
            list.add(new AtlVariable("<supertype>", new AtlValue(this.value, element, this.atlDT), this.atlDT, 3));
            ++i;
        }
        ObjectReference contents = (ObjectReference)type.get(contentsName);
        n = ((IntegerValue)contents.call("size", new ArrayList())).getValue();
        int i2 = 1;
        while (i2 <= n) {
            Value varValue;
            String en;
            ObjectReference element = (ObjectReference)contents.call("at", Arrays.asList(IntegerValue.valueOf((int)i2)));
            String tn = AtlValue.getTypeName((Value)element);
            if (tn.equals(referenceName)) {
                en = ((StringValue)element.get("name")).getValue();
                varValue = orValue.get(en);
                list.add(new AtlVariable(en, new AtlValue(varValue, this.atlDT), this.atlDT, 1));
            } else if (tn.equals(attributeName)) {
                en = ((StringValue)element.get("name")).getValue();
                varValue = orValue.get(en);
                list.add(new AtlVariable(en, new AtlValue(varValue, this.atlDT), this.atlDT, 2));
            }
            ++i2;
        }
        ret = list.toArray(new IVariable[0]);
        return ret;
    }

    public IVariable[] getVariables() throws DebugException {
        IVariable[] ret = null;
        if (this.value instanceof ObjectReference) {
            ObjectReference orValue = (ObjectReference)this.value;
            ObjectReference v = this.asType;
            if (v == null) {
                v = orValue.call("oclType", new ArrayList());
            }
            if (v instanceof ObjectReference) {
                ObjectReference type = v;
                String ttn = AtlValue.getTypeName((Value)type);
                if (ttn.equals("MOF!Class")) {
                    ret = this.getProperties(orValue, type, "supertypes", "contents", "MOF!Reference", "MOF!Attribute");
                } else if (ttn.equals("MOF!EClass")) {
                    ret = this.getProperties(orValue, type, "eSuperTypes", "eStructuralFeatures", "MOF!EReference", "MOF!EAttribute");
                } else {
                    String tn = this.typeName;
                    if (tn.equals("Sequence")) {
                        ret = this.doSequence(orValue);
                    } else if (tn.equals("Set")) {
                        orValue = (ObjectReference)orValue.call("asSequence", new ArrayList());
                        ret = this.doSequence(orValue);
                    } else if (tn.equals("Bag")) {
                        orValue = (ObjectReference)orValue.call("asSequence", new ArrayList());
                        ret = this.doSequence(orValue);
                    } else if (tn.equals("Map")) {
                        ret = this.doMap(orValue, false);
                    } else if (tn.equals("Tuple")) {
                        ObjectReference map = (ObjectReference)orValue.call("asMap", new ArrayList());
                        ret = this.doMap(map, true);
                    }
                }
            }
        }
        if (ret == null) {
            ret = new IVariable[]{};
        }
        return ret;
    }

    private IVariable[] doMap(ObjectReference orValue, boolean useKeyAsName) {
        IVariable[] ret = null;
        ObjectReference keys = (ObjectReference)orValue.call("getKeys", new ArrayList());
        keys = (ObjectReference)keys.call("asSequence", new ArrayList());
        ArrayList<AtlVariable> list = new ArrayList<AtlVariable>();
        int n = ((IntegerValue)keys.call("size", new ArrayList())).getValue();
        int i = 1;
        while (i <= n) {
            Value varKey = keys.call("at", Arrays.asList(IntegerValue.valueOf((int)i)));
            Value varValue = orValue.call("get", Arrays.asList(varKey));
            if (useKeyAsName) {
                list.add(new AtlVariable(((StringValue)varKey).getValue(), new AtlValue(varValue, this.atlDT), this.atlDT, 2));
            } else {
                list.add(new AtlVariable("Map[" + i + "]", new AtlMapValue(varKey, varValue, this.atlDT), this.atlDT, 4));
            }
            ++i;
        }
        ret = list.toArray(new IVariable[0]);
        if (ret.length == 0) {
            ret = null;
        }
        return ret;
    }

    private IVariable[] doSequence(ObjectReference orValue) {
        IVariable[] ret = null;
        ArrayList<AtlVariable> list = new ArrayList<AtlVariable>();
        int n = ((IntegerValue)orValue.call("size", new ArrayList())).getValue();
        int i = 1;
        while (i <= n) {
            Value varValue = orValue.call("at", Arrays.asList(IntegerValue.valueOf((int)i)));
            list.add(new AtlVariable("[" + i + "]", new AtlValue(varValue, this.atlDT), this.atlDT, 4));
            ++i;
        }
        ret = list.toArray(new IVariable[0]);
        return ret;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables() != null;
    }

    public String getModelIdentifier() {
        return this.atlDT.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.atlDT.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.atlDT.getLaunch();
    }

    public Value getValue() {
        return this.value;
    }

    public boolean isContainer() {
        try {
            this.hasVariables();
        }
        catch (DebugException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return false;
    }
}

