/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.importer.DeprecatedPlatformRunnable;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.util.ImporterUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public abstract class ModelImporterApplication
implements IApplication,
DeprecatedPlatformRunnable {
    protected ModelImporter modelImporter;
    protected String modelLocations;
    protected IPath genModelFullPath;
    protected boolean reload = false;
    protected IPath modelProjectLocationPath;
    protected IPath modelFragmentPath;
    protected IPath editProjectLocationPath;
    protected IPath editFragmentPath;
    protected IPath editorProjectLocationPath;
    protected IPath editorFragmentPath;
    protected IPath testsProjectLocationPath;
    protected IPath testsFragmentPath;
    protected String templatePath;
    protected String copyright;
    protected boolean sdo = false;
    protected String modelPluginID;
    protected String validateModel;
    protected GenJDKLevel genJDKLevel;
    protected boolean importOrganizing;
    protected List<EPackage> referencedEPackages;
    protected Map<URI, Set<String>> referencedGenModelURIToEPackageNSURIs;
    protected boolean quiet = false;
    protected static final String NL = System.getProperties().getProperty("line.separator");

    public ModelImporter getModelImporter() {
        if (this.modelImporter == null) {
            this.modelImporter = this.createModelImporter();
        }
        return this.modelImporter;
    }

    protected abstract ModelImporter createModelImporter();

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        return this.run(args == null ? new String[]{} : args);
    }

    public void stop() {
    }

    public Object run(final Object args) throws Exception {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor progressMonitor) throws CoreException {
                    try {
                        try {
                            ModelImporterApplication.this.run(progressMonitor, (String[])args);
                        }
                        catch (Exception exception) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.importer", 0, "Error", (Throwable)exception));
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            ResourcesPlugin.getWorkspace().run(runnable, this.getProgressMonitor());
            return 0;
        }
        catch (Exception exception) {
            if (!this.quiet) {
                exception.printStackTrace();
            }
            ImporterPlugin.INSTANCE.log(exception);
            return 1;
        }
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.quiet ? new NullProgressMonitor() : new CodeGenUtil.EclipseUtil.StreamProgressMonitor(System.out);
    }

    public void run(IProgressMonitor progressMonitor, String[] arguments) throws Exception {
        this.run(BasicMonitor.toMonitor((IProgressMonitor)progressMonitor), arguments);
    }

    public void run(Monitor monitor, String[] arguments) throws Exception {
        try {
            monitor.beginTask("", 1);
            if (arguments.length == 0 || "-help".equalsIgnoreCase(arguments[0].toString())) {
                this.printUsage();
            } else {
                this.processArguments(arguments, "-pdelaunch".equals(arguments[0]) ? 1 : 0);
                this.execute(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            }
        }
        finally {
            monitor.done();
        }
    }

    public void printUsage() {
        System.out.println(this.getUsage());
    }

    protected abstract StringBuffer getUsage();

    protected StringBuffer appendLine(StringBuffer buffer, String line) {
        if (line != null) {
            buffer.append(line);
        }
        buffer.append(NL);
        return buffer;
    }

    public void execute(Monitor monitor) throws Exception {
        try {
            monitor.beginTask("", 6);
            this.adjustAttributes(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            this.adjustModelImporter(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            this.computeEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            this.adjustEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            this.adjustGenModel(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            this.doExecute(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
        }
        finally {
            monitor.done();
        }
    }

    protected void processArguments(String[] arguments, int index) {
        index = this.processModelAndGenModelLocationArguments(arguments, index);
        while (index < arguments.length) {
            index = this.processArgument(arguments, index);
        }
    }

    protected int processModelAndGenModelLocationArguments(String[] arguments, int index) {
        StringBuffer locations = new StringBuffer();
        URI firstModelURI = null;
        while (arguments.length > index && arguments[index] != null && !arguments[index].startsWith("-")) {
            String location;
            if ((location = arguments[index++]).endsWith(".genmodel")) {
                this.genModelFullPath = new Path(new File(location).getAbsolutePath());
                break;
            }
            File file = new File(location);
            if (file.isFile()) {
                try {
                    location = URI.createFileURI((String)file.getCanonicalPath()).toString();
                }
                catch (IOException e) {
                    location = URI.createFileURI((String)file.getAbsolutePath()).toString();
                }
            }
            if (firstModelURI == null) {
                firstModelURI = URI.createURI((String)location);
            }
            locations.append(" ").append(location);
        }
        if (firstModelURI != null) {
            this.modelLocations = locations.deleteCharAt(0).toString();
            if (this.genModelFullPath == null) {
                this.genModelFullPath = new Path(new File(firstModelURI.trimFileExtension().appendFileExtension("genmodel").lastSegment()).getAbsolutePath());
            }
        }
        return index;
    }

    protected int processModelProjectArguments(String[] arguments, int index) {
        this.modelProjectLocationPath = new Path(new File(arguments[++index]).getAbsolutePath());
        this.modelFragmentPath = new Path(arguments[++index]);
        return index;
    }

    protected int processArgument(String[] arguments, int index) {
        if (arguments[index].equalsIgnoreCase("-reload")) {
            this.reload = true;
        } else if (arguments[index].equalsIgnoreCase("-modelProject")) {
            index = this.processModelProjectArguments(arguments, index);
        } else if (arguments[index].equalsIgnoreCase("-editProject")) {
            this.editProjectLocationPath = new Path(new File(arguments[++index]).getAbsolutePath());
            this.editFragmentPath = new Path(arguments[++index]);
        } else if (arguments[index].equalsIgnoreCase("-editorProject")) {
            this.editorProjectLocationPath = new Path(new File(arguments[++index]).getAbsolutePath());
            this.editorFragmentPath = new Path(arguments[++index]);
        } else if (arguments[index].equalsIgnoreCase("-testsProject")) {
            this.testsProjectLocationPath = new Path(new File(arguments[++index]).getAbsolutePath());
            this.testsFragmentPath = new Path(arguments[++index]);
        } else if (arguments[index].equalsIgnoreCase("-modelPluginID")) {
            this.modelPluginID = arguments[++index];
        } else if (arguments[index].equalsIgnoreCase("-copyright")) {
            this.copyright = arguments[++index];
        } else if (arguments[index].equalsIgnoreCase("-sdo")) {
            this.sdo = true;
        } else if (arguments[index].equalsIgnoreCase("-quiet")) {
            this.quiet = true;
        } else if (arguments[index].equalsIgnoreCase("-templatePath")) {
            this.templatePath = URI.createFileURI((String)new File(arguments[++index]).getAbsolutePath()).toString();
        } else if (arguments[index].equalsIgnoreCase("-jdkLevel")) {
            this.genJDKLevel = GenJDKLevel.get((String)arguments[++index]);
        } else if (arguments[index].equalsIgnoreCase("-importOrganizing")) {
            this.importOrganizing = true;
        } else if (arguments[index].equalsIgnoreCase("-validateModel")) {
            this.validateModel = arguments[++index];
        } else if (arguments[index].equalsIgnoreCase("-refGenModel")) {
            URI genModelURI;
            Set<String> ePackageNSURIs;
            if (this.referencedGenModelURIToEPackageNSURIs == null) {
                this.referencedGenModelURIToEPackageNSURIs = new HashMap<URI, Set<String>>();
            }
            if ((ePackageNSURIs = this.referencedGenModelURIToEPackageNSURIs.get(genModelURI = URI.createURI((String)arguments[++index]))) == null) {
                ePackageNSURIs = new HashSet<String>();
                this.referencedGenModelURIToEPackageNSURIs.put(genModelURI, ePackageNSURIs);
            }
            do {
                ePackageNSURIs.add(arguments[++index]);
            } while (index + 1 < arguments.length && !arguments[index + 1].startsWith("-"));
        } else {
            this.handleUnrecognizedArgument(arguments[index]);
        }
        return index + 1;
    }

    protected void handleUnrecognizedArgument(String argument) {
        throw new IllegalArgumentException("Unrecognized argument: '" + argument + "'");
    }

    protected void adjustAttributes(Monitor monitor) {
        if (!this.reload) {
            try {
                monitor.beginTask("", 1);
                if (this.modelProjectLocationPath == null) {
                    this.modelProjectLocationPath = new Path(new File(".").getAbsolutePath());
                }
                if (this.modelFragmentPath == null) {
                    this.modelFragmentPath = new Path(".");
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    protected boolean usePlatformURI() {
        return false;
    }

    protected void adjustModelImporter(Monitor monitor) {
        try {
            monitor.beginTask("", 1);
            ModelImporter modelImporter = this.getModelImporter();
            modelImporter.setUsePlatformURI(this.usePlatformURI());
            modelImporter.setGenModelProjectLocation(this.modelProjectLocationPath);
            if (this.modelPluginID != null) {
                modelImporter.setModelPluginID(this.modelPluginID);
            }
            if (this.modelProjectLocationPath != null && this.modelFragmentPath != null) {
                modelImporter.setModelPluginDirectory(this.modelProjectLocationPath + "/./" + this.modelFragmentPath + "/.");
            }
            this.handleGenModelPath(this.genModelFullPath);
            modelImporter.setModelLocation(this.modelLocations);
        }
        finally {
            monitor.done();
        }
    }

    protected void handleGenModelPath(IPath genModelFullPath) {
        ModelImporter modelImporter = this.getModelImporter();
        if (this.reload) {
            try {
                modelImporter.defineOriginalGenModelPath(genModelFullPath);
            }
            catch (DiagnosticException exception) {
                throw new RuntimeException(exception);
            }
        } else {
            modelImporter.setGenModelContainerPath(genModelFullPath.removeLastSegments(1));
            modelImporter.setGenModelFileName(genModelFullPath.lastSegment());
        }
    }

    protected final void computeEPackages(Monitor monitor) throws Exception {
        try {
            monitor.beginTask("", 1);
            this.getModelImporter().computeEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
        }
        finally {
            monitor.done();
        }
    }

    protected void adjustEPackages(Monitor monitor) {
        try {
            monitor.beginTask("", 1);
            if (this.referencedGenModelURIToEPackageNSURIs != null) {
                ResourceSet resourceSet = this.getModelImporter().createResourceSet();
                for (Map.Entry<URI, Set<String>> entry : this.referencedGenModelURIToEPackageNSURIs.entrySet()) {
                    URI genModelURI = entry.getKey();
                    Set<String> ePackageNSURIs = entry.getValue();
                    File genModelFile = new File(genModelURI.toString());
                    if (genModelFile.isFile()) {
                        Path genModelPath = new Path(genModelFile.getAbsolutePath());
                        genModelURI = URI.createFileURI((String)genModelPath.toOSString());
                    }
                    Resource resource = resourceSet.getResource(genModelURI, true);
                    GenModel referencedGenModel = (GenModel)resource.getContents().get(0);
                    for (GenPackage genPackage : referencedGenModel.getGenPackages()) {
                        if (!ePackageNSURIs.contains(genPackage.getEcorePackage().getNsURI())) continue;
                        this.getModelImporter().getReferencedGenPackages().add(genPackage);
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void handleQualifiedEPackageName(EPackage ePackage) {
        String packageName = ePackage.getName();
        int index = packageName.lastIndexOf(".");
        if (index != -1) {
            this.getModelImporter().getEPackageImportInfo(ePackage).setBasePackage(packageName.substring(0, index));
            ePackage.setName(packageName.substring(index + 1));
        }
    }

    protected void handleEPackage(EPackage ePackage, boolean generate) {
        this.getModelImporter().getEPackageImportInfo(ePackage).setConvert(generate);
        if (!generate) {
            for (GenPackage genPackage : this.getModelImporter().getReferencedGenPackages()) {
                if (genPackage.getEcorePackage() != ePackage && (genPackage.getNSURI() == null || !genPackage.getNSURI().equals(ePackage.getNsURI()))) continue;
                return;
            }
            if (this.referencedEPackages == null) {
                this.referencedEPackages = new ArrayList<EPackage>();
            }
            this.referencedEPackages.add(ePackage);
        }
    }

    protected void adjustGenModel(Monitor monitor) {
        try {
            monitor.beginTask("", 1);
            GenModel genModel = this.getModelImporter().getGenModel();
            if (this.editProjectLocationPath != null) {
                genModel.setEditDirectory(this.editProjectLocationPath + "/./" + this.editFragmentPath + "/.");
            }
            if (this.editorProjectLocationPath != null) {
                genModel.setEditorDirectory(this.editorProjectLocationPath + "/./" + this.editorFragmentPath + "/.");
            }
            if (this.testsProjectLocationPath != null) {
                genModel.setTestsDirectory(this.testsProjectLocationPath + "/./" + this.testsFragmentPath + "/.");
            }
            if (this.templatePath != null) {
                genModel.setTemplateDirectory(this.templatePath);
                genModel.setDynamicTemplates(true);
            }
            if (this.copyright != null) {
                genModel.setCopyrightText(this.copyright);
            }
            if (this.sdo) {
                this.setSDODefaults(genModel);
            }
            if (this.genJDKLevel != null) {
                genModel.setComplianceLevel(this.genJDKLevel);
            }
            if (this.importOrganizing) {
                genModel.setImportOrganizing(true);
            }
            if (this.validateModel != null) {
                genModel.setValidateModel(Boolean.parseBoolean(this.validateModel));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void setSDODefaults(GenModel genModel) {
        Generator.setSDODefaults((GenModel)genModel);
    }

    protected void doExecute(Monitor monitor) throws Exception {
        try {
            monitor.beginTask("", 3);
            this.getModelImporter().prepareGenModelAndEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            this.adjustModelImporterAfterPrepare();
            this.handleReferencedEPackages();
            this.getModelImporter().saveGenModelAndEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
        }
        finally {
            monitor.done();
        }
    }

    protected void adjustModelImporterAfterPrepare() {
        GenModel genModel = this.getModelImporter().getGenModel();
        if (this.genJDKLevel != null) {
            genModel.setComplianceLevel(this.genJDKLevel);
        }
        genModel.setImportOrganizing(this.importOrganizing);
        if (!this.reload) {
            genModel.setOperationReflection(false);
            genModel.setRootExtendsClass("org.eclipse.emf.ecore.impl.EObjectImpl");
        }
    }

    protected void handleReferencedEPackages() {
        if (this.referencedEPackages != null && !this.referencedEPackages.isEmpty()) {
            ModelImporter modelImporter = this.getModelImporter();
            GenModel genModel = modelImporter.getGenModel();
            Resource genModelResource = genModel.eResource();
            GenModel referencedGenModel = (GenModel)EcoreUtil.create((EClass)genModel.eClass());
            genModelResource.getContents().add((Object)referencedGenModel);
            referencedGenModel.initialize(this.referencedEPackages);
            ImporterUtil.addUniqueGenPackages((List<GenPackage>)genModel.getUsedGenPackages(), (List<GenPackage>)referencedGenModel.getGenPackages());
            referencedGenModel.getForeignModel().addAll((Collection)genModel.getForeignModel());
            modelImporter.traverseGenPackages((List<GenPackage>)referencedGenModel.getGenPackages());
            Iterator i = referencedGenModel.getGenPackages().iterator();
            while (i.hasNext()) {
                GenPackage genPackage = (GenPackage)i.next();
                EPackage ePackage = genPackage.getEcorePackage();
                if (ePackage.eResource() == null) {
                    modelImporter.addToResource(ePackage, genModelResource.getResourceSet());
                }
                if ("http://www.eclipse.org/emf/2002/Ecore".equals(ePackage.getNsURI())) {
                    if (referencedGenModel.getGenPackages().size() == 1) {
                        referencedGenModel.setModelName("ecore");
                        referencedGenModel.setBooleanFlagsField("eFlags");
                        referencedGenModel.setBooleanFlagsReservedBits(8);
                        continue;
                    }
                    i.remove();
                    ImporterUtil.addUniqueGenPackages((List<GenPackage>)referencedGenModel.getUsedGenPackages(), Collections.singletonList(genPackage));
                    GenModel ecoreGenModel = (GenModel)EcoreUtil.create((EClass)genModel.eClass());
                    genModel.eResource().getContents().add((Object)ecoreGenModel);
                    ecoreGenModel.getGenPackages().add((Object)genPackage);
                    ecoreGenModel.setBooleanFlagsField("eFlags");
                    ecoreGenModel.setBooleanFlagsReservedBits(8);
                    ecoreGenModel.getForeignModel().addAll((Collection)genModel.getForeignModel());
                    ecoreGenModel.setModelName("ecore");
                    continue;
                }
                if (referencedGenModel.getModelName() != null) continue;
                referencedGenModel.setModelName(genPackage.getPackageName());
            }
        }
    }
}

