/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.examples.jet.article2.actionexample;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.examples.jet.article2.TypesafeEnumPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class EmitAction
implements IActionDelegate {
    protected ISelection selection;

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        action.setEnabled(true);
    }

    public void run(IAction action) {
        List files = this.selection instanceof IStructuredSelection ? ((IStructuredSelection)this.selection).toList() : Collections.EMPTY_LIST;
        for (IFile file : files) {
            IPath fullPath = file.getFullPath();
            String templateURI = URI.createPlatformResourceURI((String)fullPath.toString(), (boolean)true).toString();
            ClassLoader classloader = this.getClass().getClassLoader();
            JETEmitter emitter = new JETEmitter(templateURI, classloader);
            try {
                Object[] arguments = new String[]{"hi"};
                this.generate(emitter, arguments, file);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void generate(final JETEmitter emitter, final Object[] arguments, final IFile file) throws CoreException, InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    String generated = emitter.generate(monitor, arguments);
                    EmitAction.this.saveGenerated(generated, file, monitor);
                }
                catch (JETException exception) {
                    throw DiagnosticException.toCoreException((DiagnosticException)exception);
                }
                catch (IOException ioe) {
                    throw new InvocationTargetException(ioe);
                }
            }
        };
        Shell shell = TypesafeEnumPlugin.getActiveWorkbenchShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        dialog.run(false, true, (IRunnableWithProgress)op);
    }

    private void saveGenerated(String generated, IFile file, IProgressMonitor monitor) throws IOException, CoreException {
        ByteArrayInputStream contents = new ByteArrayInputStream(generated.getBytes());
        IContainer parent = file.getParent();
        IFile target = parent.getFile((IPath)new Path(String.valueOf(file.getName()) + ".txt"));
        if (target.exists()) {
            target.setContents((InputStream)contents, true, false, monitor);
        } else {
            File systemFile = target.getLocation().toFile();
            if (systemFile.exists()) {
                parent.refreshLocal(1, monitor);
                target.setContents((InputStream)contents, true, false, monitor);
            } else {
                target.create((InputStream)contents, false, monitor);
            }
        }
    }

    private void handleException(Throwable t) {
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        TypesafeEnumPlugin.log(t);
        Shell shell = TypesafeEnumPlugin.getActiveWorkbenchShell();
        String title = "Error while emitting template";
        DiagnosticDialog.open((Shell)shell, (String)title, null, (Diagnostic)BasicDiagnostic.toDiagnostic((Throwable)t));
    }
}

