/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.example.databinding.project.ui.rcp.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.example.databinding.project.ui.rcp.dialogs.PersonDialog;
import org.eclipse.emf.examples.databinding.project.core.IModelResource;
import org.eclipse.emf.examples.databinding.project.core.model.project.CommitterShip;
import org.eclipse.emf.examples.databinding.project.core.model.project.Person;
import org.eclipse.emf.examples.databinding.project.core.model.project.ProjectFactory;
import org.eclipse.emf.examples.databinding.project.core.model.project.ProjectPackage;
import org.eclipse.swt.widgets.Shell;

public class PersonEditingHandler
extends AbstractHandler {
    public static final String ACTION_PARAM = "org.eclipse.emf.examples.databinding.project.ui.rcp.person.action";
    public static final String ACTION_PARAM_VALUE_NEW = "new";
    public static final String ACTION_PARAM_VALUE_EDIT = "edit";

    /*
     * Enabled aggressive block sorting
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Person p;
        IStatus s;
        IEvaluationContext ctx = (IEvaluationContext)event.getApplicationContext();
        IModelResource resource = (IModelResource)ctx.getVariable("modelresource");
        Shell shell = (Shell)ctx.getVariable("activeWorkbenchWindowShell");
        String action = event.getParameter(ACTION_PARAM);
        if (action == null) return null;
        if (!action.equals(ACTION_PARAM_VALUE_NEW)) {
            if (!action.equals(ACTION_PARAM_VALUE_EDIT)) return null;
        }
        if (!(s = resource.setSavePoint()).isOK()) throw new ExecutionException("Could not set a save point");
        if (action.equals(ACTION_PARAM_VALUE_NEW)) {
            p = ProjectFactory.eINSTANCE.createPerson();
            Command cmd = AddCommand.create((EditingDomain)resource.getEditingDomain(), (Object)resource.getFoundation(), (Object)ProjectPackage.Literals.FOUNDATION__PERSONS, (Object)p);
            if (!cmd.canExecute()) {
                resource.rollback();
                throw new ExecutionException("Could not execute add command");
            }
            resource.executeCmd(cmd);
        } else {
            p = ((CommitterShip)ctx.getVariable("committer")).getPerson();
        }
        if (p == null) return null;
        PersonDialog dialog = new PersonDialog(shell, resource.getEditingDomain(), p);
        if (dialog.open() == 0) {
            resource.commit();
            return null;
        }
        resource.rollback();
        return null;
    }
}

