/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.owl.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.eclipse.eodm.exceptions.UnsupportedViewTypeException;
import org.eclipse.eodm.owl.resource.OWLXMLLoader;
import org.eclipse.eodm.owl.resource.OWLXMLResource;
import org.eclipse.eodm.owl.resource.OWLXMLSaver;
import org.eclipse.eodm.owl.resource.parser.exception.OWLParserException;
import org.eclipse.eodm.owl.resource.parser.impl.OWLOntologyGraph;
import org.eclipse.eodm.rdf.rdfweb.Document;

public class OWLXMLResourceImpl
extends ResourceImpl
implements OWLXMLResource {
    String defaultEncoding = null;

    public OWLXMLResourceImpl() {
    }

    public OWLXMLResourceImpl(URI uri) {
        super(uri);
    }

    protected byte[] readGuessBuffer(InputStream is) throws IOException {
        int bytesRead;
        int BUFFER_SIZE = 200;
        if (is.available() == 0) {
            return new byte[0];
        }
        byte[] buffer = new byte[BUFFER_SIZE];
        is.mark(BUFFER_SIZE);
        int totalBytesRead = bytesRead = is.read(buffer, 0, BUFFER_SIZE);
        while (bytesRead != -1 && totalBytesRead < BUFFER_SIZE) {
            bytesRead = is.read(buffer, totalBytesRead, BUFFER_SIZE - totalBytesRead);
            if (bytesRead == -1) continue;
            totalBytesRead += bytesRead;
        }
        if (totalBytesRead < BUFFER_SIZE) {
            byte[] smallerBuffer = new byte[totalBytesRead];
            System.arraycopy(buffer, 0, smallerBuffer, 0, totalBytesRead);
            smallerBuffer = buffer;
        }
        is.reset();
        return buffer;
    }

    protected String guessEncoding(InputStream is) throws IOException {
        if (!is.markSupported()) {
            return null;
        }
        return XMLHandler.getXMLEncoding((byte[])this.readGuessBuffer(is));
    }

    protected String getEncodingOption(Map options) {
        if (options == null) {
            return null;
        }
        Object obj = options.get("ENCODING");
        if (obj != null && obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    protected void doLoad(InputStream inputStream, Map options) throws IOException {
        String enc = this.getEncodingOption(options);
        if (enc == null) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            enc = this.guessEncoding(inputStream);
        }
        this.defaultEncoding = enc;
        try {
            OWLOntologyGraph[] ontograph = OWLXMLLoader.loadFromStream(inputStream, enc);
            if (ontograph != null) {
                this.getContents().add((Object)ontograph);
            }
        }
        catch (OWLParserException e) {
            IOException ie = new IOException("Exception in loading OWL Model from stream");
            ie.initCause(e);
            throw ie;
        }
    }

    protected void doSave(OutputStream output, Map options) throws IOException {
        String encoding = this.getEncodingOption(options);
        if (encoding == null) {
            encoding = this.defaultEncoding;
        }
        Document document = null;
        Iterator iterator = this.getContents().iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof Document)) continue;
            document = (Document)obj;
            break;
        }
        if (document != null) {
            if (encoding == null) {
                try {
                    OWLXMLSaver.saveToStream(document, output);
                }
                catch (UnsupportedViewTypeException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    OWLXMLSaver.saveToStream(document, output, encoding);
                }
                catch (UnsupportedViewTypeException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

